/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.persistence.util.TopiaEntityRefTester;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.Race;

public class TopiaEntityRefTesterTest
extends TopiaEntityRefTester<TopiaTestDAOHelper.TopiaTestEntityEnum> {
    private static final Log log = LogFactory.getLog(TopiaEntityRefTesterTest.class);
    private static final String PET1 = "pet1";
    private static final String PET2 = "pet2";
    private static final String RACE1 = "race1";
    private static final String PERSON1 = "person1";

    protected TopiaTestDAOHelper.TopiaTestEntityEnum[] getContracts0() {
        return new TopiaTestDAOHelper.TopiaTestEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Person, TopiaTestDAOHelper.TopiaTestEntityEnum.Race};
    }

    @Test
    public void testNoReferences() throws Exception {
        Pet pet = (Pet)this.newEntity(TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, PET1);
        this.detectReferences(pet, 0, new String[0]);
        Race race = (Race)this.newEntity(TopiaTestDAOHelper.TopiaTestEntityEnum.Race, RACE1);
        this.detectReferences(race, 0, new String[0]);
        Person person = (Person)this.newEntity(TopiaTestDAOHelper.TopiaTestEntityEnum.Person, PERSON1);
        this.detectReferences(person, 0, new String[0]);
    }

    @Test
    public void testReferences() throws Exception {
        Pet pet = (Pet)this.newEntity(TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, PET1);
        Race race = (Race)this.newEntity(TopiaTestDAOHelper.TopiaTestEntityEnum.Race, RACE1);
        pet.setRace(race);
        Person person = (Person)this.newEntity(TopiaTestDAOHelper.TopiaTestEntityEnum.Person, PERSON1);
        this.detectReferences(pet, 1, RACE1);
        this.nextEntry();
        this.assertCurrentEntry(race, 1);
        this.assertNextEntityRef(pet, "race", pet, race);
        pet.setPerson(person);
        this.detectReferences(pet, 2, RACE1, PERSON1);
        this.nextEntry();
        this.assertCurrentEntry(person, 1);
        this.assertNextEntityRef(pet, "person", pet, person);
        this.nextEntry();
        this.assertCurrentEntry(race, 1);
        this.assertNextEntityRef(pet, "race", pet, race);
        person.addPet(pet);
        this.detectReferences(person, 1, PET1);
        this.nextEntry();
        this.assertCurrentEntry(pet, 1);
        this.assertNextAssociationEntityRef(person, "pet", PET1, person, pet);
        Pet pet2 = (Pet)this.newEntity(TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, PET2);
        person.addPet(pet2);
        this.detectReferences(person, 3, PET1, PET2, RACE1);
        this.nextEntry();
        this.assertCurrentEntry(pet, 1);
        this.assertNextAssociationEntityRef(person, "pet", PET1, person, pet);
        this.nextEntry();
        this.assertCurrentEntry(pet2, 1);
        this.assertNextAssociationEntityRef(person, "pet", PET2, person, pet2);
        this.nextEntry();
        this.assertCurrentEntry(race, 1);
        this.assertNextEntityRef(pet, "race", person, pet, race);
        pet2.setRace(race);
        this.detectReferences(person, 3, PET1, PET2, RACE1);
        this.nextEntry();
        this.assertCurrentEntry(pet, 1);
        this.assertNextAssociationEntityRef(person, "pet", PET1, person, pet);
        this.nextEntry();
        this.assertCurrentEntry(pet2, 1);
        this.assertNextAssociationEntityRef(person, "pet", PET2, person, pet2);
        this.nextEntry();
        this.assertCurrentEntry(race, 2);
        this.assertNextEntityRef(pet, "race", person, pet, race);
        this.assertNextEntityRef(pet2, "race", person, pet2, race);
    }
}

