/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;

public class TopiaDatabase
extends TestWatcher {
    private static final Log log = LogFactory.getLog(TopiaDatabase.class);
    public static final String TIMESTAMP = String.valueOf(System.nanoTime());
    private File testBasedir;
    private Properties dbConfiguration;
    private TopiaContext rootCtxt;
    private final String configurationPath;

    public TopiaDatabase() {
        this("/TopiaContextImpl.properties");
    }

    public TopiaDatabase(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    protected void starting(Description description) {
        this.testBasedir = TopiaDatabase.getTestSpecificDirectory(description.getTestClass(), description.getMethodName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("testBasedir = " + this.testBasedir));
        }
        try {
            this.dbConfiguration = new Properties();
            try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(this.configurationPath);){
                this.dbConfiguration.load(stream);
            }
            this.dbConfiguration.setProperty("topia.persistence.classes", TopiaTestDAOHelper.getImplementationClassesAsString());
            String dbPath = new File(this.testBasedir, "db").getAbsolutePath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("dbPath = " + dbPath));
            }
            this.dbConfiguration.setProperty("hibernate.connection.url", "jdbc:h2:file:" + dbPath);
            this.onDbConfigurationCreate(this.dbConfiguration, this.testBasedir, dbPath);
            this.rootCtxt = TopiaContextFactory.getContext((Properties)this.dbConfiguration);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start db at " + this.testBasedir, e);
        }
    }

    public void finished(Description description) {
        block3: {
            if (this.rootCtxt != null && !this.rootCtxt.isClosed()) {
                try {
                    this.rootCtxt.closeContext();
                }
                catch (TopiaException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Could not close topia root context", (Throwable)e);
                }
            }
        }
        this.rootCtxt = null;
        this.dbConfiguration = null;
    }

    public File getTestBasedir() {
        return this.testBasedir;
    }

    public TopiaContext getRootCtxt() {
        return this.rootCtxt;
    }

    public Properties getDbConfiguration() {
        return this.dbConfiguration;
    }

    public TopiaContext beginTransaction() throws TopiaException {
        return this.rootCtxt.beginTransaction();
    }

    protected void onDbConfigurationCreate(Properties configuration, File testDir, String dbPath) {
    }

    public static File getTestSpecificDirectory(Class<?> testClassName, String methodName) {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        if (tempDirPath == null) {
            tempDirPath = "";
            if (log.isWarnEnabled()) {
                log.warn((Object)"'\"java.io.tmpdir\" not defined");
            }
        }
        File tempDirFile = new File(tempDirPath);
        String dataBasePath = testClassName.getName() + File.separator + methodName + '_' + TIMESTAMP;
        File databaseFile = new File(tempDirFile, dataBasePath);
        return databaseFile;
    }
}

