package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Mon Jan 27 13:46:52 CET 2020")
public abstract class AddressAbstract extends TopiaEntityAbstract implements Address {

    /**
     * Nom de l'attribut en BD : city
     */
    protected String city;

    /**
     * Nom de l'attribut en BD : adress
     */
    protected String adress;

    private static final long serialVersionUID = 7364059611317613409L;

    static {
    
        I18n.n("topia.test.common.address");
        I18n.n("topia.test.common.city");
        I18n.n("topia.test.common.adress");
    }

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_CITY, String.class, city);
        visitor.visit(this, PROPERTY_ADRESS, String.class, adress);
    }

    @Override
    public void setCity(String city) {
        String oldValue = this.city;
        fireOnPreWrite(PROPERTY_CITY, oldValue, city);
        this.city = city;
        fireOnPostWrite(PROPERTY_CITY, oldValue, city);
    }

    @Override
    public String getCity() {
        fireOnPreRead(PROPERTY_CITY, city);

        String result = this.city;

        fireOnPostRead(PROPERTY_CITY, city);

        return result;
    }

    @Override
    public void setAdress(String adress) {
        String oldValue = this.adress;
        fireOnPreWrite(PROPERTY_ADRESS, oldValue, adress);
        this.adress = adress;
        fireOnPostWrite(PROPERTY_ADRESS, oldValue, adress);
    }

    @Override
    public String getAdress() {
        fireOnPreRead(PROPERTY_ADRESS, adress);

        String result = this.adress;

        fireOnPostRead(PROPERTY_ADRESS, adress);

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_CITY, this.city).
            append(PROPERTY_ADRESS, this.adress).
         toString();
        return result;
    }

} //AddressAbstract
