/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.csv.in;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportToMap;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.csv.CsvProgressModel;
import org.nuiton.topia.persistence.csv.in.CsvImportResult;
import org.nuiton.topia.persistence.csv.in.ImportModelFactory;
import org.nuiton.topia.persistence.csv.in.ImportStrategy;
import org.nuiton.topia.persistence.metadata.AssociationMeta;
import org.nuiton.topia.persistence.metadata.MetaFilenameAware;
import org.nuiton.topia.persistence.metadata.TableMeta;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public class TopiaCsvImports {
    private static final Log log = LogFactory.getLog(TopiaCsvImports.class);
    protected static final String UPDATE_ASSOCIATION = "UPDATE %s SET %s = '%%s' WHERE topiaId ='%%s';";
    protected static final String INSERT_ASSOCIATION = "INSERT INTO %s (%s,%s) VALUES('%%s','%%s');";

    protected TopiaCsvImports() {
    }

    public static <T extends TopiaEntityEnum, M extends MetaFilenameAware<T>> Map<M, ZipEntry> discoverEntries(String entryPrefix, Iterable<M> possibleMetas, ZipFile zipFile, List<String> missingEntries) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (MetaFilenameAware entry : possibleMetas) {
            String filename = entry.getFilename();
            ZipEntry zipEntry = zipFile.getEntry(entryPrefix + filename);
            if (zipEntry == null) {
                missingEntries.add(filename);
                continue;
            }
            result.put(entry, zipEntry);
        }
        return result;
    }

    public static <T extends TopiaEntityEnum, M extends MetaFilenameAware<T>> Map<M, File> discoverEntries(Iterable<M> possibleMetas, File directory, List<String> missingEntries) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (MetaFilenameAware entry : possibleMetas) {
            String filename = entry.getFilename();
            File zipEntry = new File(directory, filename);
            if (zipEntry.exists()) {
                result.put(entry, zipEntry);
                continue;
            }
            missingEntries.add(filename);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TopiaEntityEnum, E extends TopiaEntity> void importTable(Reader reader, ImportStrategy<T> importStrategy, TableMeta<T> meta, CsvImportResult<T> csvResult) throws TopiaException, IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import " + meta));
        }
        ImportModel model = importStrategy.getModelFactory().buildForImport(meta);
        Import importer = Import.newImport(model, (Reader)reader);
        try {
            importStrategy.importTable(meta, importer, csvResult);
        }
        finally {
            importer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TopiaEntityEnum, E extends TopiaEntity> Iterable<E> importTableAndReturn(Reader reader, ImportStrategy<T> importStrategy, TableMeta<T> meta, CsvImportResult<T> csvResult) throws TopiaException, IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import " + meta));
        }
        ImportModel model = importStrategy.getModelFactory().buildForImport(meta);
        Import importer = Import.newImport(model, (Reader)reader);
        try {
            Iterable iterable = importStrategy.importTableAndReturnThem(meta, importer, csvResult);
            return iterable;
        }
        finally {
            importer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TopiaEntityEnum> void importAssociation(Reader reader, ImportStrategy<T> importStrategy, AssociationMeta<T> meta, CsvImportResult<T> csvResult) throws IOException, TopiaException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import " + meta));
        }
        ImportModelFactory<T> modelFactory = importStrategy.getModelFactory();
        ImportModel<Map<String, Object>> model = modelFactory.buildForImport(meta);
        ImportToMap importer = ImportToMap.newImportToMap(model, (Reader)reader, (boolean)false);
        try {
            importStrategy.importAssociation(meta, importer, csvResult);
        }
        finally {
            importer.close();
        }
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> void importAllEntities(TopiaDAO<E> dao, TableMeta<T> meta, Import<E> importer, CsvImportResult<T> csvResult) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        for (TopiaEntity entity : importer) {
            Map<String, Object> properties = meta.prepareCreate(entity, entity.getTopiaId());
            Map<String, Object> entityToSave = dao.create(properties);
            meta.copy(entity, (TopiaEntity)((Object)entityToSave));
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> void importAllEntities(TopiaDAO<E> dao, TableMeta<T> meta, Import<E> importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        TopiaContextImplementor context = dao.getContext();
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        int compt = 0;
        for (TopiaEntity entity : importer) {
            Map<String, Object> properties = meta.prepareCreate(entity, entity.getTopiaId());
            Map<String, Object> entityToSave = dao.create(properties);
            meta.copy(entity, (TopiaEntity)((Object)entityToSave));
            if (csvResult != null) {
                csvResult.incrementsNumberUpdated();
                if (progressModel != null) {
                    progressModel.incrementsProgress();
                }
            }
            if (++compt % nbRowBuffer != 0) continue;
            context.getHibernate().flush();
        }
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> Iterable<E> importAllEntitiesAndReturnThem(TopiaDAO<E> dao, TableMeta<T> meta, Import<E> importer, CsvImportResult<T> csvResult) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        ArrayList result = Lists.newArrayList();
        for (TopiaEntity entity : importer) {
            Map<String, Object> properties = meta.prepareCreate(entity, entity.getTopiaId());
            Map<String, Object> entityToSave = dao.create(properties);
            meta.copy(entity, (TopiaEntity)((Object)entityToSave));
            if (csvResult != null) {
                csvResult.incrementsNumberUpdated();
                if (progressModel != null) {
                    progressModel.incrementsProgress();
                }
            }
            result.add(entityToSave);
        }
        return result;
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> void importNotExistingEntities(TopiaDAO<E> dao, TableMeta<T> meta, Map<String, TopiaEntity> universe, Import<E> importer, CsvImportResult<T> csvResult) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        for (TopiaEntity entity : importer) {
            String topiaId = entity.getTopiaId();
            Map<String, Object> properties = meta.prepareCreate(entity, null);
            Map<String, Object> existingEntity = dao.findByProperties(properties);
            if (existingEntity == null) {
                Map<String, Object> entityToSave = dao.create(properties);
                String newTopiaId = entityToSave.getTopiaId();
                Date topiaCreateDate = entityToSave.getTopiaCreateDate();
                meta.copy(entity, (TopiaEntity)((Object)entityToSave));
                entityToSave.setTopiaId(newTopiaId);
                entityToSave.setTopiaCreateDate(topiaCreateDate);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Create entity [%s becomes %s] with naturalId %s", topiaId, newTopiaId, properties));
                }
                universe.put(topiaId, (TopiaEntity)((Object)entityToSave));
                if (csvResult == null) continue;
                csvResult.incrementsNumberCreated();
                if (progressModel == null) continue;
                progressModel.incrementsProgress();
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Existing entity [%s] with naturalId %s, do not create anything", topiaId, properties));
            }
            universe.put(topiaId, (TopiaEntity)((Object)existingEntity));
        }
    }

    public static <T extends TopiaEntityEnum> void importAssociation(TopiaContext tx, AssociationMeta<T> meta, ImportToMap importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        T source = meta.getSource();
        T target = meta.getTarget();
        StringBuilder builder = new StringBuilder();
        String targetTableName = target.getContract().getSimpleName();
        String sourceTableName = source.getContract().getSimpleName();
        String table = targetTableName;
        String updateString = String.format(UPDATE_ASSOCIATION, table, sourceTableName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply " + updateString));
        }
        int compt = 0;
        for (Map row : importer) {
            String[] associations;
            String topiaId = (String)row.get("topiaId");
            for (String association : associations = (String[])row.get("target")) {
                if (!StringUtils.isNotEmpty((CharSequence)association)) continue;
                builder.append(String.format(updateString, topiaId, association)).append('\n');
                if (++compt % nbRowBuffer != 0) continue;
                tx.executeSQL(builder.toString());
                builder = new StringBuilder();
            }
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
        if (builder.length() > 0) {
            tx.executeSQL(builder.toString());
        }
    }

    public static <T extends TopiaEntityEnum> void importNMAssociation(TopiaContext tx, AssociationMeta<T> meta, ImportToMap importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        T source = meta.getSource();
        T target = meta.getTarget();
        StringBuilder builder = new StringBuilder();
        String targetTableName = target.getContract().getSimpleName();
        String sourceTableName = source.getContract().getSimpleName();
        String table = TopiaEntityHelper.getNormalizedAssociationTableName(sourceTableName, targetTableName);
        String updateString = String.format(INSERT_ASSOCIATION, table, sourceTableName, targetTableName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply " + updateString));
        }
        int compt = 0;
        for (Map row : importer) {
            String[] associations;
            String topiaId = (String)row.get("topiaId");
            for (String association : associations = (String[])row.get("target")) {
                if (!StringUtils.isNotEmpty((CharSequence)association)) continue;
                builder.append(String.format(updateString, topiaId, association)).append('\n');
                if (++compt % nbRowBuffer != 0) continue;
                tx.executeSQL(builder.toString());
                builder = new StringBuilder();
            }
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
        if (builder.length() > 0) {
            tx.executeSQL(builder.toString());
        }
    }

    public static <T extends TopiaEntityEnum> void importNMAssociation(TopiaContext tx, AssociationMeta<T> meta, Map<String, TopiaEntity> universe, ImportToMap importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        T source = meta.getSource();
        T target = meta.getTarget();
        StringBuilder builder = new StringBuilder();
        String targetTableName = target.getContract().getSimpleName();
        String sourceTableName = source.getContract().getSimpleName();
        String table = TopiaEntityHelper.getNormalizedAssociationTableName(sourceTableName, targetTableName);
        String updateString = String.format(INSERT_ASSOCIATION, table, sourceTableName, targetTableName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply " + updateString));
        }
        int compt = 0;
        for (Map row : importer) {
            String[] associations;
            String topiaId = (String)row.get("topiaId");
            for (String association : associations = (String[])row.get("target")) {
                if (!StringUtils.isNotEmpty((CharSequence)association)) continue;
                TopiaEntity targetEntity = universe.get(association);
                Preconditions.checkNotNull((Object)targetEntity, (Object)("Could not find target entity from id: " + association));
                builder.append(String.format(updateString, topiaId, targetEntity.getTopiaId())).append('\n');
                if (++compt % nbRowBuffer != 0) continue;
                tx.executeSQL(builder.toString());
                builder = new StringBuilder();
            }
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
        if (builder.length() > 0) {
            tx.executeSQL(builder.toString());
        }
    }

    public static <T extends TopiaEntityEnum> void importAssociation(TopiaContext tx, AssociationMeta<T> meta, Map<String, TopiaEntity> universe, ImportToMap importer, CsvImportResult<T> csvResult, int nbRowBuffer) throws TopiaException {
        CsvProgressModel progressModel = csvResult == null ? null : csvResult.getProgressModel();
        T source = meta.getSource();
        T target = meta.getTarget();
        StringBuilder builder = new StringBuilder();
        String targetTableName = target.getContract().getSimpleName();
        String sourceTableName = source.getContract().getSimpleName();
        String table = targetTableName;
        String updateString = String.format(UPDATE_ASSOCIATION, table, sourceTableName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply " + updateString));
        }
        int compt = 0;
        for (Map row : importer) {
            String[] associations;
            String topiaId = (String)row.get("topiaId");
            for (String association : associations = (String[])row.get("target")) {
                if (!StringUtils.isNotEmpty((CharSequence)association)) continue;
                TopiaEntity targetEntity = universe.get(association);
                Preconditions.checkNotNull((Object)targetEntity, (Object)("Could not find target entity from id: " + association));
                builder.append(String.format(updateString, topiaId, targetEntity.getTopiaId())).append('\n');
                if (++compt % nbRowBuffer != 0) continue;
                tx.executeSQL(builder.toString());
                builder = new StringBuilder();
            }
            if (csvResult == null) continue;
            csvResult.incrementsNumberUpdated();
            if (progressModel == null) continue;
            progressModel.incrementsProgress();
        }
        if (builder.length() > 0) {
            tx.executeSQL(builder.toString());
        }
    }
}

