/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.bean.list;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.BeanUtil;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorFactory;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.AbstractNuitonValidatorContext;
import org.nuiton.validator.bean.AbstractValidator;
import org.nuiton.validator.bean.list.BeanListValidatorEvent;
import org.nuiton.validator.bean.list.BeanListValidatorListener;

public class BeanListValidator<O>
extends AbstractValidator<O> {
    private static final Log log = LogFactory.getLog(BeanListValidator.class);
    protected final Map<O, NuitonValidatorContext<O>> contexts = Maps.newHashMap();
    protected NuitonValidator<O> delegate;

    public static <O> BeanListValidator<O> newValidator(Class<O> type, String context, NuitonValidatorScope ... scopes) throws NullPointerException {
        String providerName = NuitonValidatorFactory.getDefaultProviderName();
        BeanListValidator<O> beanValidator = BeanListValidator.newValidator(providerName, type, context, scopes);
        return beanValidator;
    }

    public static <O> BeanListValidator<O> newValidator(String providerName, Class<O> type, String context, NuitonValidatorScope ... scopes) throws NullPointerException {
        Preconditions.checkNotNull(type, (Object)"type parameter can not be null.");
        NuitonValidatorProvider provider = NuitonValidatorFactory.getProvider(providerName);
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (Object)("Could not find provider with name " + providerName));
        BeanListValidator<O> validator = new BeanListValidator<O>(provider, type, context, scopes);
        return validator;
    }

    public BeanListValidator(NuitonValidatorProvider validatorProvider, Class<O> beanClass, String context) {
        this(validatorProvider, beanClass, context, NuitonValidatorScope.values());
    }

    public BeanListValidator(NuitonValidatorProvider validatorProvider, Class<O> beanClass, String context, NuitonValidatorScope ... scopes) {
        super(validatorProvider, beanClass);
        this.rebuildDelegateValidator(beanClass, context, scopes);
        this.firePropertyChange("context", null, context);
        this.firePropertyChange("scopes", null, scopes);
    }

    public void addBean(O bean) {
        block3: {
            Preconditions.checkNotNull(bean);
            Preconditions.checkState((!this.contexts.containsKey(bean) ? 1 : 0) != 0, (Object)("The bean " + bean + " is already registred in this validator."));
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " : " + bean));
            }
            NuitonValidator validator = this.validatorProvider.newValidator(this.getModel());
            NuitonValidatorContext<O> newcontext = new NuitonValidatorContext<O>(bean, validator);
            newcontext.setValidator(validator);
            newcontext.setBean(bean);
            this.contexts.put(bean, newcontext);
            this.setCanValidate(this.isCanValidate() && newcontext.isCanValidate());
            try {
                BeanUtil.addPropertyChangeListener((PropertyChangeListener)this.l, bean);
            }
            catch (Exception eee) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)("Can't register as listener for bean " + bean.getClass() + " for reason " + eee.getMessage()), (Throwable)eee);
            }
        }
        this.validate(bean);
        this.setChanged(false);
        this.setValid(this.isValid0());
    }

    public void addAllBeans(Collection<O> beansToAdd) {
        for (O bean : beansToAdd) {
            this.addBean(bean);
        }
    }

    public void removeBean(O bean) {
        block3: {
            Preconditions.checkNotNull(bean);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " : " + bean));
            }
            NuitonValidatorContext<O> context = this.getContext(bean);
            this.mergeMessages(context, null);
            this.contexts.remove(bean);
            try {
                BeanUtil.removePropertyChangeListener((PropertyChangeListener)this.l, bean);
            }
            catch (Exception eee) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)("Can't unregister as listener for bean " + bean.getClass() + " for reason " + eee.getMessage()), (Throwable)eee);
            }
        }
    }

    public void removeAllBeans(Collection<O> beansToRemove) {
        for (O bean : beansToRemove) {
            this.removeBean(bean);
        }
    }

    public void removeAllBeans() {
        Set<O> beansToRemove = this.getBeans();
        this.removeAllBeans(beansToRemove);
    }

    @Override
    public boolean hasFatalErrors() {
        NuitonValidatorContext<O> context;
        boolean result = false;
        Iterator<NuitonValidatorContext<O>> iterator = this.contexts.values().iterator();
        while (iterator.hasNext() && !(result = (context = iterator.next()).hasFatalErrors())) {
        }
        return result;
    }

    @Override
    public boolean hasErrors() {
        NuitonValidatorContext<O> context;
        boolean result = false;
        Iterator<NuitonValidatorContext<O>> iterator = this.contexts.values().iterator();
        while (iterator.hasNext() && !(result = (context = iterator.next()).hasErrors())) {
        }
        return result;
    }

    @Override
    public boolean hasWarnings() {
        NuitonValidatorContext<O> context;
        boolean result = false;
        Iterator<NuitonValidatorContext<O>> iterator = this.contexts.values().iterator();
        while (iterator.hasNext() && !(result = (context = iterator.next()).hasWarnings())) {
        }
        return result;
    }

    @Override
    public boolean hasInfos() {
        NuitonValidatorContext<O> context;
        boolean result = false;
        Iterator<NuitonValidatorContext<O>> iterator = this.contexts.values().iterator();
        while (iterator.hasNext() && !(result = (context = iterator.next()).hasInfos())) {
        }
        return result;
    }

    @Override
    public boolean isValid(String fieldName) {
        NuitonValidatorContext<O> context;
        boolean result = true;
        Iterator<NuitonValidatorContext<O>> iterator = this.contexts.values().iterator();
        while (iterator.hasNext() && (result = (context = iterator.next()).isValid(fieldName))) {
        }
        return result;
    }

    @Override
    public NuitonValidatorScope getHighestScope(String field) {
        HashSet scopes = Sets.newHashSet();
        for (NuitonValidatorContext<O> context : this.contexts.values()) {
            scopes.add(context.getHighestScope(field));
        }
        NuitonValidatorScope scope = null;
        if (scopes.isEmpty()) {
            ArrayList scopeList = Lists.newArrayList((Iterable)scopes);
            Collections.sort(scopeList);
            scope = (NuitonValidatorScope)((Object)scopeList.get(0));
        }
        return scope;
    }

    @Override
    public void doValidate() {
        this.validate();
        this.setValid(this.isValid0());
        this.setChanged(true);
    }

    @Override
    public <T> T convert(O bean, String fieldName, String value, Class<T> valueClass) {
        NuitonValidatorContext<O> context = this.getContext(bean);
        T convert = null;
        try {
            convert = context.convert(fieldName, value, valueClass);
        }
        catch (ConversionException e) {
            this.validate();
        }
        return convert;
    }

    public void addBeanListValidatorListener(BeanListValidatorListener listener) {
        this.listenerList.add(BeanListValidatorListener.class, listener);
    }

    public void removeBeanListValidatorListener(BeanListValidatorListener listener) {
        this.listenerList.remove(BeanListValidatorListener.class, listener);
    }

    public BeanListValidatorListener[] getBeanListValidatorListeners() {
        return (BeanListValidatorListener[])this.listenerList.getListeners(BeanListValidatorListener.class);
    }

    public Set<O> getBeans() {
        return ImmutableSet.copyOf(this.contexts.keySet());
    }

    @Override
    protected void doValidate(O bean) {
        this.validate(bean);
        this.setValid(this.isValid0());
        this.setChanged(true);
    }

    @Override
    protected NuitonValidator<O> getDelegate() {
        return this.delegate;
    }

    @Override
    protected void rebuildDelegateValidator(Class<O> beanType, String context, NuitonValidatorScope ... scopes) {
        if (scopes == null || scopes.length == 0) {
            scopes = NuitonValidatorScope.values();
        }
        NuitonValidatorModel<O> model = this.validatorProvider.getModel(beanType, context, scopes);
        this.delegate = this.validatorProvider.newValidator(model);
    }

    protected void validate() {
        if (this.isCanValidate()) {
            for (O bean : this.contexts.keySet()) {
                this.validate(bean);
            }
        }
    }

    protected void validate(O bean) {
        NuitonValidatorContext<O> validator = this.getContext(bean);
        NuitonValidatorResult result = validator.validate();
        this.mergeMessages(validator, result);
    }

    protected boolean isValid0() {
        NuitonValidatorContext<O> context;
        boolean result = true;
        Iterator<NuitonValidatorContext<O>> iterator = this.contexts.values().iterator();
        while (iterator.hasNext() && (result = (context = iterator.next()).isValid())) {
        }
        return result;
    }

    protected void mergeMessages(NuitonValidatorContext<O> context, NuitonValidatorResult newMessages) {
        List events = context.mergeMessages(this, newMessages);
        if (CollectionUtils.isNotEmpty(events)) {
            for (BeanListValidatorEvent event : events) {
                this.fireFieldChanged(event);
            }
        }
    }

    protected void fireFieldChanged(BeanListValidatorEvent evt) {
        for (BeanListValidatorListener listener : (BeanListValidatorListener[])this.listenerList.getListeners(BeanListValidatorListener.class)) {
            listener.onFieldChanged(evt);
        }
    }

    public NuitonValidatorContext<O> getContext(O bean) {
        NuitonValidatorContext<O> context = this.contexts.get(bean);
        Preconditions.checkState((context != null ? 1 : 0) != 0, (Object)("Bean " + bean + " was not register in this list validator"));
        return context;
    }

    public static class NuitonValidatorContext<O>
    extends AbstractNuitonValidatorContext<O, BeanListValidator<O>, BeanListValidatorEvent> {
        public NuitonValidatorContext(O bean, NuitonValidator<O> validator) {
            this.setValidator(validator);
            this.setBean(bean);
        }

        @Override
        protected BeanListValidatorEvent createEvent(BeanListValidator<O> source, O bean, String field, NuitonValidatorScope scope, String[] toAdd, String[] toDelete) {
            return new BeanListValidatorEvent(source, bean, field, scope, toAdd, toDelete);
        }
    }
}

