/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.ActionContext;
import java.util.Locale;
import org.junit.Test;
import org.nuiton.validator.xwork2.field.AbstractFieldValidatorTest;
import org.nuiton.validator.xwork2.field.FieldExpressionBean;

public class FieldExpressionWithParamsValidatorTest
extends AbstractFieldValidatorTest<FieldExpressionBean> {
    public static final String MESSAGE = "expression.too.big##100";
    public static final String MESSAGE2 = "expression.too.big##100##2000";

    public FieldExpressionWithParamsValidatorTest() {
        super(FieldExpressionBean.class);
    }

    @Override
    @Test
    public void testValidator() throws Exception {
        ActionContext.getContext().setLocale(Locale.ENGLISH);
        this.testBooleanType();
        this.testShortType();
        this.testIntType();
        this.testLongType();
        this.testDoubleType();
        this.testStringType();
    }

    protected void testBooleanType() {
        FieldExpressionWithParamsValidatorTest.assertEquals((Object)false, (Object)((FieldExpressionBean)this.bean).isBooleanValue());
        this.assertFieldInError("booleanValue", "expression.boolean.not.equals##true", true);
        this.assertFieldInError("booleanValue", "expression.boolean.not.equals##false", false);
        ((FieldExpressionBean)this.bean).setBooleanValue(true);
        this.assertFieldInError("booleanValue", "expression.boolean.not.equals##true", false);
        this.assertFieldInError("booleanValue", "expression.boolean.not.equals##false", true);
    }

    protected void testShortType() {
        FieldExpressionWithParamsValidatorTest.assertEquals((long)0L, (long)((FieldExpressionBean)this.bean).getShortValue());
        this.assertFieldInError("shortValue", MESSAGE, false);
        this.assertFieldInError("shortValue", MESSAGE2, false);
        ((FieldExpressionBean)this.bean).setShortValue((short)10);
        this.assertFieldInError("shortValue", MESSAGE, false);
        this.assertFieldInError("shortValue", MESSAGE2, false);
        ((FieldExpressionBean)this.bean).setShortValue((short)1000);
        this.assertFieldInError("shortValue", MESSAGE, true);
        this.assertFieldInError("shortValue", MESSAGE2, false);
        ((FieldExpressionBean)this.bean).setShortValue((short)3000);
        this.assertFieldInError("shortValue", MESSAGE, true);
        this.assertFieldInError("shortValue", MESSAGE2, true);
    }

    protected void testIntType() {
        FieldExpressionWithParamsValidatorTest.assertEquals((long)0L, (long)((FieldExpressionBean)this.bean).getIntValue());
        this.assertFieldInError("intValue", MESSAGE, false);
        this.assertFieldInError("intValue", MESSAGE2, false);
        ((FieldExpressionBean)this.bean).setIntValue(10);
        this.assertFieldInError("intValue", MESSAGE, false);
        this.assertFieldInError("intValue", MESSAGE2, false);
        ((FieldExpressionBean)this.bean).setIntValue(1000);
        this.assertFieldInError("intValue", MESSAGE, true);
        this.assertFieldInError("intValue", MESSAGE2, false);
        ((FieldExpressionBean)this.bean).setIntValue(3000);
        this.assertFieldInError("intValue", MESSAGE, true);
        this.assertFieldInError("intValue", MESSAGE2, true);
    }

    protected void testLongType() {
        FieldExpressionWithParamsValidatorTest.assertEquals((long)0L, (long)((FieldExpressionBean)this.bean).getLongValue());
        this.assertFieldInError("longValue", MESSAGE, false);
        this.assertFieldInError("longValue", MESSAGE2, false);
        ((FieldExpressionBean)this.bean).setLongValue(10L);
        this.assertFieldInError("longValue", MESSAGE, false);
        this.assertFieldInError("longValue", MESSAGE2, false);
        ((FieldExpressionBean)this.bean).setLongValue(1000L);
        this.assertFieldInError("longValue", MESSAGE, true);
        this.assertFieldInError("longValue", MESSAGE2, false);
        ((FieldExpressionBean)this.bean).setLongValue(3000L);
        this.assertFieldInError("longValue", MESSAGE, true);
        this.assertFieldInError("longValue", MESSAGE2, true);
    }

    protected void testDoubleType() {
        FieldExpressionWithParamsValidatorTest.assertEquals((double)0.0, (double)((FieldExpressionBean)this.bean).getDoubleValue(), (double)0.0);
        this.assertFieldInError("doubleValue", "expression.too.big##100.0", false);
        this.assertFieldInError("doubleValue", "expression.too.big##100.0##2000.0", false);
        ((FieldExpressionBean)this.bean).setDoubleValue(10.0);
        this.assertFieldInError("doubleValue", "expression.too.big##100.0", false);
        this.assertFieldInError("doubleValue", "expression.too.big##100.0##2000.0", false);
        ((FieldExpressionBean)this.bean).setDoubleValue(1000.0);
        this.assertFieldInError("doubleValue", "expression.too.big##100.0", true);
        this.assertFieldInError("doubleValue", "expression.too.big##100.0##2000.0", false);
        ((FieldExpressionBean)this.bean).setDoubleValue(3000.0);
        this.assertFieldInError("doubleValue", "expression.too.big##100.0", true);
        this.assertFieldInError("doubleValue", "expression.too.big##100.0##2000.0", true);
    }

    protected void testStringType() {
        FieldExpressionWithParamsValidatorTest.assertEquals(null, (Object)((FieldExpressionBean)this.bean).getStringValue());
        this.assertFieldInError("stringValue", "expression.stringNotValue##1000", true);
        this.assertFieldInError("stringValue", "expression.stringNotValue##1000##3000", true);
        ((FieldExpressionBean)this.bean).setStringValue("100");
        this.assertFieldInError("stringValue", "expression.stringNotValue##1000", true);
        this.assertFieldInError("stringValue", "expression.stringNotValue##1000##3000", true);
        ((FieldExpressionBean)this.bean).setStringValue("1000");
        this.assertFieldInError("stringValue", "expression.stringNotValue##1000", false);
        this.assertFieldInError("stringValue", "expression.stringNotValue##1000##3000", false);
        ((FieldExpressionBean)this.bean).setStringValue("3000");
        this.assertFieldInError("stringValue", "expression.stringNotValue##1000", true);
        this.assertFieldInError("stringValue", "expression.stringNotValue##1000##3000", false);
    }
}

