/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.MapUtils;
import org.nuiton.validator.NuitonValidatorScope;

public class NuitonValidatorResult {
    protected EnumMap<NuitonValidatorScope, FieldMap<List<String>>> messages;
    protected Map<String, FieldMap<Object>> tagValues;

    public boolean isValid() {
        return !this.hasFatalMessages() && !this.hasErrorMessagess();
    }

    public boolean hasMessagesForScope(NuitonValidatorScope scope) {
        boolean result = false;
        if (this.messages != null) {
            FieldMap<List<String>> map = this.messages.get((Object)scope);
            result = !MapUtils.isEmpty(map);
        }
        return result;
    }

    public boolean hasMessagesForScope(String field, NuitonValidatorScope scope) {
        boolean result = false;
        if (this.messages != null && (result = this.messages.containsKey((Object)scope))) {
            FieldMap<List<String>> fieldMap = this.messages.get((Object)scope);
            result = fieldMap != null && fieldMap.containsKey(field);
        }
        return result;
    }

    public boolean hasFatalMessages() {
        boolean result = this.hasMessagesForScope(NuitonValidatorScope.FATAL);
        return result;
    }

    public boolean hasErrorMessagess() {
        boolean result = this.hasMessagesForScope(NuitonValidatorScope.ERROR);
        return result;
    }

    public boolean hasInfoMessages() {
        boolean result = this.hasMessagesForScope(NuitonValidatorScope.INFO);
        return result;
    }

    public boolean hasWarningMessages() {
        boolean result = this.hasMessagesForScope(NuitonValidatorScope.WARNING);
        return result;
    }

    public void addMessagesForScope(NuitonValidatorScope scope, Map<String, List<String>> newMessages) {
        FieldMap<List<String>> fieldMap;
        if (this.messages == null) {
            this.messages = new EnumMap(NuitonValidatorScope.class);
        }
        if ((fieldMap = this.messages.get((Object)scope)) == null) {
            fieldMap = new FieldMap();
            this.messages.put(scope, fieldMap);
        }
        for (Map.Entry<String, List<String>> entry : newMessages.entrySet()) {
            String fieldName = entry.getKey();
            List<String> messages = entry.getValue();
            List<String> oldMessages = (List<String>)fieldMap.get(fieldName);
            if (oldMessages == null) {
                oldMessages = messages;
                fieldMap.put(fieldName, oldMessages);
                continue;
            }
            oldMessages.addAll(messages);
        }
    }

    public void setMessagesForScope(NuitonValidatorScope scope, String field, List<String> messages) {
        FieldMap<List<String>> fieldMap;
        if (this.messages == null) {
            this.messages = new EnumMap(NuitonValidatorScope.class);
        }
        if ((fieldMap = this.messages.get((Object)scope)) == null) {
            fieldMap = new FieldMap();
            this.messages.put(scope, fieldMap);
        }
        fieldMap.put(field, messages);
    }

    public List<String> getMessagesForScope(NuitonValidatorScope scope) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.messages != null) {
            FieldMap<List<String>> fieldMap = this.messages.get((Object)scope);
            for (List messages : fieldMap.values()) {
                result.addAll(messages);
            }
        }
        return result;
    }

    public List<String> getMessagesForScope(String field, NuitonValidatorScope scope) {
        List result = null;
        if (this.messages != null) {
            FieldMap<List<String>> fieldMap = this.messages.get((Object)scope);
            result = (List)fieldMap.get(field);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<String> getFatalMessages(String field) {
        List<String> result = this.getMessagesForScope(field, NuitonValidatorScope.FATAL);
        return result;
    }

    public List<String> getErrorMessages(String field) {
        List<String> result = this.getMessagesForScope(field, NuitonValidatorScope.ERROR);
        return result;
    }

    public List<String> getInfoMessages(String field) {
        List<String> result = this.getMessagesForScope(field, NuitonValidatorScope.INFO);
        return result;
    }

    public List<String> getWarningMessages(String field) {
        List<String> result = this.getMessagesForScope(field, NuitonValidatorScope.WARNING);
        return result;
    }

    public Map<String, Object> getTagValues(String field) {
        Map result = null;
        if (this.tagValues != null) {
            result = this.tagValues.get(field);
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    public List<String> getFieldsForScope(NuitonValidatorScope scope) {
        FieldMap<List<String>> fieldMap;
        List<String> result = null;
        if (this.messages != null && (fieldMap = this.messages.get((Object)scope)) != null) {
            result = new ArrayList(fieldMap.keySet());
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<String> getFieldsForFatal() {
        List<String> result = this.getFieldsForScope(NuitonValidatorScope.FATAL);
        return result;
    }

    public List<String> getFieldsForError() {
        List<String> result = this.getFieldsForScope(NuitonValidatorScope.ERROR);
        return result;
    }

    public List<String> getFieldsForInfo() {
        List<String> result = this.getFieldsForScope(NuitonValidatorScope.INFO);
        return result;
    }

    public List<String> getFieldsForWarning() {
        List<String> result = this.getFieldsForScope(NuitonValidatorScope.WARNING);
        return result;
    }

    public void clearMessagesForScope(NuitonValidatorScope scope) {
        if (this.messages != null) {
            this.messages.remove((Object)scope);
        }
    }

    public NuitonValidatorScope getFieldHighestScope(String field) {
        if (this.messages == null) {
            return null;
        }
        if (this.containsField(field, NuitonValidatorScope.FATAL)) {
            return NuitonValidatorScope.FATAL;
        }
        if (this.containsField(field, NuitonValidatorScope.ERROR)) {
            return NuitonValidatorScope.ERROR;
        }
        if (this.containsField(field, NuitonValidatorScope.WARNING)) {
            return NuitonValidatorScope.WARNING;
        }
        if (this.containsField(field, NuitonValidatorScope.INFO)) {
            return NuitonValidatorScope.INFO;
        }
        return null;
    }

    public NuitonValidatorScope[] getFieldScopes(String field) {
        HashSet<NuitonValidatorScope> result = new HashSet<NuitonValidatorScope>();
        if (this.messages != null) {
            if (this.containsField(field, NuitonValidatorScope.FATAL)) {
                result.add(NuitonValidatorScope.FATAL);
            }
            if (this.containsField(field, NuitonValidatorScope.ERROR)) {
                result.add(NuitonValidatorScope.ERROR);
            }
            if (this.containsField(field, NuitonValidatorScope.WARNING)) {
                result.add(NuitonValidatorScope.WARNING);
            }
            if (this.containsField(field, NuitonValidatorScope.INFO)) {
                result.add(NuitonValidatorScope.INFO);
            }
        }
        return result.toArray(new NuitonValidatorScope[result.size()]);
    }

    protected boolean containsField(String field, NuitonValidatorScope scope) {
        FieldMap<List<String>> fieldMap = this.messages.get((Object)scope);
        return fieldMap != null && fieldMap.containsKey(field);
    }

    protected EnumMap<NuitonValidatorScope, FieldMap<List<String>>> getMessages() {
        return this.messages;
    }

    protected Map<String, FieldMap<Object>> getTagValues() {
        return this.tagValues;
    }

    public static class FieldMap<V>
    extends TreeMap<String, V> {
        private static final long serialVersionUID = 1L;
    }
}

