/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import org.junit.Test;
import org.nuiton.validator.model.Company;
import org.nuiton.validator.xwork2.field.AbstractFieldValidatorTest;
import org.nuiton.validator.xwork2.field.FrenchSiretFieldValidator;

public class FrenchSiretFieldValidatorTest
extends AbstractFieldValidatorTest<Company> {
    public FrenchSiretFieldValidatorTest() {
        super(Company.class);
    }

    @Test
    public void TestLuhnChecksum() throws Exception {
        FrenchSiretFieldValidatorTest.assertTrue((boolean)FrenchSiretFieldValidator.luhnChecksum((String)"44211670300038"));
        FrenchSiretFieldValidatorTest.assertTrue((boolean)FrenchSiretFieldValidator.luhnChecksum((String)"73282932000074"));
        FrenchSiretFieldValidatorTest.assertFalse((boolean)FrenchSiretFieldValidator.luhnChecksum((String)"44211670300030"));
        FrenchSiretFieldValidatorTest.assertFalse((boolean)FrenchSiretFieldValidator.luhnChecksum((String)"73282932000070"));
    }

    @Override
    @Test
    public void testValidator() throws Exception {
        FrenchSiretFieldValidatorTest.assertNull((Object)((Company)this.bean).getSiret());
        ((Company)this.bean).setSiret("44211670300038");
        this.assertFieldInError("siret", "company.siret.format", false);
        ((Company)this.bean).setSiret("73282932000074");
        this.assertFieldInError("siret", "company.siret.format", false);
        ((Company)this.bean).setSiret("73282932000071");
        this.assertFieldInError("siret", "company.siret.format", true);
        ((Company)this.bean).setSiret("4421167030003");
        this.assertFieldInError("siret", "company.siret.format", true);
        ((Company)this.bean).setSiret("442116703000389");
        this.assertFieldInError("siret", "company.siret.format", true);
        ((Company)this.bean).setSiret("4421bf1670300038");
        this.assertFieldInError("siret", "company.siret.format", true);
        ((Company)this.bean).setSiret("");
        this.assertFieldInError("siret", "company.siret.format", false);
        ((Company)this.bean).setSiret(null);
        this.assertFieldInError("siret", "company.siret.format", false);
    }
}

