/* *##% NuitonMatrix
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.math.matrix.gui;

import static org.nuiton.i18n.I18n._;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.FileUtil;

/**
 * Ajout d'un menu contextuel sur la matrice dans l'editeur.
 * 
 * Created: 22 mars 2006 12:11:46
 *
 * @author ruchaud
 * @version $Revision: 187 $
 *
 * Last update: $Date: 2009-10-16 19:17:29 +0200 (ven., 16 oct. 2009) $
 * by : $Author: tchemit $
 * @deprecated since 1.0.0, shoudl really use a JAXX based file instead of this
 * strange by hand coded class.
 * 
 */
@Deprecated
public class MatrixPopupMenu extends JPopupMenu {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3349189688987885915L;

    private MatrixEditor matrixEditor;
    private JFileChooser fileChooser;

    private JMenu sendToClipBoard;
    private JMenu sendToFile;

    private JCheckBoxMenuItem withSemantics;

    private Action sendToClipBoardAllCopyAction;
    private Action sendToClipBoardAllPasteAction;
    private Action sendToClipBoardSelectionCopyAction;
    private Action sendToClipBoardCurrentPasteAction;

    private Action sendToFileAllCopyAction;
    private Action sendToFileAllPasteAction;
    private Action sendToFileSelectionCopyAction;
    private Action sendToFileCurrentPasteAction;

    public MatrixPopupMenu(MatrixEditor matrixEditor) {
        super();
        this.matrixEditor = matrixEditor;

        sendToClipBoard = getSendToClipBoard();
        sendToFile = getSendToFile();

        withSemantics = new JCheckBoxMenuItem(
                _("nuitonmatrix.menu.option.semantics"), false);

        add(sendToClipBoard);
        add(sendToFile);
        add(new JSeparator());
        add(withSemantics);
    }

    /**
     * @return retourne le menu d'action pour le bloc note
     */
    public JMenu getSendToClipBoard() {
        if (sendToClipBoard == null) {
            sendToClipBoard = new JMenu(_("nuitonmatrix.menu.action"));
            JMenuItem sendToClipBoardAllCopy = new JMenuItem(
                    _("nuitonmatrix.menu.action.copy"));
            JMenuItem sendToClipBoardAllPaste = new JMenuItem(
                    _("nuitonmatrix.menu.action.paste"));
            JMenuItem sendToClipBoardSelectionCopy = new JMenuItem(
                    _("nuitonmatrix.menu.action.copy.selection"));
            JMenuItem sendToClipBoardCurrentPaste = new JMenuItem(
                    _("nuitonmatrix.menu.action.paste.position"));

            sendToClipBoard.add(sendToClipBoardAllCopy);
            sendToClipBoard.add(sendToClipBoardAllPaste);
            sendToClipBoard.add(new JSeparator());
            sendToClipBoard.add(sendToClipBoardSelectionCopy);
            sendToClipBoard.add(sendToClipBoardCurrentPaste);

            sendToClipBoardAllCopy
                    .addActionListener(getSendToClipBoardAllCopyAction());
            sendToClipBoardAllPaste
                    .addActionListener(getSendToClipBoardAllPasteAction());
            sendToClipBoardSelectionCopy
                    .addActionListener(getSendToClipBoardSelectionCopyAction());
            sendToClipBoardCurrentPaste
                    .addActionListener(getSendToClipBoardCurrentPasteAction());
        }

        return sendToClipBoard;
    }

    /**
     * @return retourne le menu d'action pour les fichiers CSV
     */
    public JMenu getSendToFile() {
        if (sendToFile == null) {
            sendToFile = new JMenu(_("nuitonmatrix.menu.csv"));
            JMenuItem sendToFileAllCopy = new JMenuItem(
                    _("nuitonmatrix.menu.csv.export.file"));
            JMenuItem sendToFileAllPaste = new JMenuItem(
                    _("nuitonmatrix.menu.csv.import.file"));
            JMenuItem sendToFileSelectionCopy = new JMenuItem(
                    _("nuitonmatrix.menu.csv.export.selection"));
            JMenuItem sendToFileCurrentPaste = new JMenuItem(
                    _("nuitonmatrix.menu.csv.import.position"));

            sendToFile.add(sendToFileAllCopy);
            sendToFile.add(sendToFileAllPaste);
            sendToFile.add(new JSeparator());
            sendToFile.add(sendToFileSelectionCopy);
            sendToFile.add(sendToFileCurrentPaste);

            sendToFileAllCopy.addActionListener(getSendToFileAllCopyAction());
            sendToFileAllPaste.addActionListener(getSendToFileAllPasteAction());
            sendToFileSelectionCopy
                    .addActionListener(getSendToFileSelectionCopyAction());
            sendToFileCurrentPaste
                    .addActionListener(getSendToFileCurrentPasteAction());
        }

        return sendToFile;
    }

    /**
     * @return retourne un writer du fichier choisi dans le selecteur de fichier
     * @throws IOException
     */
    private Writer getFileChooserWriter() throws IOException {
        int returnVal = getFileChooser().showOpenDialog(matrixEditor);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File selectedFile = getFileChooser().getSelectedFile();
            return FileUtil.getWriter(selectedFile);
        }
        return null;
    }

    /**
     * @return retourne un writer pour le bloc note
     */
    private Writer getClipBoardWriter() {
        return new StringWriter();
    }

    /**
     * @return retourne un reader du fichier choisi dans le selecteur de fichier
     * @throws IOException
     */
    private Reader getFileChooserReader() throws IOException {
        int returnVal = getFileChooser().showOpenDialog(matrixEditor);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File selectedFile = getFileChooser().getSelectedFile();
            return FileUtil.getReader(selectedFile);
        }
        return null;
    }

    /**
     * @return retourne le contenu du bloc note sous la forme d'un reader
     */
    private Reader getClipBoardReader() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(clipboard);
        if (contents != null) {
            try {
                String data = (String) contents
                        .getTransferData(DataFlavor.stringFlavor);
                return new StringReader(data);
            } catch (Exception e) {
                JOptionPane.showMessageDialog(matrixEditor,
                        "Impossible de coller les données", "Warning",
                        JOptionPane.WARNING_MESSAGE);
                e.printStackTrace();
            }
        }
        return null;
    }

    /**
     * Desactive le menu si la matrice ne supporte pas le mode CSV
     */
    @Override
    protected void firePopupMenuWillBecomeVisible() {
        if (!getMatrix().isSupportedCSV()) {
            sendToClipBoard.setEnabled(false);
            sendToFile.setEnabled(false);
        } else {
            sendToClipBoard.setEnabled(true);
            sendToFile.setEnabled(true);
        }
        super.firePopupMenuWillBecomeVisible();
    }

    /**
     * @return Matrice en cours de saisie dans l'editeur
     */
    private MatrixND getMatrix() {
        return matrixEditor.getMatrix();
    }

    /**
     * @return la sous matrice en cours de saisie dans l'editeur c'est a dire la
     *         partie selectionnee
     */
    private MatrixND getSelectedMatrix() {
        int beginSelectedColumn = matrixEditor.getTable().getSelectedColumn();
        int nbSelectedColumn = matrixEditor.getTable().getSelectedColumnCount();

        /* Prend en compte le décalage des lignes par rapport aux dimenssions */
        int nbColumnDimRow = matrixEditor.getMatrix().getDimCount() - 1;
        beginSelectedColumn -= nbColumnDimRow;
        if (beginSelectedColumn < 0) {
            beginSelectedColumn = 0;
            nbSelectedColumn -= nbColumnDimRow;
        }

        int beginSelectedRow = matrixEditor.getTable().getSelectedRow() - 1;
        int nbSelectedRow = matrixEditor.getTable().getSelectedRowCount();

        MatrixND result = null;
        if (getMatrix().getDimCount() == 1) {
            result = matrixEditor.getMatrix().getSubMatrix(0,
                    beginSelectedColumn, nbSelectedColumn);
        } else {
            result= matrixEditor.getMatrix().getSubMatrix(0, beginSelectedRow,
                    nbSelectedRow).getSubMatrix(1, beginSelectedColumn,
                    nbSelectedColumn);
        }
        return result;
    }

    /**
     * @return retourne les coordonnees de la première cellule selectionnee
     */
    private int[] getCoordinatesFirstCellSelectedMatrix() {
        int selectedColumn = matrixEditor.getTable().getSelectedColumn();

        /* Prend en compte le décalage des lignes par rapport aux dimenssions */
        int nbColumnDimRow = matrixEditor.getMatrix().getDimCount() - 1;
        selectedColumn -= nbColumnDimRow;
        if (selectedColumn < 0) {
            selectedColumn = 0;
        }

        int selectedRow = matrixEditor.getTable().getSelectedRow() - 1;

        return new int[] { selectedRow, selectedColumn };
    }

    /**
     * @return Selecteur de fichier CSV
     */
    private JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            FileFilter filter = new FileFilter() {
                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        return true;
                    }

                    String extension = FileUtil.extension(pathname);
                    if (extension != null) {
                        if (extension.equals("csv")) {
                            return true;
                        } else {
                            return false;
                        }
                    }

                    return false;
                }

                @Override
                public String getDescription() {
                    return "Texte CSV (*.csv)";
                }
            };
            fileChooser.setFileFilter(filter);
        }
        return fileChooser;
    }

    /**
     * @return retourne l'action du bloc note permettant la copie entere de la
     *         matrice
     */
    public Action getSendToClipBoardAllCopyAction() {
        if (sendToClipBoardAllCopyAction == null) {
            sendToClipBoardAllCopyAction = new AbstractAction() {
                private static final long serialVersionUID=1L;
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendToClipBoardAllCopyPerformed();
                }
            };
        }
        return sendToClipBoardAllCopyAction;
    }

    /**
     * @return retourne l'action du bloc note permettant la recopie entere de la
     *         matrice depuis le bloc note
     */
    public Action getSendToClipBoardAllPasteAction() {
        if (sendToClipBoardAllPasteAction == null) {
            sendToClipBoardAllPasteAction = new AbstractAction() {
                private static final long serialVersionUID=1L;
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendToClipBoardAllPastePerformed();
                }
            };
        }
        return sendToClipBoardAllPasteAction;
    }

    /**
     * @return retourne l'action du bloc note permettant la copie de la partie
     *         selectionnee
     */
    public Action getSendToClipBoardSelectionCopyAction() {
        if (sendToClipBoardSelectionCopyAction == null) {
            sendToClipBoardSelectionCopyAction = new AbstractAction() {
                private static final long serialVersionUID=1L;
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendToClipBoardSelectionCopyPerformed();
                }
            };
        }
        return sendToClipBoardSelectionCopyAction;
    }

    /**
     * @return retourne l'action du bloc note permettant la recopie de la partie
     *         selectionnee de la matrice depuis le bloc note
     */
    public Action getSendToClipBoardCurrentPasteAction() {
        if (sendToClipBoardCurrentPasteAction == null) {
            sendToClipBoardCurrentPasteAction = new AbstractAction() {
                private static final long serialVersionUID=1L;
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendToClipBoardCurrentPastePerformed();
                }
            };
        }
        return sendToClipBoardCurrentPasteAction;
    }

    protected void sendToClipBoardAllCopyPerformed() {
        try {
            Writer writer = getClipBoardWriter();
            getMatrix().exportCSV(writer, withSemantics.getState());
            StringSelection contents = new StringSelection(writer.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit()
                    .getSystemClipboard();
            clipboard.setContents(contents, contents);
            writer.close();
            matrixEditor.repaint();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(matrixEditor,
                    _("nuitonmatrix.error.clipboard.write"),
                    _("nuitonmatrix.error"), JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
        }
    }

    protected void sendToClipBoardAllPastePerformed() {
        try {
            Reader reader = getClipBoardReader();
            getMatrix().importCSV(reader, new int[] { 0, 0 });
            reader.close();
            matrixEditor.fireEvent();
            matrixEditor.repaint();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(matrixEditor,
                    _("nuitonmatrix.error.clipboard.read"),
                    _("nuitonmatrix.error"), JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
        }
    }

    protected void sendToClipBoardSelectionCopyPerformed() {
        try {
            Writer writer = getClipBoardWriter();
            getSelectedMatrix().exportCSV(writer, withSemantics.getState());
            StringSelection contents = new StringSelection(writer.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit()
                    .getSystemClipboard();
            clipboard.setContents(contents, contents);
            writer.close();
            matrixEditor.repaint();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(matrixEditor,
                    _("nuitonmatrix.error.clipboard.write"),
                    _("nuitonmatrix.error"), JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
        }
    }

    protected void sendToClipBoardCurrentPastePerformed() {
        try {
            Reader reader = getClipBoardReader();
            getMatrix().importCSV(reader,
                    getCoordinatesFirstCellSelectedMatrix());
            reader.close();
            matrixEditor.fireEvent();
            matrixEditor.repaint();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(matrixEditor,
                    _("nuitonmatrix.error.clipboard.read"),
                    _("nuitonmatrix.error"), JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
        }
    }

    /**
     * @return retourne l'action du fichier permettant la copie entere de la
     *         matrice
     */
    public Action getSendToFileAllCopyAction() {
        if (sendToFileAllCopyAction == null) {
            sendToFileAllCopyAction = new AbstractAction() {
                private static final long serialVersionUID=1L;
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendToFileAllCopyPerformed();
                }
            };
        }
        return sendToFileAllCopyAction;
    }

    /**
     * @return retourne l'action du fichier permettant la recopie entere de la
     *         matrice depuis le fichier
     */
    public Action getSendToFileAllPasteAction() {
        if (sendToFileAllPasteAction == null) {
            sendToFileAllPasteAction = new AbstractAction() {
                private static final long serialVersionUID=1L;
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendToFileAllPastePerformed();
                }
            };
        }
        return sendToFileAllPasteAction;
    }

    /**
     * @return retourne l'action du fichier permettant la copie de la partie
     *         selectionnee
     */
    public Action getSendToFileSelectionCopyAction() {
        if (sendToFileSelectionCopyAction == null) {
            sendToFileSelectionCopyAction = new AbstractAction() {
                private static final long serialVersionUID=1L;
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendToFileSelectionCopyPerformed();
                }
            };
        }
        return sendToFileSelectionCopyAction;
    }

    /**
     * @return retourne l'action du fichier permettant la recopie de la partie
     *         selectionnee de la matrice depuis le fichier
     */
    public Action getSendToFileCurrentPasteAction() {
        if (sendToFileCurrentPasteAction == null) {
            sendToFileCurrentPasteAction = new AbstractAction() {
                private static final long serialVersionUID=1L;
                @Override
                public void actionPerformed(ActionEvent e) {
                    sendToFileCurrentPastePerformed();
                }
            };
        }
        return sendToFileCurrentPasteAction;
    }

    protected void sendToFileAllCopyPerformed() {
        try {
            Writer writer = getFileChooserWriter();
            if (writer != null) {
                getMatrix().exportCSV(writer, withSemantics.getState());
                writer.close();
                matrixEditor.repaint();
            }
        } catch (Exception e) {
            JOptionPane.showMessageDialog(matrixEditor,
                    _("nuitonmatrix.error.file.write"), _("nuitonmatrix.error"),
                    JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
        }
    }

    protected void sendToFileAllPastePerformed() {
        try {
            Reader reader = getFileChooserReader();
            if (reader != null) { // cancel
                getMatrix().importCSV(reader, new int[] { 0, 0 });
                reader.close();
                matrixEditor.fireEvent();
                matrixEditor.repaint();
            }
        } catch (Exception e) {
            JOptionPane.showMessageDialog(matrixEditor,
                    _("nuitonmatrix.error.file.read"), _("nuitonmatrix.error"),
                    JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
        }
    }

    protected void sendToFileSelectionCopyPerformed() {
        try {
            Writer writer = getFileChooserWriter();
            if (writer != null) {
                getSelectedMatrix().exportCSV(writer, withSemantics.getState());
                writer.close();
                matrixEditor.repaint();
            }
        } catch (Exception e) {
            JOptionPane.showMessageDialog(matrixEditor,
                    _("nuitonmatrix.error.file.write"), _("nuitonmatrix.error"),
                    JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
        }
    }

    protected void sendToFileCurrentPastePerformed() {
        try {
            Reader reader = getFileChooserReader();
            if (reader != null) { // cancel
                getMatrix().importCSV(reader,
                        getCoordinatesFirstCellSelectedMatrix());
                reader.close();
                matrixEditor.fireEvent();
                matrixEditor.repaint();
            }
        } catch (Exception e) {
            JOptionPane.showMessageDialog(matrixEditor,
                    _("nuitonmatrix.error.file.read"), _("nuitonmatrix.error"),
                    JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
        }
    }
}
