/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.Vector;

public class LazyVector
implements Vector {
    private static Log log = LogFactory.getLog(LazyVector.class);
    protected boolean isInitBackend = false;
    protected Vector backend;
    protected AtomicInteger users = new AtomicInteger();
    protected int capacity;

    public LazyVector(Vector backend, int capacity) {
        this.backend = backend;
        this.capacity = capacity;
    }

    @Override
    public void init(int capacity) {
    }

    @Override
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        double result = 0.0;
        if (this.isInitBackend) {
            result = this.backend.getMaxOccurrence();
        }
        return result;
    }

    @Override
    public double getValue(int pos) {
        double result = 0.0;
        if (this.isInitBackend) {
            result = this.backend.getValue(pos);
        }
        return result;
    }

    @Override
    public void setValue(int pos, double value) {
        this.prepareBackendForModification();
        this.backend.setValue(pos, value);
    }

    @Override
    public int size() {
        return this.capacity;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return true;
    }

    @Override
    public boolean isImplementedAdd(Vector v) {
        return this.backend.isImplementedAdd(v);
    }

    @Override
    public boolean isImplementedMinus(Vector v) {
        return this.backend.isImplementedMinus(v);
    }

    @Override
    public boolean isImplementedMap() {
        return this.backend.isImplementedMap();
    }

    @Override
    public void paste(Vector source) {
        if (!this.isInitBackend && source instanceof LazyVector && ((LazyVector)source).size() == this.size()) {
            LazyVector l = (LazyVector)source;
            l.users.incrementAndGet();
            this.users = l.users;
            this.isInitBackend = l.isInitBackend;
            this.backend = l.backend;
        } else {
            this.prepareBackendForModification();
            this.pasteToBackend(this.backend, source);
        }
    }

    @Override
    public void add(Vector v) {
        this.prepareBackendForModification();
        this.backend.add(v);
    }

    @Override
    public void minus(Vector v) {
        this.prepareBackendForModification();
        this.backend.minus(v);
    }

    @Override
    public void map(MapFunction f) {
        this.prepareBackendForModification();
        this.backend.map(f);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            if (this.size() == v.size()) {
                result = this.isInitBackend ? v.equals(this.backend) : (v instanceof LazyVector && !((LazyVector)v).isInitBackend ? true : v.equals(this));
            }
        }
        return result;
    }

    protected void prepareBackendForModification() {
        if (this.users.get() > 0) {
            try {
                Vector copy = (Vector)this.backend.getClass().newInstance();
                if (this.isInitBackend) {
                    copy.init(this.capacity);
                    this.pasteToBackend(copy, this.backend);
                }
                this.backend = copy;
                this.users.decrementAndGet();
                this.users = new AtomicInteger();
            }
            catch (Exception eee) {
                throw new MatrixException("Can't create new backend Vector", eee);
            }
        }
        if (!this.isInitBackend) {
            this.backend.init(this.capacity);
            this.isInitBackend = true;
        }
    }

    protected void pasteToBackend(Vector target, Vector copy) {
        if (target.isImplementedPaste(copy)) {
            target.paste(copy);
        } else {
            int max = Math.min(this.size(), copy.size());
            for (int i = 0; i < max; ++i) {
                double v = copy.getValue(i);
                target.setValue(i, v);
            }
        }
    }
}

