/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProject;
import org.nuiton.jredmine.plugin.RedmineVersionAware;

public abstract class AbstractRedmineMojoWithProjectAndVersion
extends AbstractRedmineMojoWithProject
implements RedmineVersionAware {
    @Parameter(property="redmine.versionId", defaultValue="${project.version}")
    protected String versionId;
    protected Version releaseVersion;

    public AbstractRedmineMojoWithProjectAndVersion(boolean requireUser) {
        super(requireUser);
    }

    @Override
    protected boolean checkSkip() {
        boolean canContinue = super.checkSkip();
        if (canContinue && this.releaseVersion == null) {
            this.getLog().error((CharSequence)("the version '" + this.versionId + "' could not be retrieve from redmine server, goal is skip"));
            canContinue = false;
        }
        return canContinue;
    }

    @Override
    protected void init() throws Exception {
        boolean r;
        super.init();
        if (this.initOk && !(r = this.initReleaseVersion())) {
            if (this.isSafe()) {
                throw new MojoExecutionException("the version '" + this.versionId + "' could not be retrieve from redmine server.");
            }
            this.initOk = false;
        }
    }

    protected boolean initReleaseVersion() throws MojoExecutionException {
        if (this.versionId == null || this.versionId.trim().isEmpty()) {
            throw new MojoExecutionException("required a versionId parameter");
        }
        try {
            Version v = this.service.getVersion(this.projectId, this.versionId);
            if (v == null) {
                return false;
            }
            this.releaseVersion = v;
            return true;
        }
        catch (RedmineServiceException e) {
            this.getLog().warn((CharSequence)("could not retreave version '" + this.versionId + "', for reason " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public final String getVersionId() {
        return this.versionId;
    }

    @Override
    public final void setVersionId(String versionId) {
        this.versionId = versionId;
    }
}

