/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jredmine.client.RedmineClient;
import org.nuiton.jredmine.client.RedmineClientAuthConfiguration;
import org.nuiton.jredmine.service.RedmineServiceConfiguration;

public class RedmineConfigurationUtil {
    private static final Log log = LogFactory.getLog(RedmineConfigurationUtil.class);
    public static final String PROPERTY_PREFIX = "jredmine-test.";

    protected RedmineConfigurationUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedmineServiceConfiguration obtainRedmineConfiguration(RedmineServiceConfiguration anoConf) throws IOException {
        RedmineServiceConfiguration conf = RedmineConfigurationUtil.newLogguedConfiguration(anoConf);
        boolean ok = false;
        RedmineClient client = new RedmineClient(conf);
        try {
            client.open();
            ok = client.isOpen();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not connect to redmine with configuration: " + conf), (Throwable)e);
            }
        }
        finally {
            block27: {
                try {
                    client.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block27;
                    log.error((Object)"Could not close session", (Throwable)e);
                }
            }
        }
        if (!ok) {
            conf = RedmineConfigurationUtil.cloneConfiguration(anoConf);
            client = new RedmineClient(conf);
            try {
                client.open();
                ok = client.isOpen();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not connect to redmine with configuration: " + conf), (Throwable)e);
                }
            }
            finally {
                block29: {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block29;
                        log.error((Object)"Could not close session", (Throwable)e);
                    }
                }
            }
        }
        if (!ok) {
            conf = null;
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedmineServiceConfiguration newAnonymousConfiguration(String propertiesFromEnv, String classPathPropertiesLocation) throws IOException {
        Properties props = new Properties();
        InputStream in = null;
        try {
            String jredmineConfiguration = System.getenv(propertiesFromEnv);
            if (jredmineConfiguration == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Could not find environement variable 'jredmine-test.properties' will use default test configuration");
                }
                in = RedmineConfigurationUtil.class.getResourceAsStream(classPathPropertiesLocation);
            } else {
                File file = new File(jredmineConfiguration);
                if (!file.exists()) {
                    throw new IllegalStateException("Could not find " + jredmineConfiguration + " file");
                }
                in = FileUtils.openInputStream((File)file);
            }
            props.load(in);
            in.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        SimpleRedmineServiceConfiguration result = new SimpleRedmineServiceConfiguration();
        RedmineClientAuthConfiguration authConfiguration = new RedmineClientAuthConfiguration();
        result.setAuthConfiguration(authConfiguration);
        RedmineConfigurationUtil.overridePropertyFromProperties(result, "url", props);
        RedmineConfigurationUtil.overridePropertyFromProperties(result, "encoding", props);
        RedmineConfigurationUtil.overridePropertyFromProperties(result, "verbose", props);
        RedmineConfigurationUtil.overridePropertyFromProperties(authConfiguration, "username", props);
        RedmineConfigurationUtil.overridePropertyFromProperties(authConfiguration, "password", props);
        RedmineConfigurationUtil.overridePropertyFromProperties(authConfiguration, "apiKey", props);
        RedmineConfigurationUtil.overridePropertyFromEnv(result, "url");
        RedmineConfigurationUtil.overridePropertyFromEnv(result, "encoding");
        RedmineConfigurationUtil.overridePropertyFromEnv(result, "verbose");
        result.setAnonymous(true);
        return result;
    }

    public static RedmineServiceConfiguration newLogguedConfiguration(RedmineServiceConfiguration anoConf) throws IOException {
        RedmineServiceConfiguration result = RedmineConfigurationUtil.cloneConfiguration(anoConf);
        RedmineClientAuthConfiguration authConfiguration = result.getAuthConfiguration();
        RedmineConfigurationUtil.overridePropertyFromEnv(authConfiguration, "username");
        RedmineConfigurationUtil.overridePropertyFromEnv(authConfiguration, "password");
        RedmineConfigurationUtil.overridePropertyFromEnv(authConfiguration, "apiKey");
        result.setAnonymous(false);
        return result;
    }

    public static RedmineServiceConfiguration cloneConfiguration(RedmineServiceConfiguration src) {
        SimpleRedmineServiceConfiguration dst = new SimpleRedmineServiceConfiguration();
        RedmineConfigurationUtil.copyConfiguration(src, dst);
        return dst;
    }

    public static void copyConfiguration(RedmineServiceConfiguration src, RedmineServiceConfiguration dst) {
        dst.setUrl(src.getUrl());
        dst.setEncoding(src.getEncoding());
        dst.setVerbose(src.isVerbose());
        dst.setAnonymous(src.isAnonymous());
        RedmineClientAuthConfiguration authConfiguration = new RedmineClientAuthConfiguration();
        authConfiguration.setApiKey(src.getAuthConfiguration().getApiKey());
        authConfiguration.setUsername(src.getAuthConfiguration().getUsername());
        authConfiguration.setPassword(src.getAuthConfiguration().getPassword());
        dst.setAuthConfiguration(authConfiguration);
    }

    protected static void overridePropertyFromProperties(Object conf, String prop, Properties props) throws IOException {
        String value = props.getProperty(PROPERTY_PREFIX + prop);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                BeanUtilsBean.getInstance().setProperty(conf, prop, (Object)value);
            }
            catch (Exception e) {
                throw new IOException("Could not set property '" + prop + "' with value '" + value + "' to configuration");
            }
        }
    }

    protected static void overridePropertyFromEnv(Object conf, String prop) throws IOException {
        String value = System.getenv(PROPERTY_PREFIX + prop);
        if (StringUtils.isNotEmpty((CharSequence)value) && !"null".equals(value)) {
            try {
                BeanUtilsBean.getInstance().setProperty(conf, prop, (Object)value);
            }
            catch (Exception e) {
                throw new IOException("Could not set property '" + prop + "' with value '" + value + "' to configuration");
            }
        }
    }

    public static class SimpleRedmineServiceConfiguration
    implements RedmineServiceConfiguration {
        URL url;
        boolean verbose;
        boolean anonymous;
        String encoding;
        RedmineClientAuthConfiguration authConfiguration;

        @Override
        public RedmineClientAuthConfiguration getAuthConfiguration() {
            return this.authConfiguration;
        }

        @Override
        public void setAuthConfiguration(RedmineClientAuthConfiguration authConfiguration) {
            this.authConfiguration = authConfiguration;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public URL getUrl() {
            return this.url;
        }

        @Override
        public void setUrl(URL url) {
            this.url = url;
        }

        @Override
        public boolean isVerbose() {
            return this.verbose;
        }

        @Override
        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public boolean isAnonymous() {
            return this.anonymous;
        }

        @Override
        public void setAnonymous(boolean anonymous) {
            this.anonymous = anonymous;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
            b.append("redmineUrl", (Object)this.url);
            if (this.anonymous) {
                b.append("anonymous", true);
            } else {
                b.append("apiKey", (Object)this.authConfiguration.getApiKey());
                b.append("username", (Object)this.authConfiguration.getUsername());
                b.append("password", (Object)"***");
            }
            b.append("encoding", (Object)this.encoding);
            b.append("verbose", this.verbose);
            return b.toString();
        }
    }
}

