/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.rest;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.nuiton.io.rest.AbstractRequestFactory;
import org.nuiton.io.rest.RestMethod;
import org.nuiton.io.rest.RestRequestBuilder;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.model.VersionStatusEnum;

public class RedmineRequestFactory
extends AbstractRequestFactory {
    public static String getRequestScope(RestRequestBuilder requestBuilder) {
        String scope = requestBuilder instanceof DefaultRequestBuilder ? ((DefaultRequestBuilder)requestBuilder).getScope() : null;
        return scope;
    }

    public void addDefaultRequests() {
        this.addRequestBuilder((RestRequestBuilder)new DefaultRequestBuilder("Ping", RestMethod.GET, "jredmine", "ping"));
        this.addRequestBuilder((RestRequestBuilder)new DefaultRequestBuilder("Logout", RestMethod.GET, "jredmine", "logout"));
        this.addRequestBuilder((RestRequestBuilder)new DefaultRequestBuilder("Login", RestMethod.POST, new String[]{"jredmine", "login"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void checkRequestArgs(Object ... args) {
                this.checkRequestArgs(2, "userName, password", args);
            }

            public String[] getParameters(Object ... args) {
                String login = (String)args[0];
                String password = (String)args[1];
                return new String[]{"username", login, "password", password};
            }
        });
        this.addRequestBuilder((RestRequestBuilder)new DefaultRequestBuilder("LoginByAPiKey", RestMethod.POST, new String[]{"jredmine", "login"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void checkRequestArgs(Object ... args) {
                this.checkRequestArgs(1, "apiKey", args);
            }
        });
        this.addRequestBuilder((RestRequestBuilder)new DefaultRequestBuilder("Project/all", RestMethod.GET, "jredmine", "get_projects.xml"));
        this.addRequestBuilder((RestRequestBuilder)new DefaultRequestBuilder("User/Project/all", RestMethod.GET, "jredmine", "get_user_projects.xml"));
        this.addRequestBuilder((RestRequestBuilder)new DefaultRequestBuilder("IssueStatus/all", RestMethod.GET, "jredmine", "get_issue_statuses.xml"));
        this.addRequestBuilder((RestRequestBuilder)new DefaultRequestBuilder("IssuePriority/all", RestMethod.GET, "jredmine", "get_issue_priorities.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/detail", RestMethod.GET, "jredmine", "get_project.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/Issue/all", RestMethod.GET, "jredmine", "get_project_issues.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/Issue/opened", RestMethod.GET, "jredmine", "get_project_opened_issues.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/Issue/closed", RestMethod.GET, "jredmine", "get_project_closed_issues.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/Version/all", RestMethod.GET, "jredmine", "get_project_versions.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("IssueCategory/all", RestMethod.GET, "jredmine", "get_issue_categories.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/Tracker/all", RestMethod.GET, "jredmine", "get_project_trackers.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/User/all", RestMethod.GET, "jredmine", "get_project_users.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/News/all", RestMethod.GET, "jredmine", "get_project_news.xml"));
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/Version/add", RestMethod.POST, new String[]{"jredmine", "add_version.xml"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void checkRequestArgs(Object ... args) {
                this.checkRequestArgs(2, "projectName, version", args);
            }

            public String[] getParameters(Object ... args) {
                Version version = (Version)args[1];
                String date = RedmineRequestFactory.getVersionEffectiveDate(version);
                String status = RedmineRequestFactory.getVersionStatus(version);
                return new String[]{"version[name]", version.getName(), "version[description]", version.getDescription(), "version[effective_date]", date, "version[status]", status};
            }
        });
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/Version/update", RestMethod.POST, new String[]{"jredmine", "update_version.xml"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void checkRequestArgs(Object ... args) {
                this.checkRequestArgs(2, "projectName, version", args);
            }

            public String[] getParameters(Object ... args) {
                Version version = (Version)args[1];
                String date = RedmineRequestFactory.getVersionEffectiveDate(version);
                String status = RedmineRequestFactory.getVersionStatus(version);
                return new String[]{"version[name]", version.getName(), "version[description]", version.getDescription(), "version[effective_date]", date, "version[status]", status};
            }
        });
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/Version/next", RestMethod.POST, new String[]{"jredmine", "next_version.xml"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void checkRequestArgs(Object ... args) {
                this.checkRequestArgs(3, "projectName, version, oldVersionName", args);
            }

            public String[] getParameters(Object ... args) {
                Version version = (Version)args[1];
                String date = RedmineRequestFactory.getVersionEffectiveDate(version);
                String status = RedmineRequestFactory.getVersionStatus(version);
                String oldVersionName = (String)args[2];
                return new String[]{"oldVersionName", oldVersionName, "version[name]", version.getName(), "version[description]", version.getDescription(), "version[effective_date]", date, "version[status]", status};
            }
        });
        this.addRequestBuilder((RestRequestBuilder)new ProjectScopeRequestBuilder("Project/News/add", RestMethod.POST, new String[]{"jredmine", "add_news.xml"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void checkRequestArgs(Object ... args) {
                this.checkRequestArgs(2, "projectName, news", args);
            }

            public String[] getParameters(Object ... args) {
                News news = (News)args[1];
                return new String[]{"news[title]", news.getTitle(), "news[summary]", news.getSummary(), "news[description]", news.getDescription()};
            }
        });
        this.addRequestBuilder((RestRequestBuilder)new VersionScopeRequestBuilder("Project/Version/detail", RestMethod.GET, "jredmine", "get_version.xml"));
        this.addRequestBuilder((RestRequestBuilder)new VersionScopeRequestBuilder("Project/Version/Issue/all", RestMethod.GET, "jredmine", "get_version_issues.xml"));
        this.addRequestBuilder((RestRequestBuilder)new VersionScopeRequestBuilder("Project/Version/Attachment/all", RestMethod.GET, "jredmine", "get_version_attachments.xml"));
        this.addRequestBuilder((RestRequestBuilder)new VersionScopeRequestBuilder("Project/Version/Attachment/add", RestMethod.POST, new String[]{"jredmine", "add_version_attachment.xml"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void checkRequestArgs(Object ... args) {
                this.checkRequestArgs(3, "projectName, versionName, attachment", args);
            }

            @Override
            public String[] getParameters(Object ... args) {
                String versionId = (String)args[1];
                Attachment attachment = (Attachment)args[2];
                return new String[]{"version_name", versionId, "attachment[description]", attachment.getDescription()};
            }

            public Map<String, File> getAttachments(Object ... args) {
                HashMap<String, File> upload = new HashMap<String, File>();
                Attachment attachment = (Attachment)args[2];
                upload.put("attachment[file]", attachment.getToUpload());
                return upload;
            }
        });
        this.addRequestBuilder((RestRequestBuilder)new IssueScopeRequestBuilder("Project/Issue/TimeEntry/all", RestMethod.GET, "jredmine", "get_issue_times.xml"));
        this.addRequestBuilder((RestRequestBuilder)new IssueScopeRequestBuilder("Project/Issue/TimeEntry/add", RestMethod.POST, new String[]{"jredmine", "add_issue_time.xml"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void checkRequestArgs(Object ... args) {
                this.checkRequestArgs(3, "projectName, issueId, timeEntry", args);
            }

            @Override
            public String[] getParameters(Object ... args) {
                String issueId = (String)args[1];
                TimeEntry timeEntry = (TimeEntry)args[2];
                Date d = timeEntry.getSpentOn();
                if (d == null) {
                    d = new Date();
                }
                String date = AbstractRequestFactory.DATE_FORMAT.format(d);
                return new String[]{"issue_id", issueId, "time_entry[activity_id]", timeEntry.getActivityId() + "", "time_entry[spent_on]", date, "time_entry[hours]", timeEntry.getHours() + "", "time_entry[comments]", timeEntry.getComments() == null ? "" : timeEntry.getComments()};
            }
        });
    }

    protected static String getVersionStatus(Version version) {
        String status = version.getStatus();
        if (Strings.isNullOrEmpty((String)status)) {
            status = VersionStatusEnum.open.name();
        }
        return status;
    }

    protected static String getVersionEffectiveDate(Version version) {
        return version.getEffectiveDate() == null ? "" : DATE_FORMAT.format(version.getEffectiveDate());
    }

    protected static class VersionScopeRequestBuilder
    extends ProjectScopeRequestBuilder {
        private static final long serialVersionUID = 1L;

        public VersionScopeRequestBuilder(String name, RestMethod method, String ... action) {
            super(name, "version", method, action);
        }

        @Override
        public void checkRequestArgs(Object ... args) {
            this.checkRequestArgs(2, "projectName, versionName", args);
        }

        public String[] getParameters(Object ... args) {
            String versionName = (String)args[1];
            return new String[]{"version_name", versionName};
        }
    }

    protected static class IssueScopeRequestBuilder
    extends ProjectScopeRequestBuilder {
        private static final long serialVersionUID = 1L;

        public IssueScopeRequestBuilder(String name, RestMethod method, String ... action) {
            super(name, "issue", method, action);
        }

        @Override
        public void checkRequestArgs(Object ... args) {
            this.checkRequestArgs(2, "projectName, issueId", args);
        }

        public String[] getParameters(Object ... args) {
            String issueId = (String)args[1];
            return new String[]{"issue_id", issueId};
        }
    }

    protected static class ProjectScopeRequestBuilder
    extends DefaultRequestBuilder {
        private static final long serialVersionUID = 1L;

        public ProjectScopeRequestBuilder(String name, RestMethod method, String ... action) {
            this(name, "project", method, action);
        }

        public ProjectScopeRequestBuilder(String name, String scope, RestMethod method, String ... action) {
            super(name, scope, method, action);
        }

        @Override
        public void checkRequestArgs(Object ... args) {
            this.checkRequestArgs(1, "projectName", args);
        }

        public String[] getPath(Object ... args) {
            String projectName = (String)args[0];
            String[] result = new String[this.action.length + 1];
            System.arraycopy(this.action, 0, result, 0, this.action.length);
            result[this.action.length] = projectName;
            return result;
        }
    }

    protected static class DefaultRequestBuilder
    extends AbstractRequestFactory.AbstractRequestBuilder {
        private static final long serialVersionUID = 1L;
        protected String scope;

        public DefaultRequestBuilder(String name, RestMethod method, String ... action) {
            this(name, null, method, action);
        }

        public DefaultRequestBuilder(String name, String scope, RestMethod method, String ... action) {
            super(name, method, action);
            this.scope = scope;
        }

        public final String getScope() {
            return this.scope;
        }

        public void checkRequestArgs(Object ... args) {
            this.checkRequestArgs(0, "", args);
        }
    }
}

