/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jredmine.DefaultRedmineServiceImplementor;
import org.nuiton.jredmine.RedmineAnonymousService;
import org.nuiton.jredmine.RedmineServiceConfiguration;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;

public class DefaultRedmineAnonymousService
implements RedmineAnonymousService {
    private static final Log log = LogFactory.getLog(DefaultRedmineAnonymousService.class);
    protected final RedmineServiceImplementor delegateImplementor;

    public DefaultRedmineAnonymousService() {
        this(new DefaultRedmineServiceImplementor());
    }

    public DefaultRedmineAnonymousService(RedmineServiceImplementor delegateImplementor) {
        this.delegateImplementor = delegateImplementor;
    }

    @Override
    public void init(RedmineServiceConfiguration configuration) throws RedmineServiceException {
        configuration.setAnonymous(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init service with configuration: " + configuration));
        }
        if (!this.delegateImplementor.isInit()) {
            this.delegateImplementor.init(configuration);
        }
    }

    @Override
    public void destroy() throws RedmineServiceException {
        this.delegateImplementor.destroy();
    }

    @Override
    public RedmineServiceImplementor getDelegateImplementor() {
        return this.delegateImplementor;
    }

    @Override
    public IssueStatus[] getIssueStatuses() throws RedmineServiceException {
        return this.delegateImplementor.getDatas("IssueStatus/all", IssueStatus.class, new Object[0]);
    }

    @Override
    public IssuePriority[] getIssuePriorities() throws RedmineServiceException {
        return this.delegateImplementor.getDatas("IssuePriority/all", IssuePriority.class, new Object[0]);
    }

    @Override
    public Project[] getProjects() throws RedmineServiceException {
        return this.delegateImplementor.getDatas("Project/all", Project.class, new Object[0]);
    }

    @Override
    public IssueCategory[] getIssueCategories(String projectName) throws RedmineServiceException {
        return this.delegateImplementor.getDatas("IssueCategory/all", IssueCategory.class, projectName);
    }

    @Override
    public Project getProject(String projectName) throws RedmineServiceException {
        return this.delegateImplementor.getData("Project/detail", Project.class, projectName);
    }

    @Override
    public Tracker[] getTrackers(String projectName) throws RedmineServiceException {
        return this.delegateImplementor.getDatas("Project/Tracker/all", Tracker.class, projectName);
    }

    @Override
    public News[] getNews(String projectName) throws RedmineServiceException {
        return this.delegateImplementor.getDatas("Project/News/all", News.class, projectName);
    }

    @Override
    public User[] getProjectMembers(String projectName) throws RedmineServiceException {
        return this.delegateImplementor.getDatas("Project/User/all", User.class, projectName);
    }

    @Override
    public Version[] getVersions(String projectName) throws RedmineServiceException {
        return this.delegateImplementor.getDatas("Project/Version/all", Version.class, projectName);
    }

    @Override
    public Version getVersion(String projectName, String versionName) throws RedmineServiceException {
        return this.delegateImplementor.getData("Project/Version/detail", Version.class, projectName, versionName);
    }

    @Override
    public Attachment[] getAttachments(String projectName, String versionName) throws RedmineServiceException {
        return this.delegateImplementor.getDatas("Project/Version/Attachment/all", Attachment.class, projectName, versionName);
    }

    @Override
    public Issue[] getIssues(String projectName, String versionName) throws RedmineServiceException {
        return this.delegateImplementor.getDatas("Project/Version/Issue/all", Issue.class, projectName, versionName);
    }

    @Override
    public TimeEntry[] getIssueTimeEntries(String projectName, String issueId) throws RedmineServiceException {
        return this.delegateImplementor.getDatas("Project/Issue/TimeEntry/all", TimeEntry.class, projectName, issueId);
    }

    @Override
    public Issue[] getIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.delegateImplementor.getDatas("Project/Issue/all", Issue.class, projectName);
        return result;
    }

    @Override
    public Issue[] getOpenedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.delegateImplementor.getDatas("Project/Issue/opened", Issue.class, projectName);
        return result;
    }

    @Override
    public Issue[] getClosedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.delegateImplementor.getDatas("Project/Issue/closed", Issue.class, projectName);
        return result;
    }
}

