/*
 * *##% 
 * JRedmine client
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine.rest;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.util.IOUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestException;
import org.nuiton.io.rest.RestRequest;
import org.nuiton.jredmine.TestHelper;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;

/**
 *
 * @author chemit
 * @since 1.0.0
 */
public class RedmineRestClientTest {

    static RestClientConfiguration configuration;
    RedmineRestClient client;

    public RedmineRestClientTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {

        configuration = TestHelper.getTestConfiguration();

        RedmineRestClient client = new RedmineRestClient(configuration);
        try {

            client.open();
        } catch (Exception e) {

            // could not log
            System.out.println("could not connect to server " + configuration.getRestUrl() + ", will skip test " + RedmineRestClientTest.class.getName());
        } finally {
            Assume.assumeTrue(client.isOpen());
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {

        client = new RedmineRestClient(configuration);
        client.open();
    }

    @After
    public void tearDown() throws Exception {

        if (client != null) {
            client.close();
        }
    }

    @Test
    public void isOpen() throws Exception {
        Assert.assertTrue(client.isOpen());
    }

    @Test
    public void isClose() throws Exception {
        Assert.assertTrue(client.isOpen());
        client.close();
        Assert.assertFalse(client.isOpen());
    }

    @Test
    public void getDatas() throws Exception {

        String toString;

        // get projects

        toString = doRequest(Project.class, "list");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get issue statuses

        toString = doRequest(IssueStatus.class, "list");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get issue priorities

        toString = doRequest(IssuePriority.class, "list");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get project

        toString = doRequest(Project.class, "detail", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get project issue categories

        toString = doRequest(IssueCategory.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get project versions

        toString = doRequest(Version.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get project users

        toString = doRequest(User.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get project trackers

        toString = doRequest(Tracker.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get project news

        toString = doRequest(News.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get version

        toString = doRequest(Version.class, "detail", "one", "1.0.0");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get issues

        toString = doRequest(Issue.class, "list", "one", "1.0.0");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

        // get attachments

        toString = doRequest(Attachment.class, "list", "one", "1.0.0");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }

    }

    protected String doRequest(Class<?> type, String action, Object... params) throws IOException, RestException {

        String requestId = type.getName() + action;

        RestRequest request;
        InputStream askData;
        String toString;

        request = client.getRequest(requestId, params);
        askData = client.askData(request);
        toString = IOUtil.toString(askData);
        return toString;
    }
}
