/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.util.FileUtil;

public abstract class AbstractJaxxMojo
extends AbstractPlugin {
    private MavenProject project;
    private String encoding;
    private boolean verbose;
    private boolean force;
    protected boolean generateHelp;

    public abstract File getTargetDirectory();

    public abstract void setTargetDirectory(File var1);

    protected boolean checkPackaging() {
        return this.project != null && !"pom".equals(this.project.getPackaging()) && !"site".equals(this.project.getPackaging());
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    protected void createDirectoryIfNecessary(File dir) throws IOException {
        if (!dir.exists()) {
            boolean b;
            if (this.verbose) {
                this.getLog().info((CharSequence)("mkdir " + dir));
            }
            if (!(b = dir.mkdirs())) {
                throw new IOException("could not create directory " + dir);
            }
        }
    }

    public static boolean addResourceDir(File dir, MavenProject project, String ... includes) {
        List resources = project.getResources();
        boolean added = AbstractJaxxMojo.addResourceDir(dir, project, resources, includes);
        return added;
    }

    public static boolean addTestResourceDir(File newresourceDir, MavenProject project, String ... includes) {
        List resources = project.getTestResources();
        boolean added = AbstractJaxxMojo.addResourceDir(newresourceDir, project, resources, includes);
        return added;
    }

    public static boolean addResourceDir(File dir, MavenProject project, List<?> resources, String ... includes) {
        String newresourceDir = dir.getAbsolutePath();
        boolean shouldAdd = true;
        for (Object o : resources) {
            Resource r = (Resource)o;
            if (!r.getDirectory().equals(newresourceDir)) continue;
            for (String i : includes) {
                if (r.getIncludes().contains(i)) continue;
                r.addInclude(i);
            }
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            Resource r = new Resource();
            r.setDirectory(newresourceDir);
            for (String i : includes) {
                if (r.getIncludes().contains(i)) continue;
                r.addInclude(i);
            }
            project.addResource(r);
        }
        return shouldAdd;
    }

    protected Long getLastModified(File dir) {
        if (!dir.exists()) {
            return null;
        }
        GetLastModifiedFileAction fileAction = new GetLastModifiedFileAction(dir);
        FileUtil.walkAfter((File)dir, (FileUtil.FileAction)fileAction);
        return fileAction.getLastFile().lastModified();
    }

    class GetLastModifiedFileAction
    implements FileUtil.FileAction {
        protected File lastFile;

        public GetLastModifiedFileAction(File lastFile) {
            this.lastFile = lastFile;
        }

        public boolean doAction(File f) {
            if (f.lastModified() > this.lastFile.lastModified()) {
                this.lastFile = f;
            }
            return true;
        }

        public File getLastFile() {
            return this.lastFile;
        }
    }
}

