/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import com.google.common.collect.Lists;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import org.nuiton.jaxx.runtime.swing.model.GenericListListener;
import org.nuiton.jaxx.runtime.swing.model.GenericListModel;

public class ListSelectorModel<B> {
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROPERTY_ADD_ENABLED = "addEnabled";
    public static final String PROPERTY_REMOVE_ENABLED = "removeEnabled";
    public static final String PROPERTY_SELECTED_VALUES = "selectedValues";
    public static final String PROPERTY_VALUES = "values";
    protected boolean addEnabled;
    protected boolean removeEnabled;
    protected final GenericListModel<B> fromModel = new GenericListModel();
    protected final GenericListModel<B> toModel;

    protected ListSelectorModel() {
        this.fromModel.addPropertyChangeListener(PROPERTY_SELECTED_VALUES, evt -> this.setAddEnabled(this.fromModel.hasSelectedIndex()));
        this.toModel = new GenericListModel();
        this.toModel.addPropertyChangeListener(PROPERTY_SELECTED_VALUES, evt -> this.setRemoveEnabled(this.toModel.hasSelectedIndex()));
    }

    public boolean isAddEnabled() {
        return this.addEnabled;
    }

    public void setAddEnabled(boolean addEnabled) {
        boolean oldValue = this.isAddEnabled();
        this.addEnabled = addEnabled;
        this.firePropertyChange(PROPERTY_ADD_ENABLED, oldValue, addEnabled);
    }

    public boolean isRemoveEnabled() {
        return this.removeEnabled;
    }

    public void setRemoveEnabled(boolean removeEnabled) {
        boolean oldValue = this.isRemoveEnabled();
        this.removeEnabled = removeEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_ENABLED, oldValue, removeEnabled);
    }

    public GenericListModel<B> getFromModel() {
        return this.fromModel;
    }

    public GenericListModel<B> getToModel() {
        return this.toModel;
    }

    public Collection<B> getValues() {
        return this.fromModel.getElements();
    }

    public void setValues(Collection<B> values) {
        Collection<B> oldValues = this.getValues();
        this.toModel.clearElements();
        this.fromModel.setElements(values);
        this.firePropertyChange(PROPERTY_VALUES, oldValues, values);
    }

    public void addValues(Collection<B> values) {
        Collection<B> oldValues = this.getValues();
        this.toModel.removeElements(values);
        this.fromModel.removeElements(values);
        this.fromModel.addElements(values);
        this.firePropertyChange(PROPERTY_VALUES, oldValues, values);
    }

    public void removeValues(Collection<B> values) {
        Collection<B> oldValues = this.getValues();
        this.toModel.removeElements(values);
        this.fromModel.removeElements(values);
        this.firePropertyChange(PROPERTY_VALUES, oldValues, values);
    }

    public Collection<B> getSelectedValues() {
        return this.toModel.getElements();
    }

    public void setSelectedValues(Collection<B> selectedValues) {
        Collection<B> oldValue = this.getSelectedValues();
        this.fromModel.removeElements(selectedValues);
        this.toModel.removeElements(selectedValues);
        this.toModel.setElements(selectedValues);
        this.firePropertyChange(PROPERTY_SELECTED_VALUES, oldValue, selectedValues);
    }

    public void add() {
        Collection<B> oldValues = this.getValues();
        Collection<B> oldSelectedValue = this.getSelectedValues();
        this.moveSelect(this.fromModel, this.toModel);
        this.firePropertyChange(PROPERTY_VALUES, oldValues, this.getValues());
        this.firePropertyChange(PROPERTY_SELECTED_VALUES, oldSelectedValue, this.getSelectedValues());
    }

    public void remove() {
        this.moveSelect(this.toModel, this.fromModel);
    }

    protected void moveSelect(GenericListModel<B> from, GenericListModel<B> to) {
        ArrayList selectedValues = Lists.newArrayList((Iterable)from.getSelectedValues());
        from.removeElements((Collection)selectedValues);
        to.addElements((Collection)selectedValues);
    }

    public void addGenericListListener(GenericListListener l) {
        this.toModel.addGenericListListener(l);
    }

    public void removeGenericListListener(GenericListListener l) {
        this.toModel.removeGenericListListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }
}

