package org.nuiton.jaxx.runtime.swing.editor.gis;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import static org.nuiton.i18n.I18n.t;

public class DmdCoordinateEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_RESET_TIP = "showResetTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_RESET_BUTTON_TOOL_TIP_TEXT = "resetButton.toolTipText";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTU8TURS9LbS1LV9+Jq4kQQWjTMMaovLVCCliKAtiN752XttHpu+N772hQ4gsXLjzD7hw68bwH4grEzdu+Q8m/ATvmxk6rbSA2qST9s25555737n36y9IKQlPhGxY3GNacGuX+L4lPa5Zi1rrizs7m9VdWtMrVNUkc7WQEH4SSUhWIG93zpUGq1JCpkLIVDBMhYipsCxaruCUdxHNlyCn9L5DVZNSrWFmYHBNqUK5g5z3XU9Gufqq7pfrx4e5kwRd+ZQE8F2Un8GyH/8FQVz1cAmSzNZwo7RL9kjBIbyB4iTjDSxo1JwtO0Spl6RF38IhZEqQdolEMg2z/9SegC6g8l0NeWpjuHxFOHU0LAwqQbVRkBVirQZT1krLXhZC2owTTVeDc9cNaNMasqop2ltUmWu4bkqwTFnWkhAOJTzGjXRw26gRJmJo2IEYmWoJ2whc/B+BG4Yj5sxr1FMlskTrqPOWSe5HPOvb+GqJSIPMxgHSSF3yNGbXcLMnIDw1wNsdfDqUo+FeD7QoZItoTe1t6usio44dpZHwcFB5aFkrtmzsnkQFUtLDYw1Tg6fFGH4LUaHVpwZb3aQJgO+PDuWX9unJmb/NWE9eFtU1ymg2VwqXSs2MtvHQ3J5mTmGDuPMVtAh1cA8Ecz59sfJyhET1qCL0k2GyXhDVRLZU5uT42503P4cgWYScI4hdJAa/BlndxCtrCsf23WfPA3Ej7Wv4nMDvkIbRKhqEovkZx+tAl9WJgzcMmT2mWNXBX+MHTJXPTDrz6B16u44ZNAnehngfezp9cU87JRxtnn7//PHB8VlfE1jR/atExr1NvYY04w7jNNgc0VLouynyrqKeLeKJ77cDoHcS3GhApoLn9Lm2pTTksL1M8LWaGYOxmmhVRVX4szIc+Gxd1DzV3aAoAc64cTxOzkGD6nLX6AeNzVBugvAaRrHpq+Gf4M1IwPjHLfme0VcIemh+zUHvgF5WR2Jwxn7U0SxfgTXtkH2BEmBswUajTFYZxyXUeHqONWGeuSswDrNauFo2+nPcRY7fqbX4H3sHAAA=";
    private static final Log log = LogFactory.getLog(DmdCoordinateEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JFormattedTextField editor;
    protected DmdCoordinateEditor editorPanel;
    protected DmdCoordinateEditorHandler handler;
    protected DmdCoordinateEditorModel model;
    protected JButton resetButton;
    protected Boolean showReset;
    protected String showResetTip;
    protected JToolBar toolbarLeft;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(boolean longitudeEditor) { handler.init(longitudeEditor); }
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setPropertySign(String property ) { model.setPropertySign(property); }
    public void setPropertyDegree(String property ) { model.setPropertyDegree(property); }
    public void setPropertyMinute(String property ) { model.setPropertyMinute(property); }
    public void setPropertyDecimal(String property ) { model.setPropertyDecimal(property); }
    public void setValue(DmdCoordinate value) { handler.setValue(value, true); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DmdCoordinateEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DmdCoordinateEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DmdCoordinateEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DmdCoordinateEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DmdCoordinateEditor() {
        $initialize();
    }

    public DmdCoordinateEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DmdCoordinateEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public DmdCoordinateEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.resetEditor();
    }

    public void doFocusGained__on__editorPanel(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        editor.requestFocus();
    }

    public void doKeyReleased__on__editor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onKeyReleased(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JFormattedTextField getEditor() {
        return editor;
    }

    public DmdCoordinateEditorHandler getHandler() {
        return handler;
    }

    public DmdCoordinateEditorModel getModel() {
        return model;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public String getShowResetTip() {
        return showResetTip;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowResetTip(String showResetTip) {
        String oldValue = this.showResetTip;
        this.showResetTip = showResetTip;
        firePropertyChange(PROPERTY_SHOW_RESET_TIP, oldValue, showResetTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorPanel() {
        add(toolbarLeft, BorderLayout.WEST);
        add(editor, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(resetButton);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new JFormattedTextField());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new DmdCoordinateEditorModel());
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusable(false);
        resetButton.setFocusPainted(false);
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createShowResetTip() {
        $objectMap.put("showResetTip", showResetTip = new String());
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        editorPanel = this;
        handler = new DmdCoordinateEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editorPanel", editorPanel);
        createShowReset();
        createShowResetTip();
        createModel();
        createToolbarLeft();
        createResetButton();
        createEditor();
        // inline creation of editorPanel
        setName("editorPanel");
        setLayout(new BorderLayout());
        editorPanel.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__editorPanel"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_TOOL_TIP_TEXT, true ,"showResetTip") {
        
            @Override
            public void processDataBinding() {
                resetButton.setToolTipText(t(getShowResetTip()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditorPanel();
        addChildrenToToolbarLeft();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 property setters
        resetButton.setIcon(SwingUtil.createActionIcon("combobox-reset"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}