package org.nuiton.jaxx.runtime.swing;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;

public class StatusMessagePanel extends Table implements ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BUSY = "busy";
    public static final String PROPERTY_SHOW_BUSY = "showBusy";
    public static final String PROPERTY_SHOW_CLOCK = "showClock";
    public static final String PROPERTY_SHOW_I18N = "showI18n";
    public static final String PROPERTY_SHOW_MEMORY_STATUS = "showMemoryStatus";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUSY_WIDGET_ENABLED = "busyWidget.enabled";
    public static final String BINDING_BUSY_WIDGET_INDETERMINATE = "busyWidget.indeterminate";
    public static final String BINDING_BUSY_WIDGET_VISIBLE = "busyWidget.visible";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$CLOCK_WIDGET0_VISIBLE = "$ClockWidget0.visible";
    private static final String BINDING_$MEMORY_STATUS_WIDGET0_VISIBLE = "$MemoryStatusWidget0.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz08TQRSeFtpCsYDGGGOMIaGCRN1CYgIRIloIAVKEWBOJvTjbnbSD25l1ZpYuFw4evPkPePDqxfA/EE8mXrzyP5jwJ/hmdukWaflhe9g2b7/3ve97M+/1+x+UkgI94qJmMZ8qzqwdHASW8JmiDWKtv9je3rR3SFUtE1kV1FNcoPCTSKJkBQ05rbhUyKqUgKkQMhU0UyFiKizxhscZYW1E8yWUlWrPJbJOiFLoQdfkqpSFcgs5H3i+iGp1VN2p1q9PM0cJsvwliVDggfwc2H54BYLYdX8JJamj0I3SDt7FBRezGogTlNXAUE7Hllws5UvcIB/QPsqUUNrDAsgUevxf7TF0hirwFMrkX2PbJdMKTXeTL5sgxiorrHy5QaTENbKFGXE9z9CkFRqVdd7cIA0u9kKYQte1cku7sYqcuwSzGD6o4Usur77XgeH4xYB+sTYzxzrFi77c+yfeb5+NZeqYOS4RCs1e1dBqmBlzpfJFHkBrRrSZIMqDkH492EJltYo31KnpW3e7Hbq+JXhNQIUiFhp8p5UzJE31EraJC2d/KskET8P77LDo3dOVb+bbmx5KuPgkz+ZouvEWay5vzqZFN3U+XRs44hFoolsKjJ4Vj148BYkKSgkfwgqNd596PbivABWO7Hj3kdVlDPDjwb741jw+OpnTARA3dlFW20qCofEE9+A6Ua1tJBxSX1G3sIG9+QrcZeLCPjP7avJ85eUICepBRTggmslaxbIObKnM0eGPW+9+96HkCsq6HDsrWOPX0KCqwy2qc9cJvMXnRty15gA8R7VMhdI2F46+8sMLDlZ4zKbMgaN5FkCXJs/vUkvUwebxz6+f7x+edCoBGvOXyYy7lXqL0pS5lBGz06J11XGHDXmS+A6Pd1Gn7ZTQ31kvmsdp83zSyX8u9L+FKVNE79KFUMYYVrBJbV8RaIXOnjPG9K+nhvzeJcgzhOkNaezM/j9NDs6EKCIalGFFeiWT5h8iMqxhiz0Y3KWSgsOeNOlw+RyGiZ4ZpoDhLyh5d4VhCAAA";
    private static final Log log = LogFactory.getLog(StatusMessagePanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Box box;
    protected Boolean busy;
    protected JProgressBar busyWidget;
    protected StatusMessagePanelHandler handler;
    protected Boolean showBusy;
    protected Boolean showClock;
    protected Boolean showI18n;
    protected Boolean showMemoryStatus;
    protected JLabel statusLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Box $Box0;
    private ClockWidget $ClockWidget0;
    private MemoryStatusWidget $MemoryStatusWidget0;
    private StatusMessagePanel $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // To ensure status bar constant height, no matter what font are in use...
    protected final static String EMPTY_STATUS = " ";
    
    
    public void clearStatus() {
        handler.clearStatus();
    }
    
    public void startProgress() {
        startProgress(null);
    }
    
    public void startProgress(String status) {
        setBusy(true);
        setStatus(status);
    }
    
    public void stopProgress() {
      stopProgress(null);
    }
    
    public void stopProgress(String finalStatus) {
        setBusy(false);
        setStatus(finalStatus);
    }
    
    public void setStatus(String status) {
        handler.setStatus(status);
    }
    
    @Override
    public void actionPerformed(ActionEvent evt) {
        handler.fadeStatus(this);
    }
    
    public <U extends Component> U getWidget(Class<U> clazz) {
        for (Component component : box.getComponents()) {
            if (clazz == component.getClass()) {
                return (U) component;
            }
        }
        return null;
    }
    
    public void addWidget(Component w) {
        box.add(w);
    }
    
    public void addWidget(Component w, int index) {
        box.add(w, index);
    }
    
    public void init() {
        handler.init();
    }
    
    void $afterCompleteSetup() {
        handler.$afterCompleteSetup();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StatusMessagePanel() {
        $initialize();
    }

    public StatusMessagePanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Box getBox() {
        return box;
    }

    public Boolean getBusy() {
        return busy;
    }

    public JProgressBar getBusyWidget() {
        return busyWidget;
    }

    public StatusMessagePanelHandler getHandler() {
        return handler;
    }

    public Boolean getShowBusy() {
        return showBusy;
    }

    public Boolean getShowClock() {
        return showClock;
    }

    public Boolean getShowI18n() {
        return showI18n;
    }

    public Boolean getShowMemoryStatus() {
        return showMemoryStatus;
    }

    public JLabel getStatusLabel() {
        return statusLabel;
    }

    public Boolean isBusy() {
        return busy !=null && busy;
    }

    public Boolean isShowBusy() {
        return showBusy !=null && showBusy;
    }

    public Boolean isShowClock() {
        return showClock !=null && showClock;
    }

    public Boolean isShowI18n() {
        return showI18n !=null && showI18n;
    }

    public Boolean isShowMemoryStatus() {
        return showMemoryStatus !=null && showMemoryStatus;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBusy(Boolean busy) {
        Boolean oldValue = this.busy;
        this.busy = busy;
        firePropertyChange(PROPERTY_BUSY, oldValue, busy);
    }

    public void setShowBusy(Boolean showBusy) {
        Boolean oldValue = this.showBusy;
        this.showBusy = showBusy;
        firePropertyChange(PROPERTY_SHOW_BUSY, oldValue, showBusy);
    }

    public void setShowClock(Boolean showClock) {
        Boolean oldValue = this.showClock;
        this.showClock = showClock;
        firePropertyChange(PROPERTY_SHOW_CLOCK, oldValue, showClock);
    }

    public void setShowI18n(Boolean showI18n) {
        Boolean oldValue = this.showI18n;
        this.showI18n = showI18n;
        firePropertyChange(PROPERTY_SHOW_I18N, oldValue, showI18n);
    }

    public void setShowMemoryStatus(Boolean showMemoryStatus) {
        Boolean oldValue = this.showMemoryStatus;
        this.showMemoryStatus = showMemoryStatus;
        firePropertyChange(PROPERTY_SHOW_MEMORY_STATUS, oldValue, showMemoryStatus);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Box get$Box0() {
        return $Box0;
    }

    protected ClockWidget get$ClockWidget0() {
        return $ClockWidget0;
    }

    protected MemoryStatusWidget get$MemoryStatusWidget0() {
        return $MemoryStatusWidget0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBox() {
        box.add($MemoryStatusWidget0);
        box.add($ClockWidget0);
    }

    protected void createBox() {
        $objectMap.put("box", box = new Box(0));
        
        box.setName("box");
    }

    protected void createBusy() {
        $objectMap.put("busy", busy = Boolean.FALSE);
    }

    protected void createBusyWidget() {
        $objectMap.put("busyWidget", busyWidget = new JProgressBar());
        
        busyWidget.setName("busyWidget");
        busyWidget.setBorderPainted(true);
        busyWidget.setStringPainted(false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new StatusMessagePanelHandler(this));
    }

    protected void createShowBusy() {
        $objectMap.put("showBusy", showBusy = Boolean.FALSE);
    }

    protected void createShowClock() {
        $objectMap.put("showClock", showClock = Boolean.TRUE);
    }

    protected void createShowI18n() {
        $objectMap.put("showI18n", showI18n = Boolean.FALSE);
    }

    protected void createShowMemoryStatus() {
        $objectMap.put("showMemoryStatus", showMemoryStatus = Boolean.TRUE);
    }

    protected void createStatusLabel() {
        $objectMap.put("statusLabel", statusLabel = new JLabel());
        
        statusLabel.setName("statusLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $Table0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createShowMemoryStatus();
        createShowClock();
        createShowI18n();
        createShowBusy();
        createBusy();
        createHandler();
        // inline creation of $Box0
        $objectMap.put("$Box0", $Box0 = new Box(0));
        
        $Box0.setName("$Box0");
        createBusyWidget();
        createStatusLabel();
        createBox();
        // inline creation of $MemoryStatusWidget0
        $objectMap.put("$MemoryStatusWidget0", $MemoryStatusWidget0 = new MemoryStatusWidget());
        
        $MemoryStatusWidget0.setName("$MemoryStatusWidget0");
        // inline creation of $ClockWidget0
        $objectMap.put("$ClockWidget0", $ClockWidget0 = new ClockWidget());
        
        $ClockWidget0.setName("$ClockWidget0");
        // inline creation of $Table0
        setName("$Table0");
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUSY_WIDGET_ENABLED, true ,"busy") {
        
            @Override
            public void processDataBinding() {
                busyWidget.setEnabled(isBusy());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUSY_WIDGET_INDETERMINATE, true ,"busy") {
        
            @Override
            public void processDataBinding() {
                busyWidget.setIndeterminate(isBusy());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUSY_WIDGET_VISIBLE, true ,"showBusy") {
        
            @Override
            public void processDataBinding() {
                busyWidget.setVisible(isShowBusy());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$MEMORY_STATUS_WIDGET0_VISIBLE, true ,"showMemoryStatus") {
        
            @Override
            public void processDataBinding() {
                $MemoryStatusWidget0.setVisible( isShowMemoryStatus() );
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$CLOCK_WIDGET0_VISIBLE, true ,"showClock") {
        
            @Override
            public void processDataBinding() {
                $ClockWidget0.setVisible( isShowClock() );
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Box0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(box, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Box0
        $Box0.add(busyWidget);
        $Box0.add(statusLabel);
        addChildrenToBox();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 1 property setters
        setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}