package jaxx.runtime.swing;

/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class HidorButton extends JToggleButton implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HIDE_TEXT = "hideText";
    public static final String PROPERTY_HIDE_TIP = "hideTip";
    public static final String PROPERTY_SHOW_TEXT = "showText";
    public static final String PROPERTY_SHOW_TIP = "showTip";
    public static final String PROPERTY_TARGET_VISIBLE = "targetVisible";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HIDOR_ICON = "hidor.icon";
    public static final String BINDING_HIDOR_TEXT = "hidor.text";
    public static final String BINDING_HIDOR_TOOL_TIP_TEXT = "hidor.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TzW7TQBCeuE3SJBQKhaqIgsKfQBycBwiC0qIooAASrVBFLmziVbKV4112x8S9IB6BR4A7FyRunBAHzhy4IF4BIQ5cEbOOEyfF0Pqwtmfmm/lm5ts33yFvNJzfZVHk6jBAMeDu3Vs7Ow86u7yLt7npaqFQahg9OQecNlS8id0gXGy3LLyWwGubcqBkwIMpdL0FZYN7Pjd9zhHh7Cyia0xta+KuRyrU46wTUllZX/384bz0Xrx2ACJF7IrUSvUgVNrJfAsc4SGcoErPWM1nQY9oaBH0iO+itW36zJj7bMCfwnMotqCgmKZkCBcO33KcI8ZHCiHfF57UCOdmaJohFXWb1rURIspAqRhSQCgN9pos8HxOoMv/ByVxKXYRme5xfCSM6Pgc4bjtybV9uhtS+pxN1VkgYnybR9TcUho2GsdUlOnLoY2y/ydTezFGC7XfHIenZg1nZlqgxbvp4tPN5NqQ1yGZEVbbf2vlIblGKlndpxKbMPb+Xln+8v7bu8ZYGnNU+1Rm6JSyaWVKS0WjFrb0sZEuQhR+7R5T9TaUDPfpWsSyX8sgtpW4iRzVG43bwt0mM31KkS9+/fBx5cnnOXAaUPYl8xrMxt+BEvY1TUH6XqRurseMjgwX6Fyy3BDmRVcGCEevewxZtSMCj/ZyI6IRrGWMYMKjU/r0a3nr7fp4DDmidfqf4eko8o+hIAJfBDy+I4n8M+9ERRkeejKVeZbwc/ZdVokyqvF5KbNPTMR1JQrt62pM2n5dO3SOCpK4SXXbB6f6A7bp8XQABQAA";
    private static final Log log = LogFactory.getLog(HidorButton.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected String hideText;
    protected String hideTip;
    protected HidorButton hidor = this;
    protected HidorButtonHandler myHandler;
    protected String showText;
    protected String showTip;
    protected Boolean targetVisible;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComponent target;
    
    
    public JComponent getTarget() {
        return target;
    }
    
    void $afterCompleteSetup() {
        myHandler.$afterCompleteSetup();
    }
    
    public void setTarget(JComponent target) {
        JComponent oldValue = this.target;
        this.target = target;
        firePropertyChange("target", oldValue, target);
    }
    
    public void setExpandIcon(Icon icon) {
        putClientProperty("expandIcon", icon);
    }
    
    public void setHideIcon(Icon icon) {
        putClientProperty("hideIcon", icon);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HidorButton() {
        $initialize();
    }

    public HidorButton(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(String param0, Icon param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, String param1, Icon param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(Icon param0) {
        super(param0);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, Icon param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(Icon param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, Icon param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(String param0) {
        super(param0);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(String param0, Icon param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, String param1, Icon param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(Action param0) {
        super(param0);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, Action param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(String param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, String param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__hidor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setTargetVisible(!targetVisible);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getHideText() {
        return hideText;
    }

    public String getHideTip() {
        return hideTip;
    }

    public HidorButtonHandler getMyHandler() {
        return myHandler;
    }

    public String getShowText() {
        return showText;
    }

    public String getShowTip() {
        return showTip;
    }

    public Boolean getTargetVisible() {
        return targetVisible;
    }

    public Boolean isTargetVisible() {
        return targetVisible !=null && targetVisible;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHideText(String hideText) {
        String oldValue = this.hideText;
        this.hideText = hideText;
        firePropertyChange(PROPERTY_HIDE_TEXT, oldValue, hideText);
    }

    public void setHideTip(String hideTip) {
        String oldValue = this.hideTip;
        this.hideTip = hideTip;
        firePropertyChange(PROPERTY_HIDE_TIP, oldValue, hideTip);
    }

    public void setShowText(String showText) {
        String oldValue = this.showText;
        this.showText = showText;
        firePropertyChange(PROPERTY_SHOW_TEXT, oldValue, showText);
    }

    public void setShowTip(String showTip) {
        String oldValue = this.showTip;
        this.showTip = showTip;
        firePropertyChange(PROPERTY_SHOW_TIP, oldValue, showTip);
    }

    public void setTargetVisible(Boolean targetVisible) {
        Boolean oldValue = this.targetVisible;
        this.targetVisible = targetVisible;
        firePropertyChange(PROPERTY_TARGET_VISIBLE, oldValue, targetVisible);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHideText() {
        $objectMap.put("hideText", hideText = "");
    }

    protected void createHideTip() {
        $objectMap.put("hideTip", hideTip = _("hidor.hideTip"));
    }

    protected void createMyHandler() {
        $objectMap.put("myHandler", myHandler = new HidorButtonHandler(this));
    }

    protected void createShowText() {
        $objectMap.put("showText", showText = "");
    }

    protected void createShowTip() {
        $objectMap.put("showTip", showTip = _("hidor.showTip"));
    }

    protected void createTargetVisible() {
        $objectMap.put("targetVisible", targetVisible = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("hidor", hidor);
        createMyHandler();
        createTargetVisible();
        createHideText();
        createShowText();
        createHideTip();
        createShowTip();
        // inline creation of hidor
        setName("hidor");
        hidor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidor"));
        hidor.putClientProperty("hideIcon", SwingUtil.createActionIcon("collapse"));
        hidor.putClientProperty("showIcon", SwingUtil.createActionIcon("expand"));
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_ICON, true ,"targetVisible") {
        
            @Override
            public void processDataBinding() {
                setIcon(myHandler.updateIcon(isTargetVisible()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_TEXT, true ,"targetVisible") {
        
            @Override
            public void processDataBinding() {
                setText(_(myHandler.updateText(isTargetVisible())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_TOOL_TIP_TEXT, true ,"targetVisible") {
        
            @Override
            public void processDataBinding() {
                setToolTipText(_(myHandler.updateToolTipText(isTargetVisible())));
            }
        });
    }

}