/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorUtils;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.decorator.MultiJXPathDecorator;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.AutoCompletePropertyChangeListener;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.nuiton.i18n.I18n;

@Deprecated
public class EntityComboBoxHandler<O>
implements PropertyChangeListener {
    public static final Log log = LogFactory.getLog(EntityComboBoxHandler.class);
    public static final String SELECTED_ITEM_PROPERTY = "selectedItem";
    public static final String INDEX_PROPERTY = "index";
    public static final String AUTO_COMPLETE_PROPERTY = "autoComplete";
    public static final String DATA_PROPERTY = "data";
    protected EntityComboBox<O> ui;
    protected Method mutator;
    protected Document originalDocument;
    protected ObjectToStringConverter convertor;
    protected MultiJXPathDecorator<O> decorator;
    protected boolean init;
    protected final FocusListener EDITOR_TEXT_COMP0NENT_FOCUSLISTENER = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("close popup from " + e));
            }
            EntityComboBoxHandler.this.ui.getPopup().setVisible(false);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    };

    public EntityComboBoxHandler(EntityComboBox<O> ui) {
        this.ui = ui;
    }

    public void init(JXPathDecorator<O> decorator, List<O> data) {
        if (this.init) {
            throw new IllegalStateException("can not init the handler twice");
        }
        this.init = true;
        if (decorator == null) {
            throw new NullPointerException("can not have a null decorator as parameter");
        }
        JAXXButtonGroup indexes = this.ui.getIndexes();
        MultiJXPathDecorator d = decorator instanceof MultiJXPathDecorator ? (MultiJXPathDecorator)decorator : DecoratorUtils.newMultiJXPathDecorator((Class)decorator.getInternalClass(), (String)decorator.getInitialExpression(), (String)" - ");
        this.decorator = d;
        this.ui.getCombobox().setRenderer(new DecoratorListCellRenderer((Decorator)d));
        this.convertor = EntityComboBoxHandler.newDecoratedObjectToStringConverter(d);
        JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
        this.originalDocument = editorComponent.getDocument();
        this.preparePopup(d);
        this.ui.autoComplete = true;
        this.ui.addPropertyChangeListener(this);
        this.ui.setData(data);
        indexes.setSelectedButton((Object)this.ui.getIndex());
    }

    public void togglePopup() {
        boolean newValue;
        boolean bl = newValue = !this.ui.getPopup().isVisible();
        if (log.isTraceEnabled()) {
            log.trace((Object)newValue);
        }
        if (!newValue) {
            if (this.ui.getPopup() != null) {
                this.ui.getPopup().setVisible(false);
            }
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EntityComboBoxHandler.this.ui.getPopup().pack();
                Dimension dim = EntityComboBoxHandler.this.ui.getPopup().getPreferredSize();
                JToggleButton invoker = EntityComboBoxHandler.this.ui.getChangeDecorator();
                EntityComboBoxHandler.this.ui.getPopup().show(invoker, (int)(invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
            }
        });
    }

    protected void setAutoComplete(Boolean oldValue, Boolean newValue) {
        if ((oldValue = Boolean.valueOf(oldValue != null && oldValue != false)) == (newValue = Boolean.valueOf(newValue != null && newValue != false))) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("autocomplete state : <" + oldValue + " to " + newValue + ">"));
        }
        if (!newValue.booleanValue()) {
            JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
            editorComponent.removeFocusListener(this.EDITOR_TEXT_COMP0NENT_FOCUSLISTENER);
            EntityComboBoxHandler.undecorate(this.ui.getCombobox(), this.originalDocument);
        } else {
            EntityComboBoxHandler.decorate(this.ui.getCombobox(), this.convertor);
            JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
            editorComponent.addFocusListener(this.EDITOR_TEXT_COMP0NENT_FOCUSLISTENER);
        }
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        this.decorator.setContextIndex(newValue.intValue());
        Object previousSelectedItem = this.ui.getSelectedItem();
        Boolean wasAutoComplete = this.ui.isAutoComplete();
        if (wasAutoComplete.booleanValue()) {
            this.ui.setAutoComplete(false);
        }
        if (previousSelectedItem != null) {
            this.ui.getCombobox().setSelectedItem(null);
            this.ui.selectedItem = null;
        }
        try {
            DecoratorUtils.sort(this.decorator, this.ui.getData(), (int)newValue);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        SwingUtil.fillComboBox((JComboBox)this.ui.getCombobox(), this.ui.getData(), null);
        if (wasAutoComplete.booleanValue()) {
            this.ui.setAutoComplete(true);
        }
        if (previousSelectedItem != null) {
            this.ui.setSelectedItem(previousSelectedItem);
        }
        this.ui.getCombobox().requestFocus();
    }

    protected void setSelectedItem(Object oldValue, Object newValue) {
        if (this.ui.getBean() == null) {
            return;
        }
        if (newValue == null) {
            if (this.ui.getCombobox().getSelectedItem() == null) {
                return;
            }
            this.ui.getCombobox().setSelectedItem(null);
            if (this.ui.isAutoComplete().booleanValue()) {
                this.ui.setAutoComplete(false);
                this.ui.setAutoComplete(true);
            }
            if (oldValue == null) {
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.ui.getProperty() + " on " + this.ui.getBean().getClass() + " :: " + oldValue + " to " + newValue));
        }
        try {
            Method mut = this.getMutator();
            if (mut != null) {
                mut.invoke(this.ui.getBean(), newValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Document getOriginalDocument() {
        return this.originalDocument;
    }

    public MultiJXPathDecorator<O> getDecorator() {
        return this.decorator;
    }

    protected void preparePopup(MultiJXPathDecorator<?> decorator) {
        String notSelectedTip;
        String selectedTip = this.ui.getSelectedToolTipText();
        if (selectedTip == null) {
            selectedTip = EntityComboBox.DEFAULT_SELECTED_TOOLTIP;
        }
        if ((notSelectedTip = this.ui.getNotSelectedToolTipText()) == null) {
            notSelectedTip = EntityComboBox.DEFAULT_NOT_SELECTED_TOOLTIP;
        }
        JPopupMenu popup = this.ui.getPopup();
        int max = decorator.getNbContext();
        for (int i = 0; i < max; ++i) {
            String property = this.ui.getI18nPrefix() + decorator.getProperty(i);
            String propertyI18n = I18n._((String)property);
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(propertyI18n);
            button.putClientProperty("$buttonGroup", this.ui.getIndexes());
            button.putClientProperty("$value", i);
            popup.add(button);
            if (selectedTip != null) {
                button.putClientProperty("$selected.toolTipText", I18n._((String)selectedTip, (Object[])new Object[]{propertyI18n}));
            }
            if (notSelectedTip != null) {
                button.putClientProperty("$not.selected.toolTipText", I18n._((String)notSelectedTip, (Object[])new Object[]{propertyI18n}));
            }
            button.setSelected(false);
            this.ui.getIndexes().add((AbstractButton)button);
        }
        String title = this.ui.getPopupTitleText();
        if (title == null) {
            title = EntityComboBox.DEFAULT_POPUP_LABEL;
            Class internalClass = decorator.getInternalClass();
            String beanI18nKey = internalClass == null ? I18n.n_((String)"bean.unknown.type") : this.ui.getI18nPrefix() + Introspector.decapitalize(internalClass.getSimpleName());
            String beanI18n = I18n._((String)beanI18nKey);
            title = I18n._((String)title, (Object[])new Object[]{beanI18n});
        } else {
            title = I18n._((String)title);
        }
        this.ui.getPopupLabel().setText(title);
        this.ui.getPopup().setLabel(title);
        this.ui.getPopup().invalidate();
    }

    public Class<?> getTargetClass() {
        Method m = this.getMutator();
        return m == null ? null : m.getParameterTypes()[0];
    }

    protected Method getMutator() {
        if (this.mutator == null) {
            Object bean = this.ui.getBean();
            if (bean == null) {
                throw new NullPointerException("could not find bean in " + this.ui);
            }
            String property = this.ui.getProperty();
            if (property == null) {
                throw new NullPointerException("could not find property in " + this.ui);
            }
            try {
                PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)property);
                if (descriptor != null) {
                    this.mutator = descriptor.getWriteMethod();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.mutator;
    }

    public static ObjectToStringConverter newDecoratedObjectToStringConverter(final Decorator<?> decorator) {
        return new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object item) {
                return item instanceof String ? (String)item : (item == null ? "" : decorator.toString(item));
            }
        };
    }

    public static void decorate(JComboBox combo, ObjectToStringConverter convertor) {
        AutoCompleteDecorator.decorate((JComboBox)combo, (ObjectToStringConverter)convertor);
    }

    public static void undecorate(JComboBox combo, Document originalDocument) {
        combo.setEditable(false);
        Component c = combo.getEditor().getEditorComponent();
        JTextComponent editorComponent = (JTextComponent)c;
        editorComponent.setDocument(originalDocument);
        editorComponent.setText(null);
        for (PropertyChangeListener l : c.getPropertyChangeListeners("editor")) {
            if (!(l instanceof AutoCompletePropertyChangeListener)) continue;
            c.removePropertyChangeListener("editor", l);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (SELECTED_ITEM_PROPERTY.equals(propertyName)) {
            this.setSelectedItem(evt.getOldValue(), evt.getNewValue());
            return;
        }
        if (INDEX_PROPERTY.equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            return;
        }
        if (AUTO_COMPLETE_PROPERTY.equals(propertyName)) {
            this.setAutoComplete((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if (DATA_PROPERTY.equals(propertyName)) {
            this.setIndex(-1, this.ui.getIndex());
        }
    }
}

