package org.nuiton.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Widgets DateTime
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n.t;

public class DateTimeEditor extends JPanel implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_TIME_EDITOR_SLIDER = "showTimeEditorSlider";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DAY_DATE_EDITOR_DATE = "dayDateEditor.date";
    public static final String BINDING_DAY_DATE_EDITOR_ENABLED = "dayDateEditor.enabled";
    public static final String BINDING_HOUR_EDITOR_ENABLED = "hourEditor.enabled";
    public static final String BINDING_HOUR_MODEL_VALUE = "hourModel.value";
    public static final String BINDING_MINUTE_EDITOR_ENABLED = "minuteEditor.enabled";
    public static final String BINDING_MINUTE_MODEL_VALUE = "minuteModel.value";
    public static final String BINDING_SLIDER_ENABLED = "slider.enabled";
    public static final String BINDING_SLIDER_HIDOR_TARGET_VISIBLE = "sliderHidor.targetVisible";
    public static final String BINDING_SLIDER_VALUE = "slider.value";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WTW8bRRieuLETOx8kTYhKGsBNoThQ1k6pekkF+XAsJ4qTKE6jQA5l7J3Ek65ntzuzjVOriJ/AT4A7Bypx44Q4cObABfUvIMSBK+Kd2e9ki5OqPozW7+fzvu/MM/P9nyjNbXTjGHc6mu0wQdtEW1/a399qHJOmKBPetKklTBu5v74USh2gIT2Qc4FuHmxI96LnXlwx25bJCIt4L2ygHBenBuEtQoRAb8c9mpwX64F6oWM5th81AJUU9du//0p9o3/9XQqhjgXoxqGUfC+vsJL+DZSiukBXIdMTXDQwOwIYNmVHgHdEylYMzPkmbpPH6Cs0sIEyFrYhmECzFy9ZxVD+HUugwffWtzEjRkmgomkfacyhwmSaAn1C9SMiuKZjQRT6MnzswseqDka2ZakwGYHSbVMnhkB3LxmhJt3CMNmW6bgygWZkuR2Nn0D1Wt2ijBFbOp9xGWpT5nhSKRoPVZO8ZZ6EueoG1Ykt0LgMrMneasumaRDMIgCeYLDCYC3QR7G5BQofkVz3fGEYIScrdRPCHKM1uG2WZtnAekT32rGBG7LouIMSSsvpwMGf1rz8PxPXQbDTciR7Xg7jGE7GI2FabsyOtr4vTbZp8xGxpV8+cB+VdYb+QYLQIifH40efjEH1BiQN3w/sM4YsoCr/vRvXDLtTCzPNxfVXuRpWleqmvQtDWsbnMnriOMKhiJ9A78Qm6Pop1bIjYIdKHy0Ey739MREvTEm9qdnoeiwk0IQW0kR4jvsOUNp2QCzQtYPzzLIDKpdTrp3hFBlQaf+dmvj9pxc/VnwiGYbcbyaaRngQDrhlmxYUQWXqN1wWcQQ1ijVsLRygLCcGkKgiyZkEYHVPDeAgn3tQpLtWxbwFIdIDf/z8y9SXv11BqQrKGSbWK1jar6GsaNnQBdPQO9ZniwrR8MkgrGMSGzS1Zdr0qckENpYMesTairRudmOHXK4rJuMCM6CMldXN3dWdZx1o00xCmwKsjeyv/0zUny/6reoD6G+91DxsV/oLlKHMoIwo1vUINZFlhyxOHN0MiTOJShHQoKDCIJbHBvfVuniuHVcE6ld8iCa7ijc1oMiye3YLc88EGjg07TYWMKTR7qyuF2u14in8ZqWKMNwwCNwRH3QpX3X/FObyt27l3VCU+0dYqiBcx5Eoyqox8quCzjJFL7wpcGhigzAd2xVKDEg+1V3xBFp168HOw63Kw/LS54AvDTzpQGWlbgsz3SC2rK3qs/qeVBaCmnc9winMJcMMr4MLQPSvoKFu4HWxfvk3xP/0K0J8F0Dy6nsdNoYgHTAe8+9LopJq1SRUHr2+wvjGw/HV1jYf7K5GJncnOrlaeLlecnbRe/kS0xvpRvxe2/xi180FjudIw7SB9bcxZULmTh9ig0NvMqaFH8sm+YLsIZCgyuzLktIn3Ga9QPQDCIFtaPQe5VTFn4YG1BNeNC5luG8deM/d6IrC7JntI5WaC2JWWbfg86XWUhm1zrhA4PHRdaXJA48U2au6QTC3ZHPVC4fLbW/LtuaUcBceJ6Esewgn6WNOn8J3an4ezkYbH0Mfwahu4SYcI5DfK4VbqNRl5CRfJofYMcSy6TCd6Dvw2nP3VKF0Oz9/Ow/rvVL+w/ydu7LCMdgfZ0N+UgrPxHQ3tu/XmHsuuNv617JFvedHr871qWN/asIDBo3eh8HhfIMyHSB/ei5qn1xzPSNK8Q9yeZ4c4TpE+A9htkAGlg0AAA==";
    private static final Log log = LogFactory.getLog(DateTimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "date",  editorName = "dateEditor")
    protected JPanel dateEditor;
    protected JLabel dateTimeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "dayDate",  editorName = "dayDateEditor")
    protected JXDatePicker dayDateEditor;
    protected final DateTimeEditorHandler handler = createHandler();
    protected JSpinner hourEditor;
    protected SpinnerDateModel hourModel;
    protected JLabel labelH;
    protected JSpinner minuteEditor;
    protected SpinnerDateModel minuteModel;
    protected DateTimeEditorModel model;
    protected Boolean showTimeEditorSlider;
    protected JSlider slider;
    protected HidorButton sliderHidor;
    protected JToolBar sliderHidorToolBar;
    @ValidatorField( validatorId = "validator",  propertyName = "timeDate",  editorName = "timeDateEditor")
    protected JPanel timeDateEditor;
    @Validator( validatorId = "validator")
    protected SwingValidator<DateTimeEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditor $JPanel0 = this;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    public void setPropertyTimeDate(String property) { model.setPropertyTimeDate(property); }
    public void setPropertyDayDate(String property) { model.setPropertyDayDate(property); }
    public void setPropertyDate(String property) { model.setPropertyDate(property); }
    public void setDateEditable(boolean dateEditable) { model.setDateEditable(dateEditable); }
    public void setTimeEditable(boolean timeEditable) { model.setTimeEditable(timeEditable); }
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setDate(Date date) { model.setDate(date); }
    
    public void setDateFormat(String dateFormat) { dayDateEditor.setFormats(dateFormat); }
    public void setLabel(String label) { dateTimeLabel.setText(label); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateTimeEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateTimeEditor() {
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateTimeEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__dayDateEditor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setDayDate((Date)((JXDatePicker)event.getSource()).getDate());
    }

    public void doStateChanged__on__hourEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setHours((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__minuteEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setMinutes((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__slider(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!slider.getValueIsAdjusting()) model.setTimeInMinutes((Integer)((JSlider)event.getSource()).getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getDateEditor() {
        return dateEditor;
    }

    public JLabel getDateTimeLabel() {
        return dateTimeLabel;
    }

    public JXDatePicker getDayDateEditor() {
        return dayDateEditor;
    }

    public DateTimeEditorHandler getHandler() {
        return handler;
    }

    public JSpinner getHourEditor() {
        return hourEditor;
    }

    public SpinnerDateModel getHourModel() {
        return hourModel;
    }

    public JLabel getLabelH() {
        return labelH;
    }

    public JSpinner getMinuteEditor() {
        return minuteEditor;
    }

    public SpinnerDateModel getMinuteModel() {
        return minuteModel;
    }

    public DateTimeEditorModel getModel() {
        return model;
    }

    public Boolean getShowTimeEditorSlider() {
        return showTimeEditorSlider;
    }

    public JSlider getSlider() {
        return slider;
    }

    public HidorButton getSliderHidor() {
        return sliderHidor;
    }

    public JToolBar getSliderHidorToolBar() {
        return sliderHidorToolBar;
    }

    public JPanel getTimeDateEditor() {
        return timeDateEditor;
    }

    public SwingValidator<DateTimeEditorModel> getValidator() {
        return validator;
    }

    public Boolean isShowTimeEditorSlider() {
        return showTimeEditorSlider !=null && showTimeEditorSlider;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowTimeEditorSlider(Boolean showTimeEditorSlider) {
        Boolean oldValue = this.showTimeEditorSlider;
        this.showTimeEditorSlider = showTimeEditorSlider;
        firePropertyChange(PROPERTY_SHOW_TIME_EDITOR_SLIDER, oldValue, showTimeEditorSlider);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDateEditor() {
        if (!allComponentsCreated) {
            return;
        }
        dateEditor.add(dateTimeLabel, BorderLayout.WEST);
        dateEditor.add($JPanel1, BorderLayout.EAST);
    }

    protected void addChildrenToSliderHidorToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        sliderHidorToolBar.add(sliderHidor);
    }

    protected void addChildrenToTimeDateEditor() {
        if (!allComponentsCreated) {
            return;
        }
        timeDateEditor.add(hourEditor);
        timeDateEditor.add(labelH);
        timeDateEditor.add(minuteEditor);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setBean(model);
    }

    protected void createDateEditor() {
        $objectMap.put("dateEditor", dateEditor = new JPanel());
        
        dateEditor.setName("dateEditor");
        dateEditor.setLayout(new BorderLayout());
    }

    protected void createDateTimeLabel() {
        $objectMap.put("dateTimeLabel", dateTimeLabel = new JLabel());
        
        dateTimeLabel.setName("dateTimeLabel");
    }

    protected void createDayDateEditor() {
        $objectMap.put("dayDateEditor", dayDateEditor = new JXDatePicker());
        
        dayDateEditor.setName("dayDateEditor");
        dayDateEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dayDateEditor"));
    }

    protected DateTimeEditorHandler createHandler() {
        return new DateTimeEditorHandler();
    }

    protected void createHourEditor() {
        $objectMap.put("hourEditor", hourEditor = new JSpinner());
        
        hourEditor.setName("hourEditor");
        hourEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hourEditor"));
    }

    protected void createHourModel() {
        $objectMap.put("hourModel", hourModel = new SpinnerDateModel());
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new JLabel());
        
        labelH.setName("labelH");
        labelH.setText(t("datetimeeditor.H"));
    }

    protected void createMinuteEditor() {
        $objectMap.put("minuteEditor", minuteEditor = new JSpinner());
        
        minuteEditor.setName("minuteEditor");
        minuteEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minuteEditor"));
    }

    protected void createMinuteModel() {
        $objectMap.put("minuteModel", minuteModel = new SpinnerDateModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = new DateTimeEditorModel());
    }

    protected void createShowTimeEditorSlider() {
        $objectMap.put("showTimeEditorSlider", showTimeEditorSlider = true);
    }

    protected void createSlider() {
        $objectMap.put("slider", slider = new JSlider());
        
        slider.setName("slider");
        slider.setValue(0);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        if (slider.getFont() != null) {
            slider.setFont(slider.getFont().deriveFont((float) 11));
        }
        slider.setMajorTickSpacing(60);
        slider.setMinorTickSpacing(30);
        slider.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__slider"));
    }

    protected void createSliderHidor() {
        $objectMap.put("sliderHidor", sliderHidor = new HidorButton());
        
        sliderHidor.setName("sliderHidor");
    }

    protected void createSliderHidorToolBar() {
        $objectMap.put("sliderHidorToolBar", sliderHidorToolBar = new JToolBar());
        
        sliderHidorToolBar.setName("sliderHidorToolBar");
        sliderHidorToolBar.setBorderPainted(false);
        sliderHidorToolBar.setOpaque(false);
        sliderHidorToolBar.setFloatable(false);
    }

    protected void createTimeDateEditor() {
        $objectMap.put("timeDateEditor", timeDateEditor = new JPanel());
        
        timeDateEditor.setName("timeDateEditor");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(DateTimeEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(SwingUtil.boxComponentWithJxLayer(dateEditor), BorderLayout.NORTH);
        add(slider, BorderLayout.SOUTH);
        addChildrenToValidator();
        addChildrenToDateEditor();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(dayDateEditor));
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(timeDateEditor));
        $JPanel1.add(sliderHidorToolBar);
        addChildrenToTimeDateEditor();
        addChildrenToSliderHidorToolBar();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        hourModel.setCalendarField(Calendar.HOUR_OF_DAY);
        minuteModel.setCalendarField(Calendar.MINUTE);
        dayDateEditor.setFormats("dd/MM/yyyy");
        hourEditor.setModel(hourModel);
        labelH.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        minuteEditor.setModel(minuteModel);
        sliderHidor.setShowTip(t("datetimeeditor.show.slider"));
        sliderHidor.setHideTip(t("datetimeeditor.hide.slider"));
        sliderHidor.setTarget(slider);
        slider.setModel(new DefaultBoundedRangeModel(0, 1, 0, 60 * 24));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createHourModel();
        createMinuteModel();
        createShowTimeEditorSlider();
        createValidator();
        createDateEditor();
        createDateTimeLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createDayDateEditor();
        createTimeDateEditor();
        createHourEditor();
        createLabelH();
        createMinuteEditor();
        createSliderHidorToolBar();
        createSliderHidor();
        createSlider();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hourModel.setValue(handler.getHourModelValue(model.getTimeDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteModel.setValue(handler.getMinuteModelValue(model.getTimeDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DAY_DATE_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dayDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dayDateEditor.setDate(model.getDayDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dayDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DAY_DATE_EDITOR_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (model != null) {
                    model.addPropertyChangeListener("dateEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dayDateEditor.setEnabled(isEnabled() && model.isDateEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (model != null) {
                    model.removePropertyChangeListener("dateEditable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_EDITOR_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (model != null) {
                    model.addPropertyChangeListener("timeEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hourEditor.setEnabled(isEnabled() && model.isTimeEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (model != null) {
                    model.removePropertyChangeListener("timeEditable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_EDITOR_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (model != null) {
                    model.addPropertyChangeListener("timeEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteEditor.setEnabled(isEnabled() && model.isTimeEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (model != null) {
                    model.removePropertyChangeListener("timeEditable", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_HIDOR_TARGET_VISIBLE, true ,"showTimeEditorSlider") {
        
            @Override
            public void processDataBinding() {
                sliderHidor.setTargetVisible(isShowTimeEditorSlider());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SLIDER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeInMinutes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    slider.setValue(model.getTimeInMinutes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeInMinutes", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SLIDER_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (model != null) {
                    model.addPropertyChangeListener("timeEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    slider.setEnabled(isEnabled() && model.isTimeEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (model != null) {
                    model.removePropertyChangeListener("timeEditable", this);
                }
            }
        });
    }

}
