/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VBoxLayout
implements LayoutManager {
    private int spacing = 6;
    private int horizontalAlignment = 2;
    private int verticalAlignment = 1;

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        int y;
        Insets insets = parent.getInsets();
        int parentWidth = parent.getSize().width - insets.left - insets.right;
        int count = parent.getComponentCount();
        Dimension preferredSize = parent.getPreferredSize();
        switch (this.verticalAlignment) {
            case 1: {
                y = insets.top;
                break;
            }
            case 0: {
                y = insets.top + (parent.getHeight() - preferredSize.height) / 2;
                break;
            }
            case 3: {
                y = insets.top + (parent.getHeight() - preferredSize.height);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid vertical alignment: " + this.verticalAlignment);
            }
        }
        for (int i = 0; i < count; ++i) {
            int x;
            Component component = parent.getComponent(i);
            Dimension childPreferredSize = component.getPreferredSize();
            int width = Math.min(childPreferredSize.width, parentWidth);
            switch (this.horizontalAlignment) {
                case 2: {
                    x = insets.left;
                    break;
                }
                case 0: {
                    x = insets.left + (parentWidth - childPreferredSize.width) / 2;
                    break;
                }
                case 4: {
                    x = insets.left + (parentWidth - childPreferredSize.width);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid horizontal alignment: " + this.horizontalAlignment);
                }
            }
            component.setBounds(x, y, width, childPreferredSize.height);
            y += childPreferredSize.height + this.spacing;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int width = 0;
        int height = (parent.getComponentCount() - 1) * this.spacing;
        for (int i = parent.getComponentCount() - 1; i >= 0; --i) {
            Dimension minimumSize = parent.getComponent(i).getMinimumSize();
            width = Math.max(width, minimumSize.width);
            height += minimumSize.height;
        }
        Insets insets = parent.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int width = 0;
        int height = (parent.getComponentCount() - 1) * this.spacing;
        for (int i = parent.getComponentCount() - 1; i >= 0; --i) {
            Dimension preferredSize = parent.getComponent(i).getPreferredSize();
            width = Math.max(width, preferredSize.width);
            height += preferredSize.height;
        }
        Insets insets = parent.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

