/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.awt.Component;
import java.io.Serializable;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NavigationTreeHandlerWithCardLayout
extends NavigationTreeHandler {
    private static final Log log = LogFactory.getLog(NavigationTreeHandlerWithCardLayout.class);

    protected abstract JPanel getContentContainer();

    protected abstract CardLayout2 getContentLayout();

    public NavigationTreeHandlerWithCardLayout(String contextPrefix, JAXXObject context, NavigationTreeHandler.Strategy strategy) {
        super(contextPrefix, context, strategy);
        if (this.getContentContainer() == null) {
            throw new IllegalArgumentException("could not have a null 'contentContainer' in ui " + context);
        }
        if (this.getContentLayout() == null) {
            throw new IllegalArgumentException("could not have a null 'contentLayout' in ui " + context);
        }
    }

    @Override
    protected Component getCurrentUI() {
        CardLayout2 layout = this.getContentLayout();
        JPanel container = this.getContentContainer();
        return layout.getVisibleComponent(container);
    }

    @Override
    protected Component getUI(NavigationTreeNode node) {
        CardLayout2 layout = this.getContentLayout();
        JPanel container = this.getContentContainer();
        String constraints = this.strategy.getId(node);
        return layout.contains((Serializable)((Object)constraints)) ? layout.getComponent(container, constraints) : null;
    }

    @Override
    protected void openUI(Component newUI, NavigationTreeNode node) throws Exception {
        CardLayout2 layout = this.getContentLayout();
        JPanel container = this.getContentContainer();
        String constraints = this.strategy.getId(node);
        layout.show(container, constraints);
    }

    @Override
    protected boolean closeUI(Component component) throws Exception {
        return true;
    }

    @Override
    protected Component createUI(NavigationTreeNode node) throws Exception {
        JAXXContext uiContext = this.createUIContext(node);
        JAXXObject newUI = node.getUIClass().getConstructor(JAXXContext.class).newInstance(uiContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("instanciate new ui " + newUI));
        }
        String constraints = this.strategy.getId(node);
        this.getContentContainer().add((Component)((Object)newUI), constraints);
        return (Component)((Object)newUI);
    }
}

