/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.swing.navigation;

/**
 * Basic contract on a content UI.
 *
 * @author chemit
 * @since 2.0.0
 */
public interface NavigationContentUI {

    /**
     * Init the ui just before been opened by the method
     * {@link NavigationTreeHandler#openUI(java.awt.Component,
     * jaxx.runtime.swing.navigation.NavigationTreeNode)}.
     *
     * @param node the selected node associated to the ui
     * @throws Exception if any pb while opening the content's ui
     * @see NavigationTreeHandler#openUI(java.awt.Component,
     *      jaxx.runtime.swing.navigation.NavigationTreeNode)
     */
    void openUI(NavigationTreeNode node) throws Exception;

    /**
     * Clean the ui after been closed by the method
     * {@link NavigationTreeHandler#closeUI(java.awt.Component)}.
     *
     * @param node the selected node associated to the ui
     * @throws Exception if any pb when closing the content'sui
     * @see NavigationTreeHandler#closeUI(java.awt.Component)
     */
    void closeUI(NavigationTreeNode node) throws Exception;
}
