/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.wizard;

import javax.swing.SwingWorker;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationModel;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardOperationStep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WizardOperationAction<E extends WizardOperationStep, M extends WizardOperationModel<E>>
extends SwingWorker<WizardOperationState, String> {
    private static final Log log = LogFactory.getLog(WizardOperationAction.class);
    E operation;
    WizardOperationState operationState;
    Exception error;

    public WizardOperationAction(E operation) {
        if (!operation.isOperation()) {
            throw new IllegalArgumentException("the step " + operation + " has no operation defined");
        }
        this.operation = operation;
    }

    public E getOperation() {
        return this.operation;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception e) {
        this.error = e;
    }

    public void sendMessage(String msg) {
        this.firePropertyChange("message", null, msg);
    }

    public abstract void start(JAXXContext var1);

    public abstract void beforeAction(JAXXContext var1, M var2) throws Exception;

    public abstract WizardOperationState doAction(M var1) throws Exception;

    public abstract WizardOperationState onError(M var1, Exception var2);

    public abstract WizardOperationState onCancel(M var1, Exception var2);

    protected abstract M getModel();

    public WizardOperationState getOperationState() {
        return this.operationState;
    }

    protected abstract JAXXContext getContext();

    public String toString() {
        return super.toString() + " < operation: " + this.operation + ", state: " + (Object)((Object)this.getState()) + " >";
    }

    @Override
    protected WizardOperationState doInBackground() throws Exception {
        WizardOperationState result;
        log.trace((Object)this);
        M model = this.getModel();
        try {
            this.beforeAction(this.getContext(), model);
            result = this.doAction(model);
        }
        catch (Exception e) {
            this.error = e;
            result = this.onError(model, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        log.trace((Object)this);
        WizardOperationState result = null;
        try {
            result = this.isCancelled() ? this.onCancel(this.getModel(), this.error) : (WizardOperationState)((Object)this.get());
        }
        catch (Exception e) {
            result = WizardOperationState.FAILED;
            this.error = e;
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.operationState = result;
        }
    }
}

