package jaxx.runtime.binding;

import jaxx.runtime.JAXXObject;

/**
 * Created: 5 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 1679 $
 *          <p/>
 *          Mise a jour: $Date: 2009-12-08 18:21:03 +0100 (mar., 08 déc. 2009) $ par :
 *          $Author: tchemit $
 */
public abstract class SimpleJAXXObjectBinding extends DefaultJAXXBinding {

    protected final String[] propertyNames;

    /**
     * Creates a new Data binding which will run the given data binding
     * when it receives a <code>PropertyChangeEvent</code>.
     *
     * @param source         the {@link jaxx.runtime.JAXXObject} source of the binding
     * @param id             the name of the data binding to run
     * @param defaultBinding flag to knwon if binding is coming from a generated jaxx object ({@code true}).
     * @param propertyNames  the name of properties to listen on source
     */
    public SimpleJAXXObjectBinding(JAXXObject source, String id, boolean defaultBinding, String... propertyNames) {
        super(source, id, defaultBinding);
        if (propertyNames == null || propertyNames.length == 0) {
            throw new IllegalArgumentException("must at least have one propertyName ");
        }
        this.propertyNames = propertyNames;
    }

    public boolean canApply() {
        return true;
    }

    public String[] getPropertyNames() {
        return propertyNames;
    }

    @Override
    public void applyDataBinding() {
        if (canApply()) {
            for (String s : propertyNames) {
                source.addPropertyChangeListener(s, this);
            }
        }
    }

    @Override
    public void removeDataBinding() {
        if (canApply()) {
            for (String s : propertyNames) {
                source.removePropertyChangeListener(s, this);
            }
        }
    }
}
