/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.context;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultApplicationContext
extends DefaultJAXXContext {
    protected Map<Class<?>, Class<?>> forwards = new HashMap();
    private static final Log log = LogFactory.getLog(DefaultApplicationContext.class);
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        MethodAccess access;
        Object value;
        Class<Object> realClass;
        if (this.forwards.containsKey(clazz)) {
            realClass = this.forwards.get(clazz);
            value = this.getContextValue(realClass, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("detect forward from " + clazz + " to " + realClass + " (" + value + ")"));
            }
        } else {
            realClass = clazz;
            value = super.getContextValue(realClass, name);
        }
        if (value == null) {
            AutoLoad anno = clazz.getAnnotation(AutoLoad.class);
            if (anno == null) {
                return null;
            }
            if (name != null) {
                throw new IllegalArgumentException("an " + AutoLoad.class.getName() + " can not have a named context but was call with this one : " + name);
            }
            value = this.newInstance(clazz);
            if (!anno.initMethod().trim().isEmpty()) {
                this.newAccess(clazz, value, anno.initMethod().trim());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("new instance " + clazz + " : " + value));
            }
            this.setContextValue(value, null);
        }
        if ((access = realClass.getAnnotation(MethodAccess.class)) != null) {
            if (name == null) {
                Class<?> targetClass;
                if (access.target() != Object.class && !this.forwards.containsKey(targetClass = access.target())) {
                    this.forwards.put(targetClass, clazz);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("register forward from " + targetClass + " to " + clazz));
                    }
                }
            } else {
                value = this.newAccess(realClass, value, access.methodName(), name);
            }
        }
        return value;
    }

    @Override
    public <T> void removeContextValue(Class<T> klazz, String name) {
        if (name == null && this.forwards.containsValue(klazz)) {
            Iterator<Map.Entry<Class<?>, Class<?>>> itr = this.forwards.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<Class<?>, Class<?>> entry = itr.next();
                if (!entry.getValue().equals(klazz)) continue;
                itr.remove();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("removed forward from " + entry.getKey() + " to " + klazz));
                break;
            }
        }
        super.removeContextValue(klazz, name);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    protected Object newInstance(Class<?> clazz) throws IllegalArgumentException {
        Object value;
        Constructor<?> constructor;
        try {
            constructor = clazz.getConstructor(new Class[0]);
            if (constructor == null) {
                throw new IllegalArgumentException(clazz + " has no public constructor");
            }
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
        try {
            value = constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
        return value;
    }

    protected Object newAccess(Class<?> clazz, Object parent, String methodName, String name) throws IllegalArgumentException {
        try {
            Method m = clazz.getMethod(methodName, String.class);
            Object value = m.invoke(parent, name);
            return value;
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected Object newAccess(Class<?> clazz, Object parent, String methodName) throws IllegalArgumentException {
        try {
            Method m = clazz.getMethod(methodName, new Class[0]);
            Object value = m.invoke(parent, new Object[0]);
            return value;
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(name, oldValue, newValue);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface MethodAccess {
        public Class<?> target() default Object.class;

        public String methodName();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface AutoLoad {
        public String initMethod() default "";
    }
}

