/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.context;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultJAXXContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultJAXXContextTest {
    DefaultJAXXContext ctxt;

    @Before
    public void initContext() throws Exception {
        this.ctxt = new DefaultJAXXContext();
    }

    @Test
    public void testGetParentContext() throws Exception {
        DefaultJAXXContext expected = null;
        JAXXContext result = (JAXXContext)this.ctxt.getContextValue(JAXXContext.class);
        Assert.assertEquals(expected, (Object)result);
        DefaultJAXXContext parentContext = new DefaultJAXXContext();
        this.ctxt.setContextValue((Object)parentContext);
        expected = parentContext;
        result = (JAXXContext)this.ctxt.getContextValue(JAXXContext.class);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testSetGetContextValue() throws Exception {
        String result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertNull((Object)result);
        String expected = "yo";
        this.ctxt.setContextValue((Object)expected);
        result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertEquals((Object)expected, (Object)result);
        expected = "ya";
        this.ctxt.setContextValue((Object)expected, "second");
        result = (String)this.ctxt.getContextValue(String.class, "second");
        Assert.assertEquals((Object)expected, (Object)result);
        expected = "yi";
        this.ctxt.setContextValue((Object)expected, "second");
        result = (String)this.ctxt.getContextValue(String.class, "second");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testSetGetContextValueInParentContext() throws Exception {
        DefaultJAXXContext parentContext = new DefaultJAXXContext();
        this.ctxt.setContextValue((Object)parentContext);
        String result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertNull((Object)result);
        String expected = "yo";
        result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertNull((Object)result);
        parentContext.setContextValue((Object)expected);
        result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertEquals((Object)expected, (Object)result);
        expected = "ya";
        result = (String)this.ctxt.getContextValue(String.class, "second");
        Assert.assertNull((Object)result);
        parentContext.setContextValue((Object)expected, "second");
        result = (String)this.ctxt.getContextValue(String.class, "second");
        Assert.assertEquals((Object)expected, (Object)result);
        expected = "yi";
        result = (String)this.ctxt.getContextValue(String.class, "second");
        parentContext.setContextValue((Object)expected, "second");
        Assert.assertEquals((Object)"ya", (Object)result);
        result = (String)this.ctxt.getContextValue(String.class, "second");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testSetGetContextValue2() throws Exception {
        DefaultJAXXContext parentContext = new DefaultJAXXContext();
        this.ctxt.setContextValue((Object)parentContext);
        String result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertNull((Object)result);
        result = (String)this.ctxt.getContextValue(String.class, "yo");
        Assert.assertNull((Object)result);
        String expected = "yo";
        this.ctxt.setContextValue((Object)expected, "yo");
        result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertNull((Object)result);
        result = (String)this.ctxt.getContextValue(String.class, "yo");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testSetGetContextValueInParentParentContext() throws Exception {
        DefaultJAXXContext parentParentContext = new DefaultJAXXContext();
        DefaultJAXXContext parentContext = new DefaultJAXXContext();
        parentContext.setContextValue((Object)parentParentContext);
        this.ctxt.setContextValue((Object)parentContext);
        String result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertNull((Object)result);
        String expected = "yo";
        result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertNull((Object)result);
        parentParentContext.setContextValue((Object)expected);
        result = (String)this.ctxt.getContextValue(String.class);
        Assert.assertEquals((Object)expected, (Object)result);
        expected = "ya";
        result = (String)this.ctxt.getContextValue(String.class, "second");
        Assert.assertNull((Object)result);
        parentParentContext.setContextValue((Object)expected, "second");
        result = (String)this.ctxt.getContextValue(String.class, "second");
        Assert.assertEquals((Object)expected, (Object)result);
        expected = "yi";
        result = (String)this.ctxt.getContextValue(String.class, "second");
        parentParentContext.setContextValue((Object)expected, "second");
        Assert.assertEquals((Object)"ya", (Object)result);
        result = (String)this.ctxt.getContextValue(String.class, "second");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testEntrySet() throws Exception {
        Object o = new Object();
        this.ctxt.setContextValue(o);
        Assert.assertEquals((long)1L, (long)this.ctxt.data.size());
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object.class));
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object.class, "named"));
        this.ctxt.setContextValue(o, "named");
        Assert.assertEquals((long)2L, (long)this.ctxt.data.size());
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object.class));
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object.class, "named"));
        this.ctxt.removeContextValue(Object.class);
        Assert.assertEquals((long)1L, (long)this.ctxt.data.size());
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object.class));
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object.class, "named"));
        this.ctxt.removeContextValue(Object.class);
        Assert.assertEquals((long)1L, (long)this.ctxt.data.size());
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object.class));
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object.class, "named"));
        this.ctxt.removeContextValue(Object.class, "named");
        Assert.assertEquals((long)0L, (long)this.ctxt.data.size());
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object.class));
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object.class, "named"));
    }

    @Test
    public void testEntrySetWithParent() throws Exception {
        DefaultJAXXContext parentContext = new DefaultJAXXContext();
        this.ctxt.setContextValue((Object)parentContext);
        class Object2 {
            Object2() {
            }
        }
        Object2 o = new Object2();
        parentContext.setContextValue((Object)o);
        Assert.assertEquals((long)0L, (long)this.ctxt.data.size());
        Assert.assertEquals((long)1L, (long)parentContext.data.size());
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object2.class));
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object2.class, "named"));
        parentContext.setContextValue((Object)o, "named");
        Assert.assertEquals((long)0L, (long)this.ctxt.data.size());
        Assert.assertEquals((long)2L, (long)parentContext.data.size());
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object2.class));
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object2.class, "named"));
        parentContext.removeContextValue(Object2.class);
        Assert.assertEquals((long)0L, (long)this.ctxt.data.size());
        Assert.assertEquals((long)1L, (long)parentContext.data.size());
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object2.class));
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object2.class, "named"));
        parentContext.removeContextValue(Object2.class);
        Assert.assertEquals((long)0L, (long)this.ctxt.data.size());
        Assert.assertEquals((long)1L, (long)parentContext.data.size());
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object2.class));
        Assert.assertEquals((Object)o, (Object)this.ctxt.getContextValue(Object2.class, "named"));
        this.ctxt.removeContextValue(Object2.class, "named");
        Assert.assertEquals((long)0L, (long)this.ctxt.data.size());
        Assert.assertEquals((long)0L, (long)parentContext.data.size());
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object2.class));
        Assert.assertEquals(null, (Object)this.ctxt.getContextValue(Object2.class, "named"));
    }
}

