package org.nuiton.jaxx.demo.fun;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.css.DataBinding;
import org.nuiton.jaxx.runtime.css.Pseudoclasses;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n.t;

public class CalculatorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DISPLAY_STYLE_DISPLAY_GET_TEXT_STARTS_WITH_ADD = "display.style.display.getText().startsWith( \"-\" ).add";
    public static final String BINDING_DISPLAY_STYLE_DISPLAY_GET_TEXT_STARTS_WITH_REMOVE = "display.style.display.getText().startsWith( \"-\" ).remove";
    public static final String BINDING_DISPLAY_TEXT = "display.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALWWz08bRxTHx8ZefqVNW6REqhTJCjSACmtDAgURpQXsqEUmVAEpKFwyuzvYS8c7y8xbMImSQw+99R/ooddeqvwJlaJcWqmXXvkfKuVP6Ju1wT9Yr52ugmBZ7bz5vO97M/vd+f1fklWSzAlZMb3ABeGZR7ReN2XggVtj5tb6/v6OdcRsKDJlS9cHIUnjJ5Um6QMy7lw+V0DMgzKS8g1SXpPyTVJ+U9R84TGvDbRWJmMKzjhTVcYAyEzPybZS+d3LyLW6H8hmrkjVUbn+/mnhPMWKv6QJqfso/yaW/eV7AFpVZ8ok7TpAPisf0ROa59SroDjpehUs6CP9bJNTpR7RGjsmr8hwmRg+lQgDMv+/2hPiQlTdBzI+VWQ18T31GC8Ame4uwcFB8zDwzE3K7YBTBOl43w8JBhCDeRXXY0BmB5haCmNbk4en9qjFGSae7NU7dYqdMMMwPWm0Nddxlc/pGXZON6nejNwqU4txHXP9MjRlA5noCNoIADOFUUCyNmdUXgSn7TDRzchBgx0HlKv2gBHhM6mLuwQ4X3UAHLfiQmtwJW5wtfdgxudBv8T34thLcYPLvQdHVGCBpDb0Sb4Qx1+MG7wbk7wWcHB9ftYneSGmccqteLHThxwBvecbjnviOiyaIMmdXjsXXcZsuUzrhU8dkKwM8DHu+t4Gpz3qMUY13GmytzvpNGHgj69fyd9O351fWNItFJfrN6vNfdEffKkLA1dru97wowBcnt+m/toBGVWMo3WH1jwdr3y3GYnqUcWnmmRqkvktVVWkZYfP37y98eyfIZJ+SMa4oM5DquO/I6NQldgxwZ26//U3obhrpyN4/QT/hnBtTtEsq7jkK+gao4fCg3nlPsf+phdWcK2qzK1U0RrTd5fq2Lfp+L5dyny98+6vX3/+4s1F71KoemqQma3+ZZ8Sw/U4+lto6E2vjjTwcV+xwBEtI46yZoLmPNw0qqZj7oXX/SttSQEZOxSSVaQIPPyUZCwesHqgg5+Fxeg7qwPYscl7cdPdHV7uSjQ8WSisrhYK/XJ1vnGDljEkmdO3ipY9x1RhWEI6uLHJ/IuN8K6x285MWzIKrFTz4awxMHNvLtf8nX15Uf4htbH8a3uSWYFdZZDb3r2qC7WA/kr5fRbLaJOzHClng50w3pTTdm+Wd56UHpeKWtdEVUj3OWqjfJ2jvdXC80BWNja/IXx6HKDkDEj9b8yi9g+tNdvYLC2tF/HTHxZ32nxjMha+c10LvrgYVefFl7dfpaluWsQ+aZjv++z0CNWxmwRF1ESgmDjRHR94J3amMTwha5R/iEQDbPm2lgOZeiHCE7RZYbDH6jAzayqgEtQTF6ozudvzt3OzL/t20UCYQNnk4/sOBZqzXM/Bk9GDK8lT+jo2wFJnAMXo0T+iGRN9GfrxWzzO3W/YaI4CHoOtAFgPVTcGI+rLn9GEzxMTbiUm5BITJhMT7iQmzCUm5BMTFhMTlhITVhIT1hITHiQmrCcmFBMTthITtpHwH/1bTIOSEAAA";
    private static final Log log = LogFactory.getLog(CalculatorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton c;
    protected JButton ce;
    protected JButton d0;
    protected JButton d1;
    protected JButton d2;
    protected JButton d3;
    protected JButton d4;
    protected JButton d5;
    protected JButton d6;
    protected JButton d7;
    protected JButton d8;
    protected JButton d9;
    protected JLabel display;
    protected JButton divide;
    protected JButton dot;
    protected CalculatorEngine engine;
    protected JButton equals;
    protected JButton multiply;
    protected JButton plus;
    protected JButton sign;
    protected JButton subtract;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CalculatorDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    @Override
    protected String[] getSources() {
        return addDefaultSources( "CalculatorEngine.java" );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CalculatorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CalculatorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CalculatorDemo() {
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public CalculatorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__c(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.clear();
    }

    public void doActionPerformed__on__ce(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.clearEntry();
    }

    public void doActionPerformed__on__d0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(0);
    }

    public void doActionPerformed__on__d1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(1);
    }

    public void doActionPerformed__on__d2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(2);
    }

    public void doActionPerformed__on__d3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(3);
    }

    public void doActionPerformed__on__d4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(4);
    }

    public void doActionPerformed__on__d5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(5);
    }

    public void doActionPerformed__on__d6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(6);
    }

    public void doActionPerformed__on__d7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(7);
    }

    public void doActionPerformed__on__d8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(8);
    }

    public void doActionPerformed__on__d9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(9);
    }

    public void doActionPerformed__on__divide(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.divide();
    }

    public void doActionPerformed__on__dot(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.dot();
    }

    public void doActionPerformed__on__equals(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.equal();
    }

    public void doActionPerformed__on__multiply(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.multiply();
    }

    public void doActionPerformed__on__plus(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.add();
    }

    public void doActionPerformed__on__sign(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.toggleSign();
    }

    public void doActionPerformed__on__subtract(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.subtract();
    }

    public void doMouseEntered__on__divide(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, divide, "font-weight", "normal", Pseudoclasses.wrap((divide.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (divide.getFont() != null) {
            if (((String) value).equals("bold")) {
                divide.setFont(divide.getFont().deriveFont(divide.getFont().getStyle() | Font.BOLD));
            } else {
                divide.setFont(divide.getFont().deriveFont(divide.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__equals(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, equals, "font-weight", "normal", Pseudoclasses.wrap((equals.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (equals.getFont() != null) {
            if (((String) value).equals("bold")) {
                equals.setFont(equals.getFont().deriveFont(equals.getFont().getStyle() | Font.BOLD));
            } else {
                equals.setFont(equals.getFont().deriveFont(equals.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__multiply(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, multiply, "font-weight", "normal", Pseudoclasses.wrap((multiply.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (multiply.getFont() != null) {
            if (((String) value).equals("bold")) {
                multiply.setFont(multiply.getFont().deriveFont(multiply.getFont().getStyle() | Font.BOLD));
            } else {
                multiply.setFont(multiply.getFont().deriveFont(multiply.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__plus(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, plus, "font-weight", "normal", Pseudoclasses.wrap((plus.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (plus.getFont() != null) {
            if (((String) value).equals("bold")) {
                plus.setFont(plus.getFont().deriveFont(plus.getFont().getStyle() | Font.BOLD));
            } else {
                plus.setFont(plus.getFont().deriveFont(plus.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__sign(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, sign, "font-weight", "normal", Pseudoclasses.wrap((sign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (sign.getFont() != null) {
            if (((String) value).equals("bold")) {
                sign.setFont(sign.getFont().deriveFont(sign.getFont().getStyle() | Font.BOLD));
            } else {
                sign.setFont(sign.getFont().deriveFont(sign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__subtract(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, subtract, "font-weight", "normal", Pseudoclasses.wrap((subtract.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (subtract.getFont() != null) {
            if (((String) value).equals("bold")) {
                subtract.setFont(subtract.getFont().deriveFont(subtract.getFont().getStyle() | Font.BOLD));
            } else {
                subtract.setFont(subtract.getFont().deriveFont(subtract.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__divide(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, divide, "font-weight", "normal", Pseudoclasses.wrap((divide.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (divide.getFont() != null) {
            if (((String) value).equals("bold")) {
                divide.setFont(divide.getFont().deriveFont(divide.getFont().getStyle() | Font.BOLD));
            } else {
                divide.setFont(divide.getFont().deriveFont(divide.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__equals(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, equals, "font-weight", "normal", Pseudoclasses.wrap((equals.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (equals.getFont() != null) {
            if (((String) value).equals("bold")) {
                equals.setFont(equals.getFont().deriveFont(equals.getFont().getStyle() | Font.BOLD));
            } else {
                equals.setFont(equals.getFont().deriveFont(equals.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__multiply(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, multiply, "font-weight", "normal", Pseudoclasses.wrap((multiply.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (multiply.getFont() != null) {
            if (((String) value).equals("bold")) {
                multiply.setFont(multiply.getFont().deriveFont(multiply.getFont().getStyle() | Font.BOLD));
            } else {
                multiply.setFont(multiply.getFont().deriveFont(multiply.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__plus(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, plus, "font-weight", "normal", Pseudoclasses.wrap((plus.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (plus.getFont() != null) {
            if (((String) value).equals("bold")) {
                plus.setFont(plus.getFont().deriveFont(plus.getFont().getStyle() | Font.BOLD));
            } else {
                plus.setFont(plus.getFont().deriveFont(plus.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__sign(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, sign, "font-weight", "normal", Pseudoclasses.wrap((sign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (sign.getFont() != null) {
            if (((String) value).equals("bold")) {
                sign.setFont(sign.getFont().deriveFont(sign.getFont().getStyle() | Font.BOLD));
            } else {
                sign.setFont(sign.getFont().deriveFont(sign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__subtract(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, subtract, "font-weight", "normal", Pseudoclasses.wrap((subtract.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (subtract.getFont() != null) {
            if (((String) value).equals("bold")) {
                subtract.setFont(subtract.getFont().deriveFont(subtract.getFont().getStyle() | Font.BOLD));
            } else {
                subtract.setFont(subtract.getFont().deriveFont(subtract.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getC() {
        return c;
    }

    public JButton getCe() {
        return ce;
    }

    public JButton getD0() {
        return d0;
    }

    public JButton getD1() {
        return d1;
    }

    public JButton getD2() {
        return d2;
    }

    public JButton getD3() {
        return d3;
    }

    public JButton getD4() {
        return d4;
    }

    public JButton getD5() {
        return d5;
    }

    public JButton getD6() {
        return d6;
    }

    public JButton getD7() {
        return d7;
    }

    public JButton getD8() {
        return d8;
    }

    public JButton getD9() {
        return d9;
    }

    public JLabel getDisplay() {
        return display;
    }

    public JButton getDivide() {
        return divide;
    }

    public JButton getDot() {
        return dot;
    }

    public CalculatorEngine getEngine() {
        return engine;
    }

    public JButton getEquals() {
        return equals;
    }

    public JButton getMultiply() {
        return multiply;
    }

    public JButton getPlus() {
        return plus;
    }

    public JButton getSign() {
        return sign;
    }

    public JButton getSubtract() {
        return subtract;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createC() {
        $objectMap.put("c", c = new JButton());
        
        c.setName("c");
        c.setText(t("C"));
        SwingUtil.setComponentWidth(c,80);
        if (c.getFont() != null) {
            c.setFont(c.getFont().deriveFont((float) 18));
        }
        c.setForeground(new Color(255, 0, 0));
        SwingUtil.setComponentHeight(c,35);
        c.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__c"));
    }

    protected void createCe() {
        $objectMap.put("ce", ce = new JButton());
        
        ce.setName("ce");
        ce.setText(t("CE"));
        SwingUtil.setComponentWidth(ce,80);
        if (ce.getFont() != null) {
            ce.setFont(ce.getFont().deriveFont((float) 18));
        }
        ce.setForeground(new Color(255, 0, 0));
        SwingUtil.setComponentHeight(ce,35);
        ce.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ce"));
    }

    protected void createD0() {
        $objectMap.put("d0", d0 = new JButton());
        
        d0.setName("d0");
        d0.setText(t("0"));
        SwingUtil.setComponentWidth(d0,80);
        if (d0.getFont() != null) {
            d0.setFont(d0.getFont().deriveFont((float) 18));
        }
        d0.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d0,35);
        d0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d0"));
    }

    protected void createD1() {
        $objectMap.put("d1", d1 = new JButton());
        
        d1.setName("d1");
        d1.setText(t("1"));
        SwingUtil.setComponentWidth(d1,80);
        if (d1.getFont() != null) {
            d1.setFont(d1.getFont().deriveFont((float) 18));
        }
        d1.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d1,35);
        d1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d1"));
    }

    protected void createD2() {
        $objectMap.put("d2", d2 = new JButton());
        
        d2.setName("d2");
        d2.setText(t("2"));
        SwingUtil.setComponentWidth(d2,80);
        if (d2.getFont() != null) {
            d2.setFont(d2.getFont().deriveFont((float) 18));
        }
        d2.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d2,35);
        d2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d2"));
    }

    protected void createD3() {
        $objectMap.put("d3", d3 = new JButton());
        
        d3.setName("d3");
        d3.setText(t("3"));
        SwingUtil.setComponentWidth(d3,80);
        if (d3.getFont() != null) {
            d3.setFont(d3.getFont().deriveFont((float) 18));
        }
        d3.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d3,35);
        d3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d3"));
    }

    protected void createD4() {
        $objectMap.put("d4", d4 = new JButton());
        
        d4.setName("d4");
        d4.setText(t("4"));
        SwingUtil.setComponentWidth(d4,80);
        if (d4.getFont() != null) {
            d4.setFont(d4.getFont().deriveFont((float) 18));
        }
        d4.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d4,35);
        d4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d4"));
    }

    protected void createD5() {
        $objectMap.put("d5", d5 = new JButton());
        
        d5.setName("d5");
        d5.setText(t("5"));
        SwingUtil.setComponentWidth(d5,80);
        if (d5.getFont() != null) {
            d5.setFont(d5.getFont().deriveFont((float) 18));
        }
        d5.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d5,35);
        d5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d5"));
    }

    protected void createD6() {
        $objectMap.put("d6", d6 = new JButton());
        
        d6.setName("d6");
        d6.setText(t("6"));
        SwingUtil.setComponentWidth(d6,80);
        if (d6.getFont() != null) {
            d6.setFont(d6.getFont().deriveFont((float) 18));
        }
        d6.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d6,35);
        d6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d6"));
    }

    protected void createD7() {
        $objectMap.put("d7", d7 = new JButton());
        
        d7.setName("d7");
        d7.setText(t("7"));
        SwingUtil.setComponentWidth(d7,80);
        if (d7.getFont() != null) {
            d7.setFont(d7.getFont().deriveFont((float) 18));
        }
        d7.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d7,35);
        d7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d7"));
    }

    protected void createD8() {
        $objectMap.put("d8", d8 = new JButton());
        
        d8.setName("d8");
        d8.setText(t("8"));
        SwingUtil.setComponentWidth(d8,80);
        if (d8.getFont() != null) {
            d8.setFont(d8.getFont().deriveFont((float) 18));
        }
        d8.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d8,35);
        d8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d8"));
    }

    protected void createD9() {
        $objectMap.put("d9", d9 = new JButton());
        
        d9.setName("d9");
        d9.setText(t("9"));
        SwingUtil.setComponentWidth(d9,80);
        if (d9.getFont() != null) {
            d9.setFont(d9.getFont().deriveFont((float) 18));
        }
        d9.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(d9,35);
        d9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d9"));
    }

    protected void createDisplay() {
        $objectMap.put("display", display = new JLabel());
        
        display.setName("display");
        display.setHorizontalAlignment(4);
        display.setOpaque(true);
        display.setBackground(new Color(188, 229, 173));
        if (display.getFont() != null) {
            display.setFont(display.getFont().deriveFont(display.getFont().getStyle() | Font.BOLD));
        }
        if (display.getFont() != null) {
            display.setFont(display.getFont().deriveFont((float) 22));
        }
    }

    protected void createDivide() {
        $objectMap.put("divide", divide = new JButton());
        
        divide.setName("divide");
        divide.setText(t("\u00f7"));
        SwingUtil.setComponentWidth(divide,80);
        if (divide.getFont() != null) {
            divide.setFont(divide.getFont().deriveFont((float) 16));
        }
        divide.setForeground(new Color(0, 153, 0));
        SwingUtil.setComponentHeight(divide,35);
        divide.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__divide"));
        divide.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__divide"));
        divide.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__divide"));
    }

    protected void createDot() {
        $objectMap.put("dot", dot = new JButton());
        
        dot.setName("dot");
        dot.setText(t("."));
        SwingUtil.setComponentWidth(dot,80);
        if (dot.getFont() != null) {
            dot.setFont(dot.getFont().deriveFont((float) 20));
        }
        dot.setForeground(new Color(0, 0, 255));
        SwingUtil.setComponentHeight(dot,35);
        dot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dot"));
    }

    protected void createEngine() {
        $objectMap.put("engine", engine = new CalculatorEngine());
    }

    protected void createEquals() {
        $objectMap.put("equals", equals = new JButton());
        
        equals.setName("equals");
        equals.setText(t("="));
        SwingUtil.setComponentWidth(equals,80);
        if (equals.getFont() != null) {
            equals.setFont(equals.getFont().deriveFont((float) 16));
        }
        equals.setForeground(new Color(0, 153, 0));
        SwingUtil.setComponentHeight(equals,35);
        equals.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__equals"));
        equals.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__equals"));
        equals.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__equals"));
    }

    protected void createMultiply() {
        $objectMap.put("multiply", multiply = new JButton());
        
        multiply.setName("multiply");
        multiply.setText(t("x"));
        SwingUtil.setComponentWidth(multiply,80);
        if (multiply.getFont() != null) {
            multiply.setFont(multiply.getFont().deriveFont((float) 16));
        }
        multiply.setForeground(new Color(0, 153, 0));
        SwingUtil.setComponentHeight(multiply,35);
        multiply.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__multiply"));
        multiply.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__multiply"));
        multiply.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__multiply"));
    }

    protected void createPlus() {
        $objectMap.put("plus", plus = new JButton());
        
        plus.setName("plus");
        SwingUtil.setComponentWidth(plus,80);
        if (plus.getFont() != null) {
            plus.setFont(plus.getFont().deriveFont((float) 16));
        }
        plus.setForeground(new Color(0, 153, 0));
        SwingUtil.setComponentHeight(plus,35);
        plus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__plus"));
        plus.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__plus"));
        plus.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__plus"));
    }

    protected void createSign() {
        $objectMap.put("sign", sign = new JButton());
        
        sign.setName("sign");
        SwingUtil.setComponentWidth(sign,80);
        if (sign.getFont() != null) {
            sign.setFont(sign.getFont().deriveFont((float) 16));
        }
        sign.setForeground(new Color(0, 153, 0));
        SwingUtil.setComponentHeight(sign,35);
        sign.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sign"));
        sign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__sign"));
        sign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__sign"));
    }

    protected void createSubtract() {
        $objectMap.put("subtract", subtract = new JButton());
        
        subtract.setName("subtract");
        subtract.setText(t("-"));
        SwingUtil.setComponentWidth(subtract,80);
        if (subtract.getFont() != null) {
            subtract.setFont(subtract.getFont().deriveFont((float) 16));
        }
        subtract.setForeground(new Color(0, 153, 0));
        SwingUtil.setComponentHeight(subtract,35);
        subtract.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__subtract"));
        subtract.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__subtract"));
        subtract.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__subtract"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createEngine();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createDisplay();
        createC();
        createCe();
        createEquals();
        createD7();
        createD8();
        createD9();
        createPlus();
        createD4();
        createD5();
        createD6();
        createSubtract();
        createD1();
        createD2();
        createD3();
        createMultiply();
        createD0();
        createSign();
        createDot();
        createDivide();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        plus.setText("+");sign.setText("+/-");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (engine != null) {
                    engine.addPropertyChangeListener("displayText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (engine != null) {
                    display.setText(t(engine.getDisplayText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (engine != null) {
                    engine.removePropertyChangeListener("displayText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_STYLE_DISPLAY_GET_TEXT_STARTS_WITH_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if (display != null) {
                    display.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (display.getText().startsWith( "-" )) {
                    Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, display, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(display.getForeground()), 0);
                    if (!(value instanceof DataBinding)) {
                        display.setForeground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (display != null) {
                    display.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_STYLE_DISPLAY_GET_TEXT_STARTS_WITH_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if (display != null) {
                    display.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!(display.getText().startsWith( "-" ))) {
                    Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, display, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(display.getForeground()), 0);
                    if (!(value instanceof DataBinding)) {
                        display.setForeground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (display != null) {
                    display.removePropertyChangeListener("text", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(display, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(c, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ce, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(equals, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d7, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d8, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d9, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(plus, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d5, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d6, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(subtract, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d3, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(multiply, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d0, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sign, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(dot, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(divide, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 2 property setters
        display.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}