package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.i18n.I18nEditor;
import static org.nuiton.i18n.I18n.t;

public class I18nEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_POPUP_BORDER = "editor.popupBorder";
    public static final String BINDING_EDITOR_SHOW_ICON = "editor.showIcon";
    public static final String BINDING_EDITOR_SHOW_POPUP_ICON = "editor.showPopupIcon";
    public static final String BINDING_EDITOR_SHOW_POPUP_TEXT = "editor.showPopupText";
    public static final String BINDING_EDITOR_SHOW_TEXT = "editor.showText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL1_TEXT = "$JLabel1.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Wz08TQRTHp5W2QEF+qI3RRDFWa6JsbdSoKUGF0gipQoQDsRen3Um7uN0ZZ2ftcuHgwZv/gAevXgz/A/Fk4sUr/4MJf4JvZrcthXYprD3sjzdvPvN9b+a97Y+/KGZzdI/ymmY5hqCWtoVdV+OOJYwG0VZebG6uVrZIVRSIXeUGE5Qj7xeJomgZJfW23RZIK5eAlPVIWUnK+qTsIm0wahHrEChfQqO22DaJXSdECHSn7+SqbWfX2555lzncX6un6l5r/f6c24+QwtcoQi4D+WMQ9t1TADpRD5VQ1NAFmi5t4Y84a2KrBuK4YdUgoHFpWzSxbb/GDfIB7aBECcUZ5gATaPZM6VE4hXKZQMl0gTToGraIeV+gp0dD0GFQq7Zono3oMM615dwTa0k9SgJjihkXKJHewBWTAO1mv4TYTQhPU25y0kh77nB6pSVlWobu+q6eVTqNdXztOm1uEBcScanLd7FOqu8XqCv9Jrrdl6vUku8Xu8fG5dgaZQ6TvECHPoSW8Jx8nzo2VsKVHkEpq3S62vadYHKRBcp1wr3YUl1TpK1oEFPvnhb39kSgzNGUNw29RoStGbBbh7bsSCp9hUr9dX+Mo9v99g8KSOsUUOcsR8ooxh0ww973r11Zfm/Ayyu8m/0LTy6jHD/t7vDvzYP9VrWlQNzMSbMONRY4+oxTRrgwpLYJr9QcYZjZV5jly2jEJiZ0JdV1MsHK131PUA8qpiRJkyTtJbbrQIsl9vd+pt79OYeiRTRqUqwXsfRfRiOiziFj1NRd9uy5EjfWHIbrpJQJm2jiberAlp+f07HAMxXD0mHT513IUiY4S21Ru6sHv759ubXXylQENKYHmdnJVuwtihuWaVhEdSa/6fTsRElmE0ennY7Sq8dE5H2U+Q1iVl1zPeOvqGMvxx+6jrw9UhHIp8eKMnkiRZofhCLITqFyQmRTnvMyMYMFtOSKI8h8b+6FAbhDwm8uS2dlSHMhgJAaiLASmhCk4XJoDYMRgjRcCa3hZAKcE1P2zCINOrHXQis5BaGPhhsDxJIwaRVD4w7ApAfAJA99vkKiur7XITjHP93/Bdb6oxA2wtAcac4HEDKhz48k/APHq6Cy2gsAAA==";
    private static final Log log = LogFactory.getLog(I18nEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected I18nEditor editor;
    protected JTextField popupBorderText;
    protected JCheckBox showIcon;
    protected JCheckBox showPopupIcon;
    protected JCheckBox showPopupText;
    protected JCheckBox showText;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private I18nEditorDemo $DemoPanel0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected Border getPopupBorder(String text) {
        if (text==null || text.trim().isEmpty()) {
            return null;
        }
        return new TitledBorder(t(text));
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public I18nEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public I18nEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public I18nEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public I18nEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public I18nEditorDemo() {
        $initialize();
    }

    public I18nEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public I18nEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public I18nEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public I18nEditor getEditor() {
        return editor;
    }

    public JTextField getPopupBorderText() {
        return popupBorderText;
    }

    public JCheckBox getShowIcon() {
        return showIcon;
    }

    public JCheckBox getShowPopupIcon() {
        return showPopupIcon;
    }

    public JCheckBox getShowPopupText() {
        return showPopupText;
    }

    public JCheckBox getShowText() {
        return showText;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createEditor() {
        $objectMap.put("editor", editor = new I18nEditor());
        
        editor.setName("editor");
    }

    protected void createPopupBorderText() {
        $objectMap.put("popupBorderText", popupBorderText = new JTextField());
        
        popupBorderText.setName("popupBorderText");
        popupBorderText.setColumns(15);
    }

    protected void createShowIcon() {
        $objectMap.put("showIcon", showIcon = new JCheckBox());
        
        showIcon.setName("showIcon");
        showIcon.setSelected(true);
        showIcon.setText(t("jaxxdemo.i18neditor.showIcon"));
    }

    protected void createShowPopupIcon() {
        $objectMap.put("showPopupIcon", showPopupIcon = new JCheckBox());
        
        showPopupIcon.setName("showPopupIcon");
        showPopupIcon.setSelected(true);
        showPopupIcon.setText(t("jaxxdemo.i18neditor.showPopupIcon"));
    }

    protected void createShowPopupText() {
        $objectMap.put("showPopupText", showPopupText = new JCheckBox());
        
        showPopupText.setName("showPopupText");
        showPopupText.setSelected(true);
        showPopupText.setText(t("jaxxdemo.i18neditor.showPopupText"));
    }

    protected void createShowText() {
        $objectMap.put("showText", showText = new JCheckBox());
        
        showText.setName("showText");
        showText.setSelected(true);
        showText.setText(t("jaxxdemo.i18neditor.showText"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0,1));
        createShowText();
        createShowIcon();
        createShowPopupText();
        createShowPopupIcon();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("jaxxdemo.i18neditor.popupBorderText"));
        createPopupBorderText();
        createEditor();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_POPUP_BORDER, true) {
        
            @Override
            public void applyDataBinding() {
                if (popupBorderText != null) {
                    $bindingSources.put("popupBorderText.getDocument()", popupBorderText.getDocument());
                    popupBorderText.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    popupBorderText.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_POPUP_BORDER));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (popupBorderText != null) {
                    editor.setPopupBorder(getPopupBorder(popupBorderText.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (popupBorderText != null) {
                    Document $target = (Document) $bindingSources.remove("popupBorderText.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    popupBorderText.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_POPUP_BORDER));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showIcon != null) {
                    $bindingSources.put("showIcon.getModel()", showIcon.getModel());
                    showIcon.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showIcon.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_ICON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showIcon != null) {
                    editor.setShowIcon(showIcon.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showIcon != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showIcon.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showIcon.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_ICON));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_POPUP_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupIcon != null) {
                    $bindingSources.put("showPopupIcon.getModel()", showPopupIcon.getModel());
                    showPopupIcon.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showPopupIcon.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_ICON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupIcon != null) {
                    editor.setShowPopupIcon(showPopupIcon.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupIcon != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupIcon.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showPopupIcon.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_ICON));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_POPUP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupText != null) {
                    $bindingSources.put("showPopupText.getModel()", showPopupText.getModel());
                    showPopupText.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showPopupText.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupText != null) {
                    editor.setShowPopupText(showPopupText.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupText != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupText.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showPopupText.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_TEXT));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (showText != null) {
                    $bindingSources.put("showText.getModel()", showText.getModel());
                    showText.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    showText.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showText != null) {
                    editor.setShowText(showText.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showText != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showText.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    showText.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_TEXT));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editor != null) {
                    editor.addPropertyChangeListener("selectedLocale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editor != null && editor.getSelectedLocale() != null) {
                    $JLabel1.setText(t(editor.getSelectedLocale().toString()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editor != null) {
                    editor.removePropertyChangeListener("selectedLocale", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(showText);
        $JPanel0.add(showIcon);
        $JPanel0.add(showPopupText);
        $JPanel0.add(showPopupIcon);
        $JPanel0.add($JPanel1);
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel0);
        $JPanel1.add(popupBorderText);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 7 property setters
        $JPanel0.setBorder(new TitledBorder(t("jaxxdemo.i18neditor.configuration")));
        $JLabel0.setLabelFor(popupBorderText);
        SwingUtil.setText(popupBorderText, t("jaxxdemo.i18neditor.popup.title"));
        
        editor.setLocales(Arrays.asList(I18n.getStore().getLocales()));
        $JLabel1.setBorder(new TitledBorder(t("jaxxdemo.i18neditor.selected.locale")));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}