package jaxx.demo.fun;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class CalculatorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DISPLAY_STYLE_DISPLAY_GET_TEXT_STARTS_WITH_ADD = "display.style.display.getText().startsWith( \"-\" ).add";
    public static final String BINDING_DISPLAY_STYLE_DISPLAY_GET_TEXT_STARTS_WITH_REMOVE = "display.style.display.getText().startsWith( \"-\" ).remove";
    public static final String BINDING_DISPLAY_TEXT = "display.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWzW8bRRQfO/7IR6FARFogQSaJUCI1azdtQqJUpUnsCCKnrZpIjcils7sTe8t4ZzPzNnFaFfEn8CfAnQsSNyQk1ANcOXBB/AsI9cAV8Wb9nay9RisiZ72e997v/d6bN7/db/8kaSXJB09pvW5I3wWnxozdzcPDB+ZTZkGRKUs6HghJGn+JJEkekQm7va6AzB2VdXi+GZ7fFjVPuMztit4ok3EF55ypKmMAZKY3wlIqv982b9Q9X7ZQ26TCUL9+9VfyK/vLb5KE1D1kdw1LyUVFdSpJlUnSsYG8hZlOaZ5Tt4I0pONWkO9rem2bU6Xu0xo7IV+QbJlkPCoRDMjs8CUHGEF83QMyMV9kNfGQuowXgEwHZG1cMY5919im3PI5xWjt5HlBWAZIhrkVx2VA3u/nXwocOhHZ+QNqcoYprvf0Q51hdUZg055jnQDbUR6n59gNXXi96blbpibj2udq2zVhAZnscdryAYQbeAFJW5xR2XJOWkGia6HGDDvxKVfdDqPCY1JX1AawP+oBsJ2KAx3j2iDjen9jyuN+VOLbg7BXBhlX+xtHlW+CpBZEJL85CH95kPHWgOQ1n4Pj8fOI5IUBjVNOxR0YPmIL6B+fsZ1Tx2bhCJK81zOuKAxGRxg6JzdxRNLSx2Wc76PLWvIITQ0VuX5BRTRgYP1navK3H/74fqclHTOY++1Q1y7lwyPtSU0WHJ36akM3fHB4fo96G0dkTDGOshnI4nQIsf2mGclhvjd1uKHDjU+oqiJEOvv7Ty+nnvw6QpI7ZJwLau9Q7f8pGYOqxC4Ibte9j+8FjK6cjeL1DfwfwbZWmVOpojIlb61gy89Q16r4Yw0VYOxYuLCknGfYweTNtTq2ZTqkLW1u5tjPf0/uf3ev1ZoEUn2nr3unPenPSMZxOepQoKtNyQzV0QlPMd8WHWkME0uCcpltaktT2Q6C6+GlBiSAjB8LySpS+C4qesrkPqv72vlJUIG+M3sAe+ayH27yYvdWLyTKzhUK6+uFQlSu3kMybBkjktmRVXQUNbKKY2phFVcOJDN9q8ogt7ePk2MKaeNIk6XnW8FdY+TODUsyCqxU8+C8YVi4fSPX/Cy+uMwLuYB+sHgRm4UiMFkV0nmGlCjf5KgnteChmpaNEc4Ij574yDQFUn/1bMHyMjbJpNbnnS3Y2i6tbBbx2Rr4nTUPQsrEw9JV3mpoeVvslPFmeV33RvnB49KjUjG8ztbDMqrSxEXuIXPS0Mv/MukhZQ4cEiRRE75i4lS3YehJ7E2TcYWsUf5/JBpi5LtaDmT+uQheTo0KgwNWh4VFQwGVoB47UF3IzS7N5hZfRHYxg2ACaZPX79gUaM50XBtfZu5eSp7Q1/EhtjoFSEZbfwzHmIzE0Msv8Q3sTkNGcxTwbdT0gfVhNTUcor78Eo7wbmyEmdgIudgIc7ERPoyNcCM2Qj42wnJshJXYCGuxETZiI9yNjbAZG6EYG2E3NsIeIvwL6LdBqOIPAAA=";
    private static final Log log = LogFactory.getLog(CalculatorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton c;
    protected JButton ce;
    protected JButton d0;
    protected JButton d1;
    protected JButton d2;
    protected JButton d3;
    protected JButton d4;
    protected JButton d5;
    protected JButton d6;
    protected JButton d7;
    protected JButton d8;
    protected JButton d9;
    protected JLabel display;
    protected JButton divide;
    protected JButton dot;
    protected CalculatorEngine engine;
    protected JButton equals;
    protected JButton multiply;
    protected JButton plus;
    protected JButton sign;
    protected JButton subtract;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CalculatorDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    @Override
    protected String[] getSources() {
        return addDefaultSources( "CalculatorEngine.java" );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CalculatorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CalculatorDemo() {
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public CalculatorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CalculatorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CalculatorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__c(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.clear();
    }

    public void doActionPerformed__on__ce(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.clearEntry();
    }

    public void doActionPerformed__on__d0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(0);
    }

    public void doActionPerformed__on__d1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(1);
    }

    public void doActionPerformed__on__d2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(2);
    }

    public void doActionPerformed__on__d3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(3);
    }

    public void doActionPerformed__on__d4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(4);
    }

    public void doActionPerformed__on__d5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(5);
    }

    public void doActionPerformed__on__d6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(6);
    }

    public void doActionPerformed__on__d7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(7);
    }

    public void doActionPerformed__on__d8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(8);
    }

    public void doActionPerformed__on__d9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.digit(9);
    }

    public void doActionPerformed__on__divide(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.divide();
    }

    public void doActionPerformed__on__dot(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.dot();
    }

    public void doActionPerformed__on__equals(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.equal();
    }

    public void doActionPerformed__on__multiply(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.multiply();
    }

    public void doActionPerformed__on__plus(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.add();
    }

    public void doActionPerformed__on__sign(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.toggleSign();
    }

    public void doActionPerformed__on__subtract(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        engine.subtract();
    }

    public void doMouseEntered__on__divide(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, divide, "font-weight", "normal", Pseudoclasses.wrap((divide.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (divide.getFont() != null) {
            if (((String) value).equals("bold")) {
                divide.setFont(divide.getFont().deriveFont(divide.getFont().getStyle() | Font.BOLD));
            } else {
                divide.setFont(divide.getFont().deriveFont(divide.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__equals(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, equals, "font-weight", "normal", Pseudoclasses.wrap((equals.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (equals.getFont() != null) {
            if (((String) value).equals("bold")) {
                equals.setFont(equals.getFont().deriveFont(equals.getFont().getStyle() | Font.BOLD));
            } else {
                equals.setFont(equals.getFont().deriveFont(equals.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__multiply(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, multiply, "font-weight", "normal", Pseudoclasses.wrap((multiply.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (multiply.getFont() != null) {
            if (((String) value).equals("bold")) {
                multiply.setFont(multiply.getFont().deriveFont(multiply.getFont().getStyle() | Font.BOLD));
            } else {
                multiply.setFont(multiply.getFont().deriveFont(multiply.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__plus(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, plus, "font-weight", "normal", Pseudoclasses.wrap((plus.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (plus.getFont() != null) {
            if (((String) value).equals("bold")) {
                plus.setFont(plus.getFont().deriveFont(plus.getFont().getStyle() | Font.BOLD));
            } else {
                plus.setFont(plus.getFont().deriveFont(plus.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__sign(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, sign, "font-weight", "normal", Pseudoclasses.wrap((sign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (sign.getFont() != null) {
            if (((String) value).equals("bold")) {
                sign.setFont(sign.getFont().deriveFont(sign.getFont().getStyle() | Font.BOLD));
            } else {
                sign.setFont(sign.getFont().deriveFont(sign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__subtract(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, subtract, "font-weight", "normal", Pseudoclasses.wrap((subtract.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (subtract.getFont() != null) {
            if (((String) value).equals("bold")) {
                subtract.setFont(subtract.getFont().deriveFont(subtract.getFont().getStyle() | Font.BOLD));
            } else {
                subtract.setFont(subtract.getFont().deriveFont(subtract.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__divide(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, divide, "font-weight", "normal", Pseudoclasses.wrap((divide.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (divide.getFont() != null) {
            if (((String) value).equals("bold")) {
                divide.setFont(divide.getFont().deriveFont(divide.getFont().getStyle() | Font.BOLD));
            } else {
                divide.setFont(divide.getFont().deriveFont(divide.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__equals(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, equals, "font-weight", "normal", Pseudoclasses.wrap((equals.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (equals.getFont() != null) {
            if (((String) value).equals("bold")) {
                equals.setFont(equals.getFont().deriveFont(equals.getFont().getStyle() | Font.BOLD));
            } else {
                equals.setFont(equals.getFont().deriveFont(equals.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__multiply(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, multiply, "font-weight", "normal", Pseudoclasses.wrap((multiply.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (multiply.getFont() != null) {
            if (((String) value).equals("bold")) {
                multiply.setFont(multiply.getFont().deriveFont(multiply.getFont().getStyle() | Font.BOLD));
            } else {
                multiply.setFont(multiply.getFont().deriveFont(multiply.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__plus(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, plus, "font-weight", "normal", Pseudoclasses.wrap((plus.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (plus.getFont() != null) {
            if (((String) value).equals("bold")) {
                plus.setFont(plus.getFont().deriveFont(plus.getFont().getStyle() | Font.BOLD));
            } else {
                plus.setFont(plus.getFont().deriveFont(plus.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__sign(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, sign, "font-weight", "normal", Pseudoclasses.wrap((sign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (sign.getFont() != null) {
            if (((String) value).equals("bold")) {
                sign.setFont(sign.getFont().deriveFont(sign.getFont().getStyle() | Font.BOLD));
            } else {
                sign.setFont(sign.getFont().deriveFont(sign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__subtract(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, subtract, "font-weight", "normal", Pseudoclasses.wrap((subtract.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (subtract.getFont() != null) {
            if (((String) value).equals("bold")) {
                subtract.setFont(subtract.getFont().deriveFont(subtract.getFont().getStyle() | Font.BOLD));
            } else {
                subtract.setFont(subtract.getFont().deriveFont(subtract.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getC() {
        return c;
    }

    public JButton getCe() {
        return ce;
    }

    public JButton getD0() {
        return d0;
    }

    public JButton getD1() {
        return d1;
    }

    public JButton getD2() {
        return d2;
    }

    public JButton getD3() {
        return d3;
    }

    public JButton getD4() {
        return d4;
    }

    public JButton getD5() {
        return d5;
    }

    public JButton getD6() {
        return d6;
    }

    public JButton getD7() {
        return d7;
    }

    public JButton getD8() {
        return d8;
    }

    public JButton getD9() {
        return d9;
    }

    public JLabel getDisplay() {
        return display;
    }

    public JButton getDivide() {
        return divide;
    }

    public JButton getDot() {
        return dot;
    }

    public CalculatorEngine getEngine() {
        return engine;
    }

    public JButton getEquals() {
        return equals;
    }

    public JButton getMultiply() {
        return multiply;
    }

    public JButton getPlus() {
        return plus;
    }

    public JButton getSign() {
        return sign;
    }

    public JButton getSubtract() {
        return subtract;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createC() {
        $objectMap.put("c", c = new JButton());
        
        c.setName("c");
        c.setText(t("C"));
        SwingUtil.setComponentHeight(c,35);
        if (c.getFont() != null) {
            c.setFont(c.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(c,80);
        c.setForeground(new Color(255, 0, 0));
        c.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__c"));
    }

    protected void createCe() {
        $objectMap.put("ce", ce = new JButton());
        
        ce.setName("ce");
        ce.setText(t("CE"));
        SwingUtil.setComponentHeight(ce,35);
        if (ce.getFont() != null) {
            ce.setFont(ce.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(ce,80);
        ce.setForeground(new Color(255, 0, 0));
        ce.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ce"));
    }

    protected void createD0() {
        $objectMap.put("d0", d0 = new JButton());
        
        d0.setName("d0");
        d0.setText(t("0"));
        SwingUtil.setComponentHeight(d0,35);
        if (d0.getFont() != null) {
            d0.setFont(d0.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d0,80);
        d0.setForeground(new Color(0, 0, 255));
        d0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d0"));
    }

    protected void createD1() {
        $objectMap.put("d1", d1 = new JButton());
        
        d1.setName("d1");
        d1.setText(t("1"));
        SwingUtil.setComponentHeight(d1,35);
        if (d1.getFont() != null) {
            d1.setFont(d1.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d1,80);
        d1.setForeground(new Color(0, 0, 255));
        d1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d1"));
    }

    protected void createD2() {
        $objectMap.put("d2", d2 = new JButton());
        
        d2.setName("d2");
        d2.setText(t("2"));
        SwingUtil.setComponentHeight(d2,35);
        if (d2.getFont() != null) {
            d2.setFont(d2.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d2,80);
        d2.setForeground(new Color(0, 0, 255));
        d2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d2"));
    }

    protected void createD3() {
        $objectMap.put("d3", d3 = new JButton());
        
        d3.setName("d3");
        d3.setText(t("3"));
        SwingUtil.setComponentHeight(d3,35);
        if (d3.getFont() != null) {
            d3.setFont(d3.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d3,80);
        d3.setForeground(new Color(0, 0, 255));
        d3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d3"));
    }

    protected void createD4() {
        $objectMap.put("d4", d4 = new JButton());
        
        d4.setName("d4");
        d4.setText(t("4"));
        SwingUtil.setComponentHeight(d4,35);
        if (d4.getFont() != null) {
            d4.setFont(d4.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d4,80);
        d4.setForeground(new Color(0, 0, 255));
        d4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d4"));
    }

    protected void createD5() {
        $objectMap.put("d5", d5 = new JButton());
        
        d5.setName("d5");
        d5.setText(t("5"));
        SwingUtil.setComponentHeight(d5,35);
        if (d5.getFont() != null) {
            d5.setFont(d5.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d5,80);
        d5.setForeground(new Color(0, 0, 255));
        d5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d5"));
    }

    protected void createD6() {
        $objectMap.put("d6", d6 = new JButton());
        
        d6.setName("d6");
        d6.setText(t("6"));
        SwingUtil.setComponentHeight(d6,35);
        if (d6.getFont() != null) {
            d6.setFont(d6.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d6,80);
        d6.setForeground(new Color(0, 0, 255));
        d6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d6"));
    }

    protected void createD7() {
        $objectMap.put("d7", d7 = new JButton());
        
        d7.setName("d7");
        d7.setText(t("7"));
        SwingUtil.setComponentHeight(d7,35);
        if (d7.getFont() != null) {
            d7.setFont(d7.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d7,80);
        d7.setForeground(new Color(0, 0, 255));
        d7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d7"));
    }

    protected void createD8() {
        $objectMap.put("d8", d8 = new JButton());
        
        d8.setName("d8");
        d8.setText(t("8"));
        SwingUtil.setComponentHeight(d8,35);
        if (d8.getFont() != null) {
            d8.setFont(d8.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d8,80);
        d8.setForeground(new Color(0, 0, 255));
        d8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d8"));
    }

    protected void createD9() {
        $objectMap.put("d9", d9 = new JButton());
        
        d9.setName("d9");
        d9.setText(t("9"));
        SwingUtil.setComponentHeight(d9,35);
        if (d9.getFont() != null) {
            d9.setFont(d9.getFont().deriveFont((float) 18));
        }
        SwingUtil.setComponentWidth(d9,80);
        d9.setForeground(new Color(0, 0, 255));
        d9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__d9"));
    }

    protected void createDisplay() {
        $objectMap.put("display", display = new JLabel());
        
        display.setName("display");
        display.setHorizontalAlignment(4);
        display.setOpaque(true);
        display.setBackground(new Color(188, 229, 173));
        if (display.getFont() != null) {
            display.setFont(display.getFont().deriveFont((float) 22));
        }
        if (display.getFont() != null) {
            display.setFont(display.getFont().deriveFont(display.getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createDivide() {
        $objectMap.put("divide", divide = new JButton());
        
        divide.setName("divide");
        divide.setText(t("\u00f7"));
        SwingUtil.setComponentHeight(divide,35);
        if (divide.getFont() != null) {
            divide.setFont(divide.getFont().deriveFont((float) 16));
        }
        SwingUtil.setComponentWidth(divide,80);
        divide.setForeground(new Color(0, 153, 0));
        divide.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__divide"));
        divide.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__divide"));
        divide.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__divide"));
    }

    protected void createDot() {
        $objectMap.put("dot", dot = new JButton());
        
        dot.setName("dot");
        dot.setText(t("."));
        SwingUtil.setComponentHeight(dot,35);
        if (dot.getFont() != null) {
            dot.setFont(dot.getFont().deriveFont((float) 20));
        }
        SwingUtil.setComponentWidth(dot,80);
        dot.setForeground(new Color(0, 0, 255));
        dot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dot"));
    }

    protected void createEngine() {
        $objectMap.put("engine", engine = new CalculatorEngine());
    }

    protected void createEquals() {
        $objectMap.put("equals", equals = new JButton());
        
        equals.setName("equals");
        equals.setText(t("="));
        SwingUtil.setComponentHeight(equals,35);
        if (equals.getFont() != null) {
            equals.setFont(equals.getFont().deriveFont((float) 16));
        }
        SwingUtil.setComponentWidth(equals,80);
        equals.setForeground(new Color(0, 153, 0));
        equals.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__equals"));
        equals.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__equals"));
        equals.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__equals"));
    }

    protected void createMultiply() {
        $objectMap.put("multiply", multiply = new JButton());
        
        multiply.setName("multiply");
        multiply.setText(t("x"));
        SwingUtil.setComponentHeight(multiply,35);
        if (multiply.getFont() != null) {
            multiply.setFont(multiply.getFont().deriveFont((float) 16));
        }
        SwingUtil.setComponentWidth(multiply,80);
        multiply.setForeground(new Color(0, 153, 0));
        multiply.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__multiply"));
        multiply.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__multiply"));
        multiply.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__multiply"));
    }

    protected void createPlus() {
        $objectMap.put("plus", plus = new JButton());
        
        plus.setName("plus");
        SwingUtil.setComponentHeight(plus,35);
        if (plus.getFont() != null) {
            plus.setFont(plus.getFont().deriveFont((float) 16));
        }
        SwingUtil.setComponentWidth(plus,80);
        plus.setForeground(new Color(0, 153, 0));
        plus.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__plus"));
        plus.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__plus"));
        plus.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__plus"));
    }

    protected void createSign() {
        $objectMap.put("sign", sign = new JButton());
        
        sign.setName("sign");
        SwingUtil.setComponentHeight(sign,35);
        if (sign.getFont() != null) {
            sign.setFont(sign.getFont().deriveFont((float) 16));
        }
        SwingUtil.setComponentWidth(sign,80);
        sign.setForeground(new Color(0, 153, 0));
        sign.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sign"));
        sign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__sign"));
        sign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__sign"));
    }

    protected void createSubtract() {
        $objectMap.put("subtract", subtract = new JButton());
        
        subtract.setName("subtract");
        subtract.setText(t("-"));
        SwingUtil.setComponentHeight(subtract,35);
        if (subtract.getFont() != null) {
            subtract.setFont(subtract.getFont().deriveFont((float) 16));
        }
        SwingUtil.setComponentWidth(subtract,80);
        subtract.setForeground(new Color(0, 153, 0));
        subtract.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__subtract"));
        subtract.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__subtract"));
        subtract.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__subtract"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(display, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(c, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ce, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(equals, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d7, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d8, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d9, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(plus, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d5, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d6, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(subtract, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d3, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(multiply, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(d0, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sign, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(dot, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(divide, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        display.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createEngine();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createDisplay();
        createC();
        createCe();
        createEquals();
        createD7();
        createD8();
        createD9();
        createPlus();
        createD4();
        createD5();
        createD6();
        createSubtract();
        createD1();
        createD2();
        createD3();
        createMultiply();
        createD0();
        createSign();
        createDot();
        createDivide();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        plus.setText("+");sign.setText("+/-");// registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (engine != null) {
                    engine.addPropertyChangeListener("displayText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (engine != null) {
                    display.setText(t(engine.getDisplayText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (engine != null) {
                    engine.removePropertyChangeListener("displayText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_STYLE_DISPLAY_GET_TEXT_STARTS_WITH_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if (display != null) {
                    display.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (display.getText().startsWith( "-" )) {
                    Object value = Pseudoclasses.applyProperty(CalculatorDemo.this, display, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(display.getForeground()), 0);
                    if (!(value instanceof DataBinding)) {
                        display.setForeground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (display != null) {
                    display.removePropertyChangeListener("text", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_STYLE_DISPLAY_GET_TEXT_STARTS_WITH_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if (display != null) {
                    display.addPropertyChangeListener("text", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!(display.getText().startsWith( "-" ))) {
                    Object value = Pseudoclasses.removeProperty(CalculatorDemo.this, display, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap(display.getForeground()), 0);
                    if (!(value instanceof DataBinding)) {
                        display.setForeground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (display != null) {
                    display.removePropertyChangeListener("text", this);
                }
            }
        });
    }

}