package jaxx.demo.component.jaxx;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.BlockingLayerUI2;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class BoxedDecoratorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_TOGGLE_TEXT = "toggle.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8TRxgeu3H8kYRSogRXgLS4ORhB11GqnkILsa3QROZDGCRUH8p4d3CWjHemM7PNoqiIC/f+hPbOpVJvPVU99Myhl6p/oao4cK36zuz6Y5ONs4jIWdnzPu/zPvN+2a/+QQUp0OWnOAxtEfjKGxJ7d+vRo7v9p8RRbSId4XHFBIr+cnmU76EFd3wuFfqk19Hujdi90WJDznziT3lvdlBFqmeUyD1ClEKXkh6OlI3u2LwZ8kCMWMei0lh/fPNv/gf3xU95hEIO6hbhKtZpXpObzHVQ3nMVOgeRvsMNiv0ByBCePwC9S/qsRbGUd/CQfIueo2IHzXMsgEyhWvYrGw7jH3KFFtbaZMjuYZ/QdYWuGrEunNjOiMI2Z00WErdNHCYwkGkfzg3LvEJFip8R8XAHZCQuKw9Aut2kzNmHN50INHErxW4bULLT/Tam4q09wH1KQG81xc/YNLI8dphXbDCgRKEVncQwBu629oizDxfTqHNjcKUfKMV8nRIoRcLBpCmJLkboLYWWE9CmOdag6lFsU3+8lGpqnWxqp5iW1na7jmCUamGQjvMJCRNTUnJpSKTEAwKj8lHCoeNJpTFrHPr2QiK1MBH2ZCImLZvroYIIqOaq9o4P0X0wReNTPTI+mtBY/1td/vPXv3/ZHs3MEsReSYVOjTz0MheME6E8HfrDaGAC5dHGbcw3e6gsCYV9YfbBxRRh3dgM4iCeSYOt3e2vsNwDikLxr99+X338+gOU30YVyrC7jTV+B5XVnoAsMOqG/MZNo2jxoATPs/A/BzXpx33bYpQJaLlDnxxY5kP98/Vr5nXle4XKBrfjMF+hxmFXV+ChFuAIghXZGUKBtLFeg7ge8z81cJv7g5r2LgaSRL5zSgRQkQp2HMJVdLaegS/Cx4QhVOhiSoXGaeqX/3i73P355qhKOcjaxyfCJ5UqfI3mPZ96PjG7LV5bqbtsgUsSuGyyntIWFppsGx4vhIZ5fnasFvn3zfH7plTL+sLkSr+7gaY23mnac7CzAMtg8uMGuiU8t2NO6uvXNtLppzZXhuTMKRICfSlysmCDLX7jUM/ZJ+4DY6ke1kY26wBLKzbWUmOP9uC7B27OCNzMHLiZPfBKTN6y6k8CSi1T9SszVLQyq2hlV3E+Jm9Pq7A2ZuloZ9bRztBghSFzCdX8ur/a5AkOqNJfAbf1ef2EDh59d7xLB5+57mKFrb7nuzBCXx7jzelnJQPjYjRhW2bcNOpFOtfSqVz6+OUMhrMZ1JSi7xiif7Fdj5achRX8XoMakBNuuZqB1zTIDG2a43/P/4vrKAsAAA==";
    private static final Log log = LogFactory.getLog(BoxedDecoratorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton buttonA;
    protected JButton buttonB;
    protected JButton buttonC;
    protected JButton buttonD;
    protected JPanel buttonPane;
    protected BlockingLayerUI layerUI;
    protected BlockingLayerUI2 layerUI2;
    protected JList messages;
    protected JCheckBox toggle;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BoxedDecoratorDemo $DemoPanel0 = this;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        for (JComponent boxed : SwingUtil.getLayeredComponents(this)) {
            if (boxed == buttonD) {
                SwingUtil.setLayerUI(boxed, layerUI2);
                continue;
            }
    
            BlockingLayerUI ui = layerUI.clone();
            if (boxed == buttonC) {
                ui.setBlock(true);
            }
            SwingUtil.setLayerUI(boxed, ui);
        }
    }
    
    public void setLayer(boolean active) {
        for (JComponent boxed : SwingUtil.getLayeredComponents(this)) {
            if (boxed == buttonD) {
                continue;
            }
            BlockingLayerUI ui = (BlockingLayerUI) SwingUtil.getLayer(boxed).getUI();
            if (boxed == buttonC) {
                ui.setBlock(active);
            } 
            ui.setUseIcon(active);
        }
    }
    
    protected void accept(ActionEvent e, String suffix) {
        JButton source = (JButton) e.getSource();
        String clickedMessage = (String) source.getClientProperty("clickedText");
        String msg = "'" + source.getText() + "' clicked - " + suffix + " : " + clickedMessage;
        ((DefaultListModel)messages.getModel()).addElement(msg);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BoxedDecoratorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BoxedDecoratorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BoxedDecoratorDemo() {
        $initialize();
    }

    public BoxedDecoratorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BoxedDecoratorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BoxedDecoratorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BoxedDecoratorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BoxedDecoratorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonA(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__buttonB(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__buttonC(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__buttonD(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__toggle(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setLayer(toggle.isSelected());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getButtonA() {
        return buttonA;
    }

    public JButton getButtonB() {
        return buttonB;
    }

    public JButton getButtonC() {
        return buttonC;
    }

    public JButton getButtonD() {
        return buttonD;
    }

    public JPanel getButtonPane() {
        return buttonPane;
    }

    public BlockingLayerUI getLayerUI() {
        return layerUI;
    }

    public BlockingLayerUI2 getLayerUI2() {
        return layerUI2;
    }

    public JList getMessages() {
        return messages;
    }

    public JCheckBox getToggle() {
        return toggle;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToButtonPane() {
        if (!allComponentsCreated) {
            return;
        }
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonA));
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonB));
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonC));
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonD));
    }

    protected void createButtonA() {
        $objectMap.put("buttonA", buttonA = new JButton());
        
        buttonA.setName("buttonA");
        buttonA.setText(t("button A"));
        buttonA.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonA"));
        buttonA.putClientProperty("clickedText", "button A was clicked");
    }

    protected void createButtonB() {
        $objectMap.put("buttonB", buttonB = new JButton());
        
        buttonB.setName("buttonB");
        buttonB.setText(t("button B"));
        buttonB.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonB"));
        buttonB.putClientProperty("clickedText", "button B was clicked");
    }

    protected void createButtonC() {
        $objectMap.put("buttonC", buttonC = new JButton());
        
        buttonC.setName("buttonC");
        buttonC.setText(t("button C (full block)"));
        buttonC.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonC"));
        buttonC.putClientProperty("clickedText", "button C was clicked");
    }

    protected void createButtonD() {
        $objectMap.put("buttonD", buttonD = new JButton());
        
        buttonD.setName("buttonD");
        buttonD.setText(t("button D (full block 2)"));
        buttonD.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonD"));
        buttonD.putClientProperty("clickedText", "button D was clicked");
    }

    protected void createButtonPane() {
        $objectMap.put("buttonPane", buttonPane = new JPanel());
        
        buttonPane.setName("buttonPane");
        buttonPane.setLayout(new GridLayout(0,2));
    }

    protected void createLayerUI() {
        $objectMap.put("layerUI", layerUI = new BlockingLayerUI());
        
        layerUI.setUseIcon(true);
    }

    protected void createLayerUI2() {
        $objectMap.put("layerUI2", layerUI2 = new BlockingLayerUI2());
    }

    protected void createMessages() {
        $objectMap.put("messages", messages = new JList());
        
        messages.setName("messages");
    }

    protected void createToggle() {
        $objectMap.put("toggle", toggle = new JCheckBox());
        
        toggle.setName("toggle");
        toggle.setSelected(true);
        toggle.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__toggle"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add(toggle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(buttonPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToButtonPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(messages);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        layerUI.setAcceptAction(new AbstractAction() {                      private static final long serialVersionUID = 1L;                      @Override                      public void actionPerformed(ActionEvent e) {                         accept(e, "from icon of layer");                      }                      });
        layerUI2.setAcceptAction(new AbstractAction() {                      private static final long serialVersionUID = 1L;                      @Override                      public void actionPerformed(ActionEvent e) {                         accept(e, "from icon of layer");                      }                      });
        layerUI.setBlockingColor(new Color(50,50,50));
        layerUI.setBlockIcon(SwingUtil.createImageIcon("action-block.png"));
        layerUI.setAcceptIcon(SwingUtil.createImageIcon("action-accept.png"));
        layerUI2.setBlockIcon(SwingUtil.createImageIcon("action-block.png"));
        layerUI2.setAcceptIcon(SwingUtil.createImageIcon("action-accept.png"));
        messages.setModel(new DefaultListModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createLayerUI();
        createLayerUI2();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createToggle();
        createButtonPane();
        createButtonA();
        createButtonB();
        createButtonC();
        createButtonD();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createMessages();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOGGLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (toggle != null) {
                    $bindingSources.put("toggle.getModel()", toggle.getModel());
                    toggle.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    toggle.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.BoxedDecoratorDemo.this, BINDING_TOGGLE_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (toggle != null) {
                    toggle.setText(t(toggle.isSelected() ? "Active layer" : "No layer"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (toggle != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("toggle.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    toggle.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.BoxedDecoratorDemo.this, BINDING_TOGGLE_TEXT));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}