/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: SimpleTimeEditorDemoModel.java 2752 2013-11-24 08:44:06Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.2/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/SimpleTimeEditorDemoModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.jaxx.editor;

import jaxx.runtime.swing.editor.SimpleTimeEditor;
import org.jdesktop.beans.AbstractSerializableBean;

import java.util.Date;

/**
 * Model of a bean using the {@link SimpleTimeEditor}.
 *
 * @author Tony CHEMIT <chemit@codelutin.com>
 * @since 2.6
 */
public class SimpleTimeEditorDemoModel extends AbstractSerializableBean {

    public static final String TIME_PROPERTY = "time";

    private static final long serialVersionUID = 1L;

    protected Date time;

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        Date old = this.time;
        this.time = time;
        firePropertyChange(TIME_PROPERTY, old, time);
    }


}
