/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: NavDemoTreeCellRenderer.java 2704 2013-07-21 10:57:39Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.30/jaxx-demo/src/main/java/jaxx/demo/feature/nav/tree/NavDemoTreeCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.demo.feature.nav.tree;

import jaxx.demo.entities.DemoDataProvider;
import jaxx.demo.entities.Movie;
import jaxx.demo.entities.People;
import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.DecoratorProvider;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import java.awt.Component;

/**
 * @author sletellier <letellier@codelutin.com>
 * @since 2.1
 */
public class NavDemoTreeCellRenderer extends AbstractNavTreeCellRenderer<DefaultTreeModel, NavDemoTreeNode> {

    /** Logger */
    protected static final Log log =
            LogFactory.getLog(NavDemoTreeCellRenderer.class);

    protected DecoratorProvider decoratorProvider;

    public NavDemoTreeCellRenderer(DecoratorProvider decoratorProvider,
                                   DemoDataProvider provider) {
        setDataProvider(provider);
        this.decoratorProvider = decoratorProvider;
    }

    @Override
    public DemoDataProvider getDataProvider() {
        return (DemoDataProvider) super.getDataProvider();
    }

    @Override
    protected String computeNodeText(NavDemoTreeNode node) {

        // Get node type
        Class<?> editType = node.getInternalClass();
        String id = node.getId();

        // get decorator
        Decorator<?> decorator = decoratorProvider.getDecoratorByType(editType);

        Object toDecorate = null;

        // People node
        if (editType.equals(People.class)) {
            toDecorate = getDataProvider().getPeople(id);

            // Movie node
        } else if (editType.equals(Movie.class)) {
            toDecorate = getDataProvider().getMovie(id);
        }

        // Get decorated value
        String decorated = decorator.toString(toDecorate);

        if (log.isDebugEnabled()) {
            log.debug("Compute text for node " +
                      node + " return " +
                      decorated);
        }

        return decorated;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree,
                                                  Object value,
                                                  boolean sel,
                                                  boolean expanded,
                                                  boolean leaf, int row,
                                                  boolean hasFocus) {

        // get node
        NavDemoTreeNode node = (NavDemoTreeNode) value;

        // get text for node
        String text = getNodeText(node);

        // Render node
        return super.getTreeCellRendererComponent(tree, text, sel,
                                                  expanded, leaf,
                                                  row, hasFocus);
    }
}
