package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.JAXXDatePicker;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DatePickerDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_PATTERN_LAYOUT = "patternLayout";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DATE_PICKER_SHOW_POPUP_BUTTON = "datePicker.showPopupButton";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRR+rRRoK4IQCChERIwnt5JoPECUH02jpCqxxBB7cdqd0IHt7jgza5eL8U/wT9C7FxNvnowHzx68GP8FYzx4Nb6ZbbtsXaGRHrbtvPd9871v33tvvkNGCri4R4LAEr6rWJNam2s7Ow9qe7SuilTWBePKExB+UmlIVyFvd8+lgkvVsoYX2vDChtfknkvdQ+jlMuSkOnCobFCqFMzFEXUpC5VueDngvuiwdkUlsb76+SP90n7xOg0QcFSXx1Lmj0NFlQyUIc1sBeN40zNScIi7izIEc3dR74g+23CIlPdJkz6F5zBUhkFOBJIpWOi/ZMNh8AFXkF8s0qa3RVzqXFNgGbE2nlj1DkV4Rm2GJFaRKLrF6vtUaBjnhmhQwQgnSlHhlsmB56OeMa3W0hVYYQVRas5GjpInmoiAcyZP0UBZFdbkDi12gxFiQCMUnDG5vmKOkRHFhxa3Sc2hqH86ZrZs4cWWienMbBcwKhtea8vjPl9HsZ6rYFJzB23E5kaD1vfXvUCnT3ZRw4ubZVIzPo3H0s1pPHc85keJUQff61QMtY1Fm0AcaewJLVY9c9AG4jREryFZ4pL+P9dDLKj0HfWI0dbhqIDzsUuw962o96PmTFUhI3w8Rperf4/LQwyFgzLdMyia0ER/T018ef/tXakzHTm8ezIx9dBwY9dy4XE0g+mrR8PR0E1QuEf4chWykjq4GczkzyYIq7TDKA7vOxv10B0iG0iRGfr64ePUk8+nIF2CnOMRu0R0/l3IqgZa1vAcO+C3V42i061hfI5pbQoGnXazn1nBd0bma8y18QXdCtCE2QQTukpq2U+/JipvVztGpFDYzD/TIzMyj2GQuQ5zqVkU7R2QuBjyXFLf9qJZT5r+lP7O8fYgXTXPpaRKh0OPqd5NK6GCeexvwWq+olivBt4whehfNw3vTB+8A3rwdXTlfzn08doRDLP9M1xPZrjQTx16Zo/gWOiDI75BT0jWu+BORHecx5dP7PEVZPgDBREVrvoHAAA=";
    private static final Log log = LogFactory.getLog(DatePickerDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Date date;
    protected SimpleDateFormat dateFormat;
    protected JAXXDatePicker datePicker;
    protected String patternLayout;
    protected JTextField patternLayoutField;
    protected JLabel resultView;
    protected JCheckBox showPopupButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DatePickerDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
            addPropertyChangeListener(PROPERTY_PATTERN_LAYOUT, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    dateFormat = new SimpleDateFormat(patternLayout);
                    datePicker.setPatternLayout(patternLayout);
                    resultView.setText(dateFormat.format(date));
                }
            });
    
            addPropertyChangeListener(PROPERTY_DATE, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    resultView.setText(dateFormat.format(date));
                }
            });
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DatePickerDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DatePickerDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DatePickerDemo() {
        $initialize();
    }

    public DatePickerDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public DatePickerDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DatePickerDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DatePickerDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public DatePickerDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__datePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setDate(datePicker.getDate());
    }

    public void doFocusLost__on__patternLayoutField(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPatternLayout(patternLayoutField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Date getDate() {
        return date;
    }

    public SimpleDateFormat getDateFormat() {
        return dateFormat;
    }

    public JAXXDatePicker getDatePicker() {
        return datePicker;
    }

    public String getPatternLayout() {
        return patternLayout;
    }

    public JTextField getPatternLayoutField() {
        return patternLayoutField;
    }

    public JLabel getResultView() {
        return resultView;
    }

    public JCheckBox getShowPopupButton() {
        return showPopupButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDate(Date date) {
        Date oldValue = this.date;
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public void setPatternLayout(String patternLayout) {
        String oldValue = this.patternLayout;
        this.patternLayout = patternLayout;
        firePropertyChange(PROPERTY_PATTERN_LAYOUT, oldValue, patternLayout);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDate() {
        $objectMap.put("date", date = new Date());
    }

    protected void createDateFormat() {
        $objectMap.put("dateFormat", dateFormat = new SimpleDateFormat(patternLayout));
    }

    protected void createDatePicker() {
        $objectMap.put("datePicker", datePicker = new JAXXDatePicker());
        
        datePicker.setName("datePicker");
        datePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__datePicker"));
    }

    protected void createPatternLayout() {
        $objectMap.put("patternLayout", patternLayout = "dd/MM/yyyy HH:mm:ss");
    }

    protected void createPatternLayoutField() {
        $objectMap.put("patternLayoutField", patternLayoutField = new JTextField());
        
        patternLayoutField.setName("patternLayoutField");
        patternLayoutField.setColumns(15);
        patternLayoutField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__patternLayoutField"));
    }

    protected void createResultView() {
        $objectMap.put("resultView", resultView = new JLabel());
        
        resultView.setName("resultView");
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = new JCheckBox());
        
        showPopupButton.setName("showPopupButton");
        showPopupButton.setSelected(false);
        showPopupButton.setText(_("jaxxdemo.datePickerEditor.showPopupButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add(showPopupButton, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(patternLayoutField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(datePicker, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultView, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        SwingUtil.setText(patternLayoutField, patternLayout);
        
        datePicker.setDate(date);
        datePicker.setPatternLayout(patternLayout);
        resultView.setText(_(dateFormat.format(date)));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createPatternLayout();
        createDateFormat();
        createDate();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createShowPopupButton();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("jaxxdemo.datePickerEditor.patternLayout"));
        createPatternLayoutField();
        createDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("jaxxdemo.datePickerEditor.dateResult"));
        createResultView();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_PICKER_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.DatePickerDemo.this, BINDING_DATE_PICKER_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    datePicker.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.DatePickerDemo.this, BINDING_DATE_PICKER_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}