package jaxx.demo;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import jaxx.demo.tree.DemoCellRenderer;
import jaxx.demo.tree.DemoTreeHelper;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.StatusMessagePanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DemoUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_ICON_IMAGE = "mainFrame.iconImage";
    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(DemoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemoConfig config;
    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected DemoUIHandler handler;
    protected DemoUI mainFrame = this;
    protected JPanel mainPane;
    protected JMenuBar menu;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenuItem menuFileFullscreen;
    protected JMenu menuFileLanguage;
    protected JMenuItem menuFileLanguageFR;
    protected JMenuItem menuFileLanguageUK;
    protected JMenuItem menuFileNormalscreen;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpHelp;
    protected JMenuItem menuHelpLogs;
    protected JMenuItem menuHelpSite;
    protected JTree navigation;
    protected JScrollPane navigationPane;
    protected StatusMessagePanel p;
    protected JSplitPane splitPane;
    protected DemoTreeHelper treeHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public boolean acceptLocale(Locale l, String expected) {
      return l !=null && l.toString().equals(expected);
    }
    
    private void $afterCompleteSetup() {
        getHandler().initUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoUI() {
        $initialize();
    }

    public DemoUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    public void doActionPerformed__on__menuFileFullscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpLogs(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showLogs(this);
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().gotoSite(this);
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoConfig getConfig() {
        return config;
    }

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public DemoUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPane() {
        return mainPane;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public JMenuItem getMenuHelpLogs() {
        return menuHelpLogs;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JTree getNavigation() {
        return navigation;
    }

    public JScrollPane getNavigationPane() {
        return navigationPane;
    }

    public StatusMessagePanel getP() {
        return p;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public DemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPane);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMainPane() {
        if (!allComponentsCreated) {
            return;
        }
        mainPane.add(splitPane, BorderLayout.CENTER);
        mainPane.add(p, BorderLayout.SOUTH);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpLogs);
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void addChildrenToNavigationPane() {
        if (!allComponentsCreated) {
            return;
        }
        navigationPane.getViewport().add(navigation);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add(navigationPane, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createConfig() {
        $objectMap.put("config", config = getContextValue(DemoConfig.class));
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
        content.putClientProperty("help", "ui.main.body.db.view.content");
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DemoUIHandler.class));
    }

    protected void createMainPane() {
        $objectMap.put("mainPane", mainPane = new JPanel());
        
        mainPane.setName("mainPane");
        mainPane.setLayout(new BorderLayout());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("jaxxdemo.menu.file"));
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("jaxxdemo.action.configuration"));
        menuFileConfiguration.setToolTipText(_("jaxxdemo.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("jaxxdemo.action.exit"));
        menuFileExit.setToolTipText(_("jaxxdemo.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("jaxxdemo.action.fullscreen"));
        menuFileFullscreen.setToolTipText(_("jaxxdemo.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.setToolTipText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new JMenuItem());
        
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(_("jaxxdemo.action.locale.fr"));
        menuFileLanguageFR.setToolTipText(_("jaxxdemo.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new JMenuItem());
        
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(_("jaxxdemo.action.locale.uk"));
        menuFileLanguageUK.setToolTipText(_("jaxxdemo.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("jaxxdemo.action.normalscreen"));
        menuFileNormalscreen.setToolTipText(_("jaxxdemo.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("jaxxdemo.menu.help"));
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("jaxxdemo.action.about"));
        menuHelpAbout.setToolTipText(_("jaxxdemo.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(_("jaxxdemo.action.help"));
        menuHelpHelp.setToolTipText(_("jaxxdemo.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpLogs() {
        $objectMap.put("menuHelpLogs", menuHelpLogs = new JMenuItem());
        
        menuHelpLogs.setName("menuHelpLogs");
        menuHelpLogs.setText(_("jaxxdemo.action.showLogs"));
        menuHelpLogs.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpLogs"));
        menuHelpLogs.putClientProperty("help", "ui.main.action.showLogs");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("jaxxdemo.action.site"));
        menuHelpSite.setToolTipText(_("jaxxdemo.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new JTree());
        
        navigation.setName("navigation");
        navigation.setRootVisible(false);
        if (navigation.getFont() != null) {
            navigation.setFont(navigation.getFont().deriveFont((float) 11));
        }
        navigation.setLargeModel(true);
        navigation.setShowsRootHandles(false);
    }

    protected void createNavigationPane() {
        $objectMap.put("navigationPane", navigationPane = new JScrollPane());
        
        navigationPane.setName("navigationPane");
    }

    protected void createP() {
        $objectMap.put("p", p = new StatusMessagePanel());
        
        p.setName("p");
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(6);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = getContextValue(DemoTreeHelper.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuHelp();
        addChildrenToMainPane();
        addChildrenToSplitPane();
        addChildrenToNavigationPane();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 30 property setters
        menuFile.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.menu.file.mnemonic"),'Z'));
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileConfiguration.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.configuration.mnemonic"),'Z'));
        menuFileLanguage.setIcon(SwingUtil.createActionIcon("translate"));
        menuFileLanguage.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.menu.file.locale.mnemonic"),'Z'));
        menuFileLanguageFR.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        menuFileLanguageFR.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.locale.fr.mnemonic"),'Z'));
        menuFileLanguageUK.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        menuFileLanguageUK.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.locale.uk.mnemonic"),'Z'));
        menuFileFullscreen.setIcon(SwingUtil.createActionIcon("fullscreen"));
        menuFileFullscreen.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.fullscreen.mnemonic"),'Z'));
        menuFileNormalscreen.setIcon(SwingUtil.createActionIcon("leave-fullscreen"));
        menuFileNormalscreen.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.normalscreen.mnemonic"),'Z'));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuFileExit.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.exit.mnemonic"),'Z'));
        menuHelp.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.menu.help.mnemonic"),'Z'));
        menuHelpLogs.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.showLogs.mnemonic"),'Z'));
        menuHelpHelp.setIcon(SwingUtil.createActionIcon("help"));
        menuHelpHelp.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.help.mnemonic"),'Z'));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpSite.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.site.mnemonic"),'Z'));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        menuHelpAbout.setMnemonic(SwingUtil.getFirstCharAt(_("jaxxdemo.action.about.mnemonic"),'Z'));
        navigationPane.setMinimumSize(new Dimension(230,0));
        navigationPane.setBorder(null);
        navigationPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        navigation.setModel(getTreeHelper().createModel());
        navigation.setCellRenderer(new DemoCellRenderer(getTreeHelper().getDataProvider()));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createContentLayout();
        createConfig();
        createHandler();
        createTreeHelper();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuHelp();
        createMenuHelpLogs();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMainPane();
        createSplitPane();
        createNavigationPane();
        createNavigation();
        createContent();
        createP();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(_("JAXX Demo"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_ICON_IMAGE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("iconPath", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setIconImage(SwingUtil.createIcon(getConfig().getIconPath()).getImage());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("iconPath", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}