package jaxx.demo.component.jaxx.widgets.number;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class NumberEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DOUBLE_EDITOR_AUTO_POPUP = "doubleEditor.autoPopup";
    public static final String BINDING_DOUBLE_EDITOR_ENABLED = "doubleEditor.enabled";
    public static final String BINDING_DOUBLE_EDITOR_NUMBER_PATTERN = "doubleEditor.numberPattern";
    public static final String BINDING_DOUBLE_EDITOR_NUMBER_VALUE = "doubleEditor.numberValue";
    public static final String BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON = "doubleEditor.showPopupButton";
    public static final String BINDING_DOUBLE_EDITOR_SHOW_RESET = "doubleEditor.showReset";
    public static final String BINDING_FLOAT_EDITOR_AUTO_POPUP = "floatEditor.autoPopup";
    public static final String BINDING_FLOAT_EDITOR_ENABLED = "floatEditor.enabled";
    public static final String BINDING_FLOAT_EDITOR_NUMBER_PATTERN = "floatEditor.numberPattern";
    public static final String BINDING_FLOAT_EDITOR_NUMBER_VALUE = "floatEditor.numberValue";
    public static final String BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON = "floatEditor.showPopupButton";
    public static final String BINDING_FLOAT_EDITOR_SHOW_RESET = "floatEditor.showReset";
    public static final String BINDING_INTEGER_EDITOR_AUTO_POPUP = "integerEditor.autoPopup";
    public static final String BINDING_INTEGER_EDITOR_ENABLED = "integerEditor.enabled";
    public static final String BINDING_INTEGER_EDITOR_NUMBER_PATTERN = "integerEditor.numberPattern";
    public static final String BINDING_INTEGER_EDITOR_NUMBER_VALUE = "integerEditor.numberValue";
    public static final String BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON = "integerEditor.showPopupButton";
    public static final String BINDING_INTEGER_EDITOR_SHOW_RESET = "integerEditor.showReset";
    public static final String BINDING_RESULT_DOUBLE_TEXT = "resultDouble.text";
    public static final String BINDING_RESULT_FLOAT_TEXT = "resultFloat.text";
    public static final String BINDING_RESULT_INTEGER_TEXT = "resultInteger.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Xz28bRRQemzi/nDQkaaIU2sY1KSSiWhepByAFQuJaJHJL1FhVhS+MvRN7y3p32Z0ljlZF/An8CXDngsSNE+LAmQMXxL+AEAfgghBvZtb7y7Neu2mk2Mm+97755ps377395ndUcGx04wnu9xXbNajWI8rR+48ff9h6Qtq0Spy2rVnUtJH4yeVRvomKavDcoeiVZp2FV/zwyoHZs0yDGJHo3Tqad+i5TpwuIZSia/GItuNUTgLzbt9y7QFqQEqG+tWff+S/VL/4Oo9Q3wJ2G7CVUlZUuJOpOsprKkUrsNJnuKJjowM0bM3oAN9F9uxAx47zAPfIp+hzNFNH0xa2AYyi8vhb5hg8vm9RVNyqkp55jA2i36boTU5WhSdKewCh8Gdnmtoh1FEMt9citvKAf91TNUBmAJbFIacpKvRMlegUvfOsUPdZfIg3s9XALZ0AuY2Yks4Z6KJwG/OcCwKuGxHAA9M41TqujalmGnyXzGuZfSwFEUtO1zw7Ni3X2ncpNQ2K1pjYfX+No4MuaX+yb/aZ+0o86iFxCBVR7PF6wgW71IwAS1xWNYOSDrGFCoIuZEBs/TpuCd5h2OVY2DGmlNjAez0W1yB9WtOIro6KvWcwCVUJteVT3cQ0SowZrsWdViJOPg1mKaV7pS+4opoumDJWXI16pS8Zc0tfc3braJD8cdGDZAnzZNEXTqQWRa+bdgeyGP4xMjObQVQCpCLXI7TciZsXBPdUe9EmjqvTgOIbCZ7CfCjYBhK+lYyvMRIS84IwVzmJqN1GL8fuINRJJayTYSHLNVHBduExXNrmcGl9CCZRVDcSRZUBcut/66u/fP/bd7VoJV2TukYaAVQ4yzYtYlONLb0kyqhLNb1yH1u7TTTnEB26CO8SVyXETnwzkIP1llm4wsKVD7DTBYjCzK8//Lj+8c8voHwNzYN6ag0z/0M0R7sgWtfU1b713h5ntHA2C58vwu8URVMtguF+zni8Oj6laC4oDVCxvESdUDRHUCHq9g5zDkoNc07UnaTzcDUTIan4fTiIq5KDCNRozf301+rJt3uDw8iBOFdS3cMDKXyEpjVD1wzCG5vfs6SNrGg5xFXNsDfJuhUCrRail8rvEjX+eTSke46i6ZZpq5AQ6K5nkLNSQ6NQBvb5s226XWab4C1K3FjCUaFfRZpGeYcpxBZo8K2zvx6hzDZjZXDLQ+lx/DOA9KC2S9gXVGyKbsppJQ5RRip59hdhsZnOgmdf6vqR3Jxs/cIp1p1MAsFdkRJI3KRxCOisvdZYQV/3ZG31acBoR85I0sJl3GStfjJ+l73hbhuye03ObqiLy7gN9/rJmK15kq4cUtuWUxvu9zJukrEgi1xuOK9lyNJJ6DlhS0ae54Qsm2yyoAvQe4hwhRckT7bvZB9ZNOKzZUl6ORQYeNicyUOKIuQR1lkdeUk0O+ZxGI3krrN+pz4PxyphpWheoDTOLQBZ8vxYpc06gbQUx+eyiaS44Q0fU5YQ1yW3cIQMG6EMtTAuKUIxgpmQYNHjcSMEiI6TE22/7ElyKWv/m7K7PkKAK6EA1UhgUoGFKGpCgkueiByhQWxmHuOmBZPBnQkmA76RtIkgOpWPQcAvjVVv9GqD7lK+VUq7TnI68beA8QntZRHiyRalE0vrkdpwz/Gp7GdREWce5RLPMDmZ2PvNOKmi43MTxgl06a6KKS61NEOFd8R3h7Bz7HN+3P0x6z9yjM1MDPb43xEIr14Y4dZYCH+PQLh9YYS3AeF/IAZHTxMUAAA=";
    private static final Log log = LogFactory.getLog(NumberEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autoPopupButton;
    protected NumberEditor doubleEditor;
    protected JLabel doubleNumberConfig;
    protected JCheckBox doubleNumberEnabled;
    protected JTextField doubleNumberPattern;
    protected NumberEditor floatEditor;
    protected JLabel floatNumberConfig;
    protected JCheckBox floatNumberEnabled;
    protected JTextField floatNumberPattern;
    protected final NumberEditorDemoHandler handler = createHandler();
    protected NumberEditor integerEditor;
    protected JLabel integerNumberConfig;
    protected JCheckBox integerNumberEnabled;
    protected JTextField integerNumberPattern;
    protected NumberEditorDemoModel model;
    protected Table numberEditorConfigurationPanel;
    protected JLabel resultDouble;
    protected JLabel resultFloat;
    protected JLabel resultInteger;
    protected JPanel resultPanel;
    protected JCheckBox showPopupButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NumberEditorDemo $DemoPanel0 = this;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public NumberEditorDemo() {
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutoPopupButton() {
        return autoPopupButton;
    }

    public NumberEditor getDoubleEditor() {
        return doubleEditor;
    }

    public JLabel getDoubleNumberConfig() {
        return doubleNumberConfig;
    }

    public JCheckBox getDoubleNumberEnabled() {
        return doubleNumberEnabled;
    }

    public JTextField getDoubleNumberPattern() {
        return doubleNumberPattern;
    }

    public NumberEditor getFloatEditor() {
        return floatEditor;
    }

    public JLabel getFloatNumberConfig() {
        return floatNumberConfig;
    }

    public JCheckBox getFloatNumberEnabled() {
        return floatNumberEnabled;
    }

    public JTextField getFloatNumberPattern() {
        return floatNumberPattern;
    }

    public NumberEditorDemoHandler getHandler() {
        return handler;
    }

    public NumberEditor getIntegerEditor() {
        return integerEditor;
    }

    public JLabel getIntegerNumberConfig() {
        return integerNumberConfig;
    }

    public JCheckBox getIntegerNumberEnabled() {
        return integerNumberEnabled;
    }

    public JTextField getIntegerNumberPattern() {
        return integerNumberPattern;
    }

    public NumberEditorDemoModel getModel() {
        return model;
    }

    public Table getNumberEditorConfigurationPanel() {
        return numberEditorConfigurationPanel;
    }

    public JLabel getResultDouble() {
        return resultDouble;
    }

    public JLabel getResultFloat() {
        return resultFloat;
    }

    public JLabel getResultInteger() {
        return resultInteger;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JCheckBox getShowPopupButton() {
        return showPopupButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToNumberEditorConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        numberEditorConfigurationPanel.add(showPopupButton, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(showResetButton, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(autoPopupButton, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberConfig, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberPattern, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberEnabled, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberConfig, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberPattern, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberEnabled, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberConfig, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberPattern, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberEnabled, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
    }

    protected void addChildrenToResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        resultPanel.add(resultInteger);
        resultPanel.add(resultFloat);
        resultPanel.add(resultDouble);
    }

    protected void createAutoPopupButton() {
        $objectMap.put("autoPopupButton", autoPopupButton = new JCheckBox());
        
        autoPopupButton.setName("autoPopupButton");
        autoPopupButton.setText(t("jaxxdemo.numbereditor.autoPopup"));
        autoPopupButton.setSelected(false);
    }

    protected void createDoubleEditor() {
        $objectMap.put("doubleEditor", doubleEditor = new NumberEditor(this));
        
        doubleEditor.setName("doubleEditor");
        doubleEditor.setProperty("doubleNumber");
    }

    protected void createDoubleNumberConfig() {
        $objectMap.put("doubleNumberConfig", doubleNumberConfig = new JLabel());
        
        doubleNumberConfig.setName("doubleNumberConfig");
        doubleNumberConfig.setText(t("jaxxdemo.numbereditor.doubleNumberConfig"));
    }

    protected void createDoubleNumberEnabled() {
        $objectMap.put("doubleNumberEnabled", doubleNumberEnabled = new JCheckBox());
        
        doubleNumberEnabled.setName("doubleNumberEnabled");
        doubleNumberEnabled.setSelected(true);
    }

    protected void createDoubleNumberPattern() {
        $objectMap.put("doubleNumberPattern", doubleNumberPattern = new JTextField());
        
        doubleNumberPattern.setName("doubleNumberPattern");
        doubleNumberPattern.setColumns(15);
    }

    protected void createFloatEditor() {
        $objectMap.put("floatEditor", floatEditor = new NumberEditor(this));
        
        floatEditor.setName("floatEditor");
        floatEditor.setProperty("floatNumber");
    }

    protected void createFloatNumberConfig() {
        $objectMap.put("floatNumberConfig", floatNumberConfig = new JLabel());
        
        floatNumberConfig.setName("floatNumberConfig");
        floatNumberConfig.setText(t("jaxxdemo.numbereditor.floatNumberConfig"));
    }

    protected void createFloatNumberEnabled() {
        $objectMap.put("floatNumberEnabled", floatNumberEnabled = new JCheckBox());
        
        floatNumberEnabled.setName("floatNumberEnabled");
        floatNumberEnabled.setSelected(true);
    }

    protected void createFloatNumberPattern() {
        $objectMap.put("floatNumberPattern", floatNumberPattern = new JTextField());
        
        floatNumberPattern.setName("floatNumberPattern");
        floatNumberPattern.setColumns(15);
    }

    protected NumberEditorDemoHandler createHandler() {
        return new NumberEditorDemoHandler();
    }

    protected void createIntegerEditor() {
        $objectMap.put("integerEditor", integerEditor = new NumberEditor(this));
        
        integerEditor.setName("integerEditor");
        integerEditor.setProperty("integerNumber");
    }

    protected void createIntegerNumberConfig() {
        $objectMap.put("integerNumberConfig", integerNumberConfig = new JLabel());
        
        integerNumberConfig.setName("integerNumberConfig");
        integerNumberConfig.setText(t("jaxxdemo.numbereditor.integerNumberConfig"));
    }

    protected void createIntegerNumberEnabled() {
        $objectMap.put("integerNumberEnabled", integerNumberEnabled = new JCheckBox());
        
        integerNumberEnabled.setName("integerNumberEnabled");
        integerNumberEnabled.setSelected(true);
    }

    protected void createIntegerNumberPattern() {
        $objectMap.put("integerNumberPattern", integerNumberPattern = new JTextField());
        
        integerNumberPattern.setName("integerNumberPattern");
        integerNumberPattern.setColumns(15);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(NumberEditorDemoModel.class));
    }

    protected void createNumberEditorConfigurationPanel() {
        $objectMap.put("numberEditorConfigurationPanel", numberEditorConfigurationPanel = new Table());
        
        numberEditorConfigurationPanel.setName("numberEditorConfigurationPanel");
    }

    protected void createResultDouble() {
        $objectMap.put("resultDouble", resultDouble = new JLabel());
        
        resultDouble.setName("resultDouble");
    }

    protected void createResultFloat() {
        $objectMap.put("resultFloat", resultFloat = new JLabel());
        
        resultFloat.setName("resultFloat");
    }

    protected void createResultInteger() {
        $objectMap.put("resultInteger", resultInteger = new JLabel());
        
        resultInteger.setName("resultInteger");
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new GridLayout(0,1));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = new JCheckBox());
        
        showPopupButton.setName("showPopupButton");
        showPopupButton.setText(t("jaxxdemo.numbereditor.showPopupButton"));
        showPopupButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.numbereditor.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(numberEditorConfigurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToNumberEditorConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(integerEditor);
        $JPanel0.add(floatEditor);
        $JPanel0.add(doubleEditor);
        addChildrenToResultPanel();
        
        // apply 21 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        SwingUtil.setText(integerNumberPattern, "-?\\d{0,3}");
        
        SwingUtil.setText(floatNumberPattern, "\\d{0,1}.\\d{0,2}");
        
        SwingUtil.setText(doubleNumberPattern, "-?\\d{0,4}.\\d{0,6}");
        
        numberEditorConfigurationPanel.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.configuration")));
        integerNumberConfig.setLabelFor(integerNumberPattern);
        floatNumberConfig.setLabelFor(floatNumberPattern);
        doubleNumberConfig.setLabelFor(doubleNumberPattern);
        integerEditor.setBean(model);
        integerEditor.setNumberType(Integer.class);
        floatEditor.setBean(model);
        floatEditor.setNumberType(Float.class);
        doubleEditor.setBean(model);
        doubleEditor.setNumberType(Double.class);
        resultPanel.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.model")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNumberEditorConfigurationPanel();
        createShowPopupButton();
        createShowResetButton();
        createAutoPopupButton();
        createIntegerNumberConfig();
        createIntegerNumberPattern();
        createIntegerNumberEnabled();
        createFloatNumberConfig();
        createFloatNumberPattern();
        createFloatNumberEnabled();
        createDoubleNumberConfig();
        createDoubleNumberPattern();
        createDoubleNumberEnabled();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout());
        createIntegerEditor();
        createFloatEditor();
        createDoubleEditor();
        createResultPanel();
        createResultInteger();
        createResultFloat();
        createResultDouble();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 21 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 21 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (integerNumberEnabled != null) {
                    $bindingSources.put("integerNumberEnabled.getModel()", integerNumberEnabled.getModel());
                    integerNumberEnabled.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    integerNumberEnabled.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (integerNumberEnabled != null) {
                    integerEditor.setEnabled(integerNumberEnabled.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (integerNumberEnabled != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("integerNumberEnabled.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    integerNumberEnabled.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopupButton != null) {
                    $bindingSources.put("autoPopupButton.getModel()", autoPopupButton.getModel());
                    autoPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    autoPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopupButton != null) {
                    integerEditor.setAutoPopup(autoPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    autoPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("integerNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    integerEditor.setNumberValue(model.getIntegerNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("integerNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_NUMBER_PATTERN, true) {
        
            @Override
            public void applyDataBinding() {
                if (integerNumberPattern != null) {
                    $bindingSources.put("integerNumberPattern.getDocument()", integerNumberPattern.getDocument());
                    integerNumberPattern.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u2"));
                    integerNumberPattern.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_NUMBER_PATTERN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (integerNumberPattern != null) {
                    integerEditor.setNumberPattern(integerNumberPattern.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (integerNumberPattern != null) {
                    Document $target = (Document) $bindingSources.remove("integerNumberPattern.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u2"));
                    }
                    integerNumberPattern.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_NUMBER_PATTERN));
                }
            }
        
            public void $pr$u2(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    integerEditor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    integerEditor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (floatNumberEnabled != null) {
                    $bindingSources.put("floatNumberEnabled.getModel()", floatNumberEnabled.getModel());
                    floatNumberEnabled.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    floatNumberEnabled.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (floatNumberEnabled != null) {
                    floatEditor.setEnabled(floatNumberEnabled.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (floatNumberEnabled != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("floatNumberEnabled.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    floatNumberEnabled.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopupButton != null) {
                    $bindingSources.put("autoPopupButton.getModel()", autoPopupButton.getModel());
                    autoPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    autoPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopupButton != null) {
                    floatEditor.setAutoPopup(autoPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    }
                    autoPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u6(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("floatNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    floatEditor.setNumberValue(model.getFloatNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("floatNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_NUMBER_PATTERN, true) {
        
            @Override
            public void applyDataBinding() {
                if (floatNumberPattern != null) {
                    $bindingSources.put("floatNumberPattern.getDocument()", floatNumberPattern.getDocument());
                    floatNumberPattern.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u7"));
                    floatNumberPattern.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_NUMBER_PATTERN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (floatNumberPattern != null) {
                    floatEditor.setNumberPattern(floatNumberPattern.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (floatNumberPattern != null) {
                    Document $target = (Document) $bindingSources.remove("floatNumberPattern.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u7"));
                    }
                    floatNumberPattern.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_NUMBER_PATTERN));
                }
            }
        
            public void $pr$u7(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u8"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    floatEditor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u8"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u8(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u9"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    floatEditor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u9"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u9(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (doubleNumberEnabled != null) {
                    $bindingSources.put("doubleNumberEnabled.getModel()", doubleNumberEnabled.getModel());
                    doubleNumberEnabled.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    doubleNumberEnabled.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (doubleNumberEnabled != null) {
                    doubleEditor.setEnabled(doubleNumberEnabled.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (doubleNumberEnabled != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("doubleNumberEnabled.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    }
                    doubleNumberEnabled.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u10(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopupButton != null) {
                    $bindingSources.put("autoPopupButton.getModel()", autoPopupButton.getModel());
                    autoPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    autoPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopupButton != null) {
                    doubleEditor.setAutoPopup(autoPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    }
                    autoPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u11(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("doubleNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    doubleEditor.setNumberValue(model.getDoubleNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("doubleNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_NUMBER_PATTERN, true) {
        
            @Override
            public void applyDataBinding() {
                if (doubleNumberPattern != null) {
                    $bindingSources.put("doubleNumberPattern.getDocument()", doubleNumberPattern.getDocument());
                    doubleNumberPattern.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u12"));
                    doubleNumberPattern.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_NUMBER_PATTERN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (doubleNumberPattern != null) {
                    doubleEditor.setNumberPattern(doubleNumberPattern.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (doubleNumberPattern != null) {
                    Document $target = (Document) $bindingSources.remove("doubleNumberPattern.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u12"));
                    }
                    doubleNumberPattern.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_NUMBER_PATTERN));
                }
            }
        
            public void $pr$u12(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    doubleEditor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u13(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    doubleEditor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.number.NumberEditorDemo.this, BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u14(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_INTEGER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("integerNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultInteger.setText(t(t("jaxxdemo.numbereditor.model.integer", model.getIntegerNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("integerNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_FLOAT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("floatNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultFloat.setText(t(t("jaxxdemo.numbereditor.model.float", model.getFloatNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("floatNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_DOUBLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("doubleNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultDouble.setText(t(t("jaxxdemo.numbereditor.model.double", model.getDoubleNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("doubleNumber", this);
                }
            }
        });
    }

}