/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.fun;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.fun.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class LabelStyleDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLUE_STYLE_BLUE_HAS_FOCUS_ADD = "blue.style.blue.hasFocus().add";
    public static final String BINDING_BLUE_STYLE_BLUE_HAS_FOCUS_REMOVE = "blue.style.blue.hasFocus().remove";
    public static final String BINDING_GREEN_STYLE_GREEN_HAS_FOCUS_ADD = "green.style.green.hasFocus().add";
    public static final String BINDING_GREEN_STYLE_GREEN_HAS_FOCUS_REMOVE = "green.style.green.hasFocus().remove";
    public static final String BINDING_RED_STYLE_RED_HAS_FOCUS_ADD = "red.style.red.hasFocus().add";
    public static final String BINDING_RED_STYLE_RED_HAS_FOCUS_REMOVE = "red.style.red.hasFocus().remove";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL5_FONT_SIZE = "$JLabel5.font-size";
    private static final String BINDING_$JLABEL5_FOREGROUND = "$JLabel5.foreground";
    private static final String BINDING_$JLABEL5_TEXT = "$JLabel5.text";
    private static final String BINDING_$JRADIO_BUTTON0_ENABLED = "$JRadioButton0.enabled";
    private static final String BINDING_$JRADIO_BUTTON1_ENABLED = "$JRadioButton1.enabled";
    private static final String BINDING_$JRADIO_BUTTON2_ENABLED = "$JRadioButton2.enabled";
    private static final String BINDING_$JRADIO_BUTTON3_ENABLED = "$JRadioButton3.enabled";
    private static final String BINDING_$JRADIO_BUTTON4_ENABLED = "$JRadioButton4.enabled";
    private static final String BINDING_$JRADIO_BUTTON5_ENABLED = "$JRadioButton5.enabled";
    private static final String BINDING_$JRADIO_BUTTON6_ENABLED = "$JRadioButton6.enabled";
    private static final String BINDING_$VBOX0_BACKGROUND = "$VBox0.background";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XTXPbRBheO7ETNyFpk0kIbYCUhJkArex8MjSZEjtugGAoU2egkAtra2Nvoi+kVaq0A8NP4B9Q7nCgw40Tw4EzBy4Mh/YHMAwHrgy7K1m2YmW1RM1kNNLu+z7v87y7+0j+9k+Qc2xw9RB6nmK7BsE6UnbLd+/ebhyiJqkip2lji5g28P8yWZDdByNqOO4QML9fY+nFIL24beqWaSCjJ3ujBi445ERDThshQsDz0Yym4xTr4fSGZ7l2BzUkFYf68O+/sl+pX36TBcCzKLvLVMpcUlZXyWANZLFKwAStdAyLGjRalIaNjRbl+wwb29ag47wPdfQZ+AIM1UDegjYFI+Aleckcg+d7FgEjC1Wkmx9AA2klAmY5WZWOKAeuodRgA2m8ESzIsnhanoCC2skhYCaiz7lH2Sp7sKFxioUwZWiBD5bY4xi7jIZTwwu7vBCtP8FEegGKP8qCxsPYQYI8Knc6ErdHx3Yw0tRobAd3iT1PRucGbEQbPRmBqWtYRTaPIyDXNDW6m05BLcdA5Vo2QgZ7uCLMXYnJHWxoLkpOXY1JLaiurp/U8f2e/F7pnSWNtpSPRmPzCx9WTI9GPhuzkmyKxb3W19W1kJNyCor3uxRd44kGbB61bNM11O02ah41TI+AqQg1Ph6UWwkTxxZ270AVmxWXENMo8f3Wk9QzJ8rjlG6IIpYTI1YSI1YTI9YSI9ZjIsZ7mse2Bz3uMUvFXNLHeIuGWvS02uBKJI7amtK1ta7vZPZBznbpMO3ufr8T3qFTvgfOnPJABshn/52e/O3HP37Y6RjfDVp7Kja0x7epIVm2aSGbYFZ63Hc9l2Ct+B60NvZBwUEaNX1u6rMxxOrBNCVH611i6QpLV96GTptC5IZ+/+nn6U9/HQDZHXBBM6G6A1n8O6BA2jbtgqmpnvXmFmc0em+YXi8yboQSg9gge7h55DDPsV3kUfmzMfJDDo3CL/9M1r/f6rQgQyk9d2Z4tw25T0AeGxo2EHf/wNhj3X7EcpCrml0Dj7N0QE19KPCywLFv82s9TugQMpgtUy+8+qD/iCrY8QkjdfGVzz2XwXzEtbG7j1mp0d7Nm1BvgICLOjw0bdbYugWbdNsSkF0rsXFsnB5fouP5hmlTIQRcf1Dhd/4KnihNG0GCbukWOfEnFpeuzQX/Z1ANuxKx2bPIZmPJZtZjuWaW+yv2WvT/WZJQcilWco3ulEAxNwOlUitvv5usmt4dmE3XYWstIZ8dgu6GoMnzt14vV8vVOJ3+y7S/UKLUUxUqy6xGXAX/Hfs0apSrrEpcDf4uPleJ4KNkYtM/x3OQ0I+2hkvQzb46GXadsJJ2ARv+ml0exiNMpUaYSUSgDdChh3VXF8BcloDJHcPgK+fcIElqXpBC+E6AMCeF8Cg1gkjFfGoVL6dWIYcgUrGYWsWrUnsTGwl7MxkmqRkyREK7HttUIYFzDWyo9J1wxtG/JoPYRrjVJgJeUigaPDFdjvLk/Cg97ilAKkogTbZNG983DQK1soZbhk79XCBRBjKvQ7uFjZQol47ZF2jz6dEqHFCV153gl9kZLVuWaf6BaaPE5icjhSc2FcJjAcKqzIl1/K8lQXeTYZLMZ12CyEij+ytJAPWGBNSwE3wep8JJEiWH8EiwPlIImRcFHDZTq5BDEKmQQhCquJlahRyCSIUUglDFVmoVcggiFVIIQhWV1CrkEEQqpBCEKqqpVcghiFRIIQhV7KRWIYcgUsEQ/gNeUvUz/xcAAA==";
    private static final Log log = LogFactory.getLog(jaxx.demo.fun.LabelStyleDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JCheckBox backgroundCheckbox;
    protected jaxx.runtime.swing.JAXXButtonGroup backgroundColor;
    protected javax.swing.JSlider blue;
    protected jaxx.runtime.swing.Table demoPanel;
    protected javax.swing.JSlider dummySize;
    protected javax.swing.JSlider green;
    protected javax.swing.JSlider red;
    protected javax.swing.JTextField text;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private LabelStyleDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JPanel $JPanel0;
    private jaxx.runtime.swing.VBox $VBox0;
    private javax.swing.JLabel $JLabel5;
    private jaxx.runtime.swing.VBox $VBox1;
    private javax.swing.JRadioButton $JRadioButton0;
    private javax.swing.JRadioButton $JRadioButton1;
    private javax.swing.JRadioButton $JRadioButton2;
    private javax.swing.JRadioButton $JRadioButton3;
    private javax.swing.JRadioButton $JRadioButton4;
    private javax.swing.JRadioButton $JRadioButton5;
    private javax.swing.JRadioButton $JRadioButton6;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return new String[]{ getDefaultSource(), "LabelStyleDemo.css" };
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LabelStyleDemo() {
        super();
        $initialize();
    }

    public LabelStyleDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JCheckBox getBackgroundCheckbox() {
        return backgroundCheckbox;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getBackgroundColor() {
        return backgroundColor;
    }

    public javax.swing.JSlider getBlue() {
        return blue;
    }

    public jaxx.runtime.swing.Table getDemoPanel() {
        return demoPanel;
    }

    public javax.swing.JSlider getDummySize() {
        return dummySize;
    }

    public javax.swing.JSlider getGreen() {
        return green;
    }

    public javax.swing.JSlider getRed() {
        return red;
    }

    public javax.swing.JTextField getText() {
        return text;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected jaxx.runtime.swing.VBox get$VBox1() {
        return $VBox1;
    }

    protected javax.swing.JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected javax.swing.JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected javax.swing.JRadioButton get$JRadioButton2() {
        return $JRadioButton2;
    }

    protected javax.swing.JRadioButton get$JRadioButton3() {
        return $JRadioButton3;
    }

    protected javax.swing.JRadioButton get$JRadioButton4() {
        return $JRadioButton4;
    }

    protected javax.swing.JRadioButton get$JRadioButton5() {
        return $JRadioButton5;
    }

    protected javax.swing.JRadioButton get$JRadioButton6() {
        return $JRadioButton6;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        demoPanel.add($Table0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(6, 3, 0, 0), 0, 0));
        demoPanel.add($VBox1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBackgroundCheckbox() {
        $objectMap.put("backgroundCheckbox", backgroundCheckbox = new javax.swing.JCheckBox());
        
        backgroundCheckbox.setName("backgroundCheckbox");
        backgroundCheckbox.setText(_("Show Background"));
    }

    protected void createBackgroundColor() {
        $objectMap.put("backgroundColor", backgroundColor = new jaxx.runtime.swing.JAXXButtonGroup());
    }

    protected void createBlue() {
        $objectMap.put("blue", blue = new javax.swing.JSlider());
        
        blue.setName("blue");
        blue.setValue(0);
        blue.setMaximum(255);
        blue.setValue(255);
        blue.setMajorTickSpacing(50);
        blue.setPaintTicks(true);
        blue.setMinorTickSpacing(10);
    }

    protected void createDemoPanel() {
        $objectMap.put("demoPanel", demoPanel = new jaxx.runtime.swing.Table());
        
        demoPanel.setName("demoPanel");
    }

    protected void createDummySize() {
        $objectMap.put("dummySize", dummySize = new javax.swing.JSlider());
        
        dummySize.setName("dummySize");
        dummySize.setValue(0);
        dummySize.setMaximum(60);
        dummySize.setMinimum(6);
        dummySize.setValue(36);
        dummySize.setMajorTickSpacing(6);
        dummySize.setPaintTicks(true);
        dummySize.setMinorTickSpacing(2);
    }

    protected void createGreen() {
        $objectMap.put("green", green = new javax.swing.JSlider());
        
        green.setName("green");
        green.setValue(0);
        green.setMaximum(255);
        green.setValue(0);
        green.setMajorTickSpacing(50);
        green.setPaintTicks(true);
        green.setMinorTickSpacing(10);
    }

    protected void createRed() {
        $objectMap.put("red", red = new javax.swing.JSlider());
        
        red.setName("red");
        red.setValue(0);
        red.setMaximum(255);
        red.setValue(128);
        red.setMajorTickSpacing(50);
        red.setPaintTicks(true);
        red.setMinorTickSpacing(10);
    }

    protected void createText() {
        $objectMap.put("text", text = new javax.swing.JTextField());
        
        text.setName("text");
        text.setColumns(15);
        jaxx.runtime.SwingUtil.setText(text, "Data Binding");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add(demoPanel);
        addChildrenToDemoPanel();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(text, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(red, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(green, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(blue, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(dummySize, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($JLabel5);
        // inline complete setup of $VBox1
        $VBox1.add(backgroundCheckbox);
        $VBox1.add($JRadioButton0);
        $VBox1.add($JRadioButton1);
        $VBox1.add($JRadioButton2);
        $VBox1.add($JRadioButton3);
        $VBox1.add($JRadioButton4);
        $VBox1.add($JRadioButton5);
        $VBox1.add($JRadioButton6);
        // inline complete setup of $JRadioButton0
        { javax.swing.ButtonGroup $buttonGroup = backgroundColor; $JRadioButton0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton0); }
        
        // inline complete setup of $JRadioButton1
        { javax.swing.ButtonGroup $buttonGroup = backgroundColor; $JRadioButton1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton1); }
        
        // inline complete setup of $JRadioButton2
        { javax.swing.ButtonGroup $buttonGroup = backgroundColor; $JRadioButton2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton2); }
        
        // inline complete setup of $JRadioButton3
        { javax.swing.ButtonGroup $buttonGroup = backgroundColor; $JRadioButton3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton3); }
        
        // inline complete setup of $JRadioButton4
        { javax.swing.ButtonGroup $buttonGroup = backgroundColor; $JRadioButton4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton4); }
        
        // inline complete setup of $JRadioButton5
        { javax.swing.ButtonGroup $buttonGroup = backgroundColor; $JRadioButton5.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton5); }
        
        // inline complete setup of $JRadioButton6
        { javax.swing.ButtonGroup $buttonGroup = backgroundColor; $JRadioButton6.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton6); }
        
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 19 property setters
        $JPanel0.setBorder(BorderFactory.createTitledBorder("Preview"));
        $VBox1.setBorder(BorderFactory.createTitledBorder("Background"));
        { $JRadioButton0.putClientProperty("$value", Color.RED);  Object $buttonGroup = $JRadioButton0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton1.putClientProperty("$value", Color.ORANGE);  Object $buttonGroup = $JRadioButton1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton2.putClientProperty("$value", Color.YELLOW);  Object $buttonGroup = $JRadioButton2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton3.putClientProperty("$value", Color.GREEN);  Object $buttonGroup = $JRadioButton3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton4.putClientProperty("$value", Color.CYAN);  Object $buttonGroup = $JRadioButton4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton5.putClientProperty("$value", Color.BLUE);  Object $buttonGroup = $JRadioButton5.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton6.putClientProperty("$value", new Color(160, 30, 255));  Object $buttonGroup = $JRadioButton6.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        red.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        green.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        blue.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        createDemoPanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("Text:"));
        createText();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("Red:"));
        createRed();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("Green:"));
        createGreen();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("Blue:"));
        createBlue();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("Size:"));
        createDummySize();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,90);
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setMargin(new Insets(0, 0, 0, 0));
        $VBox0.setVerticalAlignment(0);
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        // inline creation of $VBox1
        $objectMap.put("$VBox1", $VBox1 = new jaxx.runtime.swing.VBox());
        
        $VBox1.setName("$VBox1");
        $VBox1.setSpacing(0);
        createBackgroundCheckbox();
        // inline creation of $JRadioButton0
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new javax.swing.JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setSelected(true);
        $JRadioButton0.setText(_("Red"));
        // inline creation of $JRadioButton1
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new javax.swing.JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setText(_("Orange"));
        // inline creation of $JRadioButton2
        $objectMap.put("$JRadioButton2", $JRadioButton2 = new javax.swing.JRadioButton());
        
        $JRadioButton2.setName("$JRadioButton2");
        $JRadioButton2.setText(_("Yellow"));
        // inline creation of $JRadioButton3
        $objectMap.put("$JRadioButton3", $JRadioButton3 = new javax.swing.JRadioButton());
        
        $JRadioButton3.setName("$JRadioButton3");
        $JRadioButton3.setText(_("Green"));
        // inline creation of $JRadioButton4
        $objectMap.put("$JRadioButton4", $JRadioButton4 = new javax.swing.JRadioButton());
        
        $JRadioButton4.setName("$JRadioButton4");
        $JRadioButton4.setText(_("Cyan"));
        // inline creation of $JRadioButton5
        $objectMap.put("$JRadioButton5", $JRadioButton5 = new javax.swing.JRadioButton());
        
        $JRadioButton5.setName("$JRadioButton5");
        $JRadioButton5.setText(_("Blue"));
        // inline creation of $JRadioButton6
        $objectMap.put("$JRadioButton6", $JRadioButton6 = new javax.swing.JRadioButton());
        
        $JRadioButton6.setName("$JRadioButton6");
        $JRadioButton6.setText(_("Purple"));
        createBackgroundColor();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 17 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$VBOX0_BACKGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$VBOX0_BACKGROUND));
                }
                if (backgroundColor != null) {
                    backgroundColor.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null && backgroundColor != null) {
                    $VBox0.setBackground((Color)( backgroundCheckbox.isSelected() ? backgroundColor.getSelectedValue() : null));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$VBOX0_BACKGROUND));
                }
                if (backgroundColor != null) {
                    backgroundColor.removePropertyChangeListener("selectedValue", this);
                }
            }
        
            public void $pr$u0(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_FONT_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (dummySize != null) {
                    $bindingSources.put("dummySize.getModel()", dummySize.getModel());
                    dummySize.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    dummySize.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FONT_SIZE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (dummySize != null) {
                    if ($JLabel5.getFont() != null) {
                        $JLabel5.setFont($JLabel5.getFont().deriveFont((float) dummySize.getValue()));
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (dummySize != null) {
                    javax.swing.BoundedRangeModel $target = ((javax.swing.BoundedRangeModel) $bindingSources.remove("dummySize.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    dummySize.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FONT_SIZE));
                }
            }
        
            public void $pr$u1(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_FOREGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red.getModel()", red.getModel());
                    red.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    red.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (green != null) {
                    $bindingSources.put("green.getModel()", green.getModel());
                    green.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    green.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (blue != null) {
                    $bindingSources.put("blue.getModel()", blue.getModel());
                    blue.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    blue.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (red != null && blue != null && green != null) {
                    $JLabel5.setForeground(new Color(red.getValue(), green.getValue(), blue.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    javax.swing.BoundedRangeModel $target = ((javax.swing.BoundedRangeModel) $bindingSources.remove("red.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    red.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (green != null) {
                    javax.swing.BoundedRangeModel $target = ((javax.swing.BoundedRangeModel) $bindingSources.remove("green.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    green.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
                if (blue != null) {
                    javax.swing.BoundedRangeModel $target = ((javax.swing.BoundedRangeModel) $bindingSources.remove("blue.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    blue.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_FOREGROUND));
                }
            }
        
            public void $pr$u2(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (text != null) {
                    $bindingSources.put("text.getDocument()", text.getDocument());
                    text.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u3"));
                    text.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (text != null) {
                    $JLabel5.setText(_(text.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (text != null) {
                    javax.swing.text.Document $target = ((javax.swing.text.Document) $bindingSources.remove("text.getDocument()"));
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u3"));
                    }
                    text.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JLABEL5_TEXT));
                }
            }
        
            public void $pr$u3(javax.swing.event.DocumentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RED_STYLE_RED_HAS_FOCUS_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red", red);
                    red.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u4"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (red.hasFocus()) {
                    java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.demo.fun.LabelStyleDemo.this, red, "background", new Color(231, 173, 173), jaxx.runtime.css.Pseudoclasses.wrap(red.getBackground()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        red.setBackground((java.awt.Color) value);
                    }
                    value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.demo.fun.LabelStyleDemo.this, red, "border", new jaxx.runtime.css.DataBinding("red.border.0"), jaxx.runtime.css.Pseudoclasses.wrap(red.getBorder()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        red.setBorder((javax.swing.border.Border) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    javax.swing.JSlider $target = ((javax.swing.JSlider) $bindingSources.remove("red"));
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u4"));
                    }
                }
            }
        
            public void $pr$u4(java.awt.event.FocusEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RED_STYLE_RED_HAS_FOCUS_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red", red);
                    red.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u5"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!(red.hasFocus())) {
                    java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.demo.fun.LabelStyleDemo.this, red, "background", new Color(231, 173, 173), jaxx.runtime.css.Pseudoclasses.wrap(red.getBackground()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        red.setBackground((java.awt.Color) value);
                    }
                    value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.demo.fun.LabelStyleDemo.this, red, "border", new jaxx.runtime.css.DataBinding("red.border.0"), jaxx.runtime.css.Pseudoclasses.wrap(red.getBorder()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        red.setBorder((javax.swing.border.Border) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    javax.swing.JSlider $target = ((javax.swing.JSlider) $bindingSources.remove("red"));
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u5"));
                    }
                }
            }
        
            public void $pr$u5(java.awt.event.FocusEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GREEN_STYLE_GREEN_HAS_FOCUS_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if (green != null) {
                    $bindingSources.put("green", green);
                    green.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u6"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (green.hasFocus()) {
                    java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.demo.fun.LabelStyleDemo.this, green, "background", new Color(178, 231, 173), jaxx.runtime.css.Pseudoclasses.wrap(green.getBackground()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        green.setBackground((java.awt.Color) value);
                    }
                    value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.demo.fun.LabelStyleDemo.this, green, "border", new jaxx.runtime.css.DataBinding("green.border.0"), jaxx.runtime.css.Pseudoclasses.wrap(green.getBorder()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        green.setBorder((javax.swing.border.Border) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (green != null) {
                    javax.swing.JSlider $target = ((javax.swing.JSlider) $bindingSources.remove("green"));
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u6"));
                    }
                }
            }
        
            public void $pr$u6(java.awt.event.FocusEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GREEN_STYLE_GREEN_HAS_FOCUS_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if (green != null) {
                    $bindingSources.put("green", green);
                    green.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u7"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!(green.hasFocus())) {
                    java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.demo.fun.LabelStyleDemo.this, green, "background", new Color(178, 231, 173), jaxx.runtime.css.Pseudoclasses.wrap(green.getBackground()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        green.setBackground((java.awt.Color) value);
                    }
                    value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.demo.fun.LabelStyleDemo.this, green, "border", new jaxx.runtime.css.DataBinding("green.border.0"), jaxx.runtime.css.Pseudoclasses.wrap(green.getBorder()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        green.setBorder((javax.swing.border.Border) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (green != null) {
                    javax.swing.JSlider $target = ((javax.swing.JSlider) $bindingSources.remove("green"));
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u7"));
                    }
                }
            }
        
            public void $pr$u7(java.awt.event.FocusEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BLUE_STYLE_BLUE_HAS_FOCUS_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if (blue != null) {
                    $bindingSources.put("blue", blue);
                    blue.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u8"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (blue.hasFocus()) {
                    java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.demo.fun.LabelStyleDemo.this, blue, "background", new Color(173, 178, 231), jaxx.runtime.css.Pseudoclasses.wrap(blue.getBackground()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        blue.setBackground((java.awt.Color) value);
                    }
                    value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.demo.fun.LabelStyleDemo.this, blue, "border", new jaxx.runtime.css.DataBinding("blue.border.0"), jaxx.runtime.css.Pseudoclasses.wrap(blue.getBorder()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        blue.setBorder((javax.swing.border.Border) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (blue != null) {
                    javax.swing.JSlider $target = ((javax.swing.JSlider) $bindingSources.remove("blue"));
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u8"));
                    }
                }
            }
        
            public void $pr$u8(java.awt.event.FocusEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BLUE_STYLE_BLUE_HAS_FOCUS_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if (blue != null) {
                    $bindingSources.put("blue", blue);
                    blue.addFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u9"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!(blue.hasFocus())) {
                    java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.demo.fun.LabelStyleDemo.this, blue, "background", new Color(173, 178, 231), jaxx.runtime.css.Pseudoclasses.wrap(blue.getBackground()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        blue.setBackground((java.awt.Color) value);
                    }
                    value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.demo.fun.LabelStyleDemo.this, blue, "border", new jaxx.runtime.css.DataBinding("blue.border.0"), jaxx.runtime.css.Pseudoclasses.wrap(blue.getBorder()), 0);
                    if (!(value instanceof jaxx.runtime.css.DataBinding)) {
                        blue.setBorder((javax.swing.border.Border) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (blue != null) {
                    javax.swing.JSlider $target = ((javax.swing.JSlider) $bindingSources.remove("blue"));
                    if ($target != null) {
                        $target.removeFocusListener( JAXXUtil.getEventListener(FocusListener.class, this, "$pr$u9"));
                    }
                }
            }
        
            public void $pr$u9(java.awt.event.FocusEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton0.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON0_ENABLED));
                }
            }
        
            public void $pr$u10(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON1_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON1_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton1.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON1_ENABLED));
                }
            }
        
            public void $pr$u11(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u12"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton2.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u12"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON2_ENABLED));
                }
            }
        
            public void $pr$u12(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON3_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON3_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton3.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON3_ENABLED));
                }
            }
        
            public void $pr$u13(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON4_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON4_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton4.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON4_ENABLED));
                }
            }
        
            public void $pr$u14(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON5_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u15"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON5_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton5.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u15"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON5_ENABLED));
                }
            }
        
            public void $pr$u15(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JRADIO_BUTTON6_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (backgroundCheckbox != null) {
                    $bindingSources.put("backgroundCheckbox.getModel()", backgroundCheckbox.getModel());
                    backgroundCheckbox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u16"));
                    backgroundCheckbox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON6_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (backgroundCheckbox != null) {
                    $JRadioButton6.setEnabled(backgroundCheckbox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (backgroundCheckbox != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("backgroundCheckbox.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u16"));
                    }
                    backgroundCheckbox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.fun.LabelStyleDemo.this, BINDING_$JRADIO_BUTTON6_ENABLED));
                }
            }
        
            public void $pr$u16(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
    }

}