/*
 * *##% 
 * JAXX Demo
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.demo.component.jaxx.navigation.item;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.navigation.ItemNavigationCardPanel;
import jaxx.runtime.swing.navigation.ItemTreeNavigationAdapter;

/**
 *
 * @author letellier
 */
public class ExempleItemTreeNavigationAdapter extends ItemTreeNavigationAdapter{

    Item currentItem = null;

    public ExempleItemTreeNavigationAdapter(JAXXObject context, JAXXTree tree, ItemNavigationCardPanel cardPanel){
        super(context, tree, cardPanel);

        ItemTreeNavigationDemo demo = (ItemTreeNavigationDemo)context;
        demo.addPropertyChangeListener("date", new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (currentItem != null && !(currentItem.getValue() instanceof Class)){
                    currentItem.setValue((Date)evt.getNewValue());
                }
            }
        });
        
        demo.addPropertyChangeListener("string", new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (currentItem != null && !(currentItem.getValue() instanceof Class)){
                    currentItem.setValue((String)evt.getNewValue());
                }
            }
        });
    }
    
    @Override
    protected void valueChanged(Object data) {
        ItemTreeNavigationDemo demo = (ItemTreeNavigationDemo)context;
        currentItem = ((JAXXTreeModel)tree.getModel()).findItem(data);
        if (data instanceof String){
            demo.setString((String)data);
        } else if (data instanceof Date){
            demo.setDate((Date)data);
        } else {
            demo.setString("");
            demo.setDate(null);
        }
    }

}
