/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: ScriptInitializer.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.4/jaxx-compiler/src/main/java/jaxx/compiler/script/ScriptInitializer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.script;

import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptorHelper;

/**
 * A dummy CompiledObject which serves to initialize scripted field.  This is handled by
 * a CompiledObject rather than (say) simply inlining the initialization code in order to
 * ensure that the field is initialized in document order.
 */
public class ScriptInitializer extends CompiledObject {

    public ScriptInitializer(String initializer, JAXXCompiler compiler) {
//        super(compiler.getAutoId(ClassDescriptorHelper.getClassDescriptor(ScriptInitializer.class)),
        super(compiler.getAutoId(ScriptInitializer.class.getSimpleName()),
                ClassDescriptorHelper.getClassDescriptor(ScriptInitializer.class), compiler, false);
        appendInitializationCode(initializer);
    }
}
