/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: MemberDescriptor.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.10/jaxx-compiler/src/main/java/jaxx/compiler/reflect/MemberDescriptor.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.reflect;

/**
 * Mirrors the class <code>java.lang.ref.Member</code>.  JAXX uses <code>ClassDescriptor</code> instead of <code>Class</code>
 * almost everywhere so that it can handle circular dependencies (there can't be a <code>Class</code> object for an uncompiled
 * JAXX or Java source file, and a compiler must be allow references to symbols in uncompiled source files in order to handle
 * circular dependencies).
 */
public abstract class MemberDescriptor {

    private String name;
    private int modifiers;
    private ClassLoader classLoader;

    MemberDescriptor(String name, int modifiers, ClassLoader classLoader) {
        this.name = name;
        this.modifiers = modifiers;
        this.classLoader = classLoader;
    }

    public String getName() {
        return name;
    }

    public int getModifiers() {
        return modifiers;
    }

    protected ClassLoader getClassLoader() {
        return classLoader;
    }

    @Override
    public String toString() {
        return getClass().getName() + "[" + getName() + "]";
    }
}
