/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.finalizers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.finalizers.AbstractFinalizer;
import jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaElement;
import jaxx.compiler.java.JavaElementFactory;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.tags.validator.BeanValidatorHandler;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=JAXXCompilerFinalizer.class, hint="validators")
public class ValidatorFinalizer
extends AbstractFinalizer {
    static Log log = LogFactory.getLog(ValidatorFinalizer.class);
    protected static final JavaField VALIDATOR_IDS_FIELD = JavaElementFactory.newField(4, List.class.getName() + "<String>", "validatorIds", true, "new %s<String>()", ArrayList.class.getName());

    @Override
    public boolean accept(JAXXCompiler compiler) {
        return BeanValidatorHandler.hasValidator(compiler);
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        for (CompiledObject object : compiler.getObjects().values()) {
            List<CompiledObject.ChildRef> childs = object.getChilds();
            if (childs == null || childs.isEmpty()) continue;
            for (CompiledObject.ChildRef child : childs) {
                String javaCode = child.getChildJavaCode();
                boolean found = BeanValidatorHandler.isComponentUsedByValidator(compiler, child.getChild().getId());
                if (!found) continue;
                String type = compiler.getImportedType(SwingUtil.class);
                child.setChildJavaCode(type + ".boxComponentWithJxLayer(" + javaCode + ")");
            }
        }
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder builder = new StringBuilder();
        List<BeanValidatorHandler.CompiledBeanValidator> validators = BeanValidatorHandler.getValidators(compiler);
        String validatorUtilPrefix = compiler.getImportedType(SwingValidatorUtil.class) + ".";
        compiler.getJavaFile().addMethod(JavaElementFactory.newMethod(1, "void", "registerValidatorFields", validatorUtilPrefix + "detectValidatorFields(this);", true, new JavaArgument[0]));
        builder.append("// register ");
        builder.append(validators.size());
        builder.append(" validator(s)");
        builder.append(eol);
        builder.append("validatorIds = ");
        builder.append(validatorUtilPrefix).append("detectValidators(this);");
        builder.append(eol);
        builder.append(validatorUtilPrefix).append("installUI(this);");
        builder.append(eol);
        compiler.appendLateInitializer(builder.toString());
        for (BeanValidatorHandler.CompiledBeanValidator validator : validators) {
            this.registerValidator(validator, compiler, javaFile);
        }
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        Class<SwingValidator> validatorClass = SwingValidator.class;
        Class<JAXXValidator> validatorInterface = JAXXValidator.class;
        boolean parentIsValidator = compiler.isSuperClassAware(validatorInterface);
        if (parentIsValidator) {
            return;
        }
        javaFile.addInterface(JAXXCompiler.getCanonicalName(validatorInterface));
        this.addField(javaFile, VALIDATOR_IDS_FIELD);
        String type = compiler.getImportedType(validatorClass);
        String initializer = "return (" + type + "<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);";
        javaFile.addMethod(JavaElementFactory.newMethod(1, type + "<?>", "getValidator", initializer, true, JavaElementFactory.newArgument("String", "validatorId")));
    }

    public void registerValidator(BeanValidatorHandler.CompiledBeanValidator validator, JAXXCompiler compiler, JavaFile javaFile) {
        JavaField validatorField = javaFile.getField(validator.getId());
        String validatorId = TypeManager.getJavaCode(validator.getId());
        String type = compiler.getImportedType(Validator.class);
        String fieldType = compiler.getImportedType(ValidatorField.class);
        String validatorAnnotation = type + "( validatorId = " + validatorId + ")";
        validatorField.addAnnotation(validatorAnnotation);
        for (String component : validator.getFieldEditors()) {
            Collection<String> propertyNames = validator.getFieldPropertyNames(component);
            ArrayList keyCodes = Lists.newArrayListWithCapacity((int)propertyNames.size());
            for (String propertyName : propertyNames) {
                if (!validator.checkBeanProperty(compiler, propertyName)) continue;
                String keyCode = TypeManager.getJavaCode(propertyName);
                keyCodes.add(keyCode);
            }
            if (keyCodes.isEmpty()) continue;
            String keyCode = Joiner.on((String)", ").join((Iterable)keyCodes);
            if (keyCodes.size() > 1) {
                keyCode = "{ " + keyCode + " }";
            }
            String editorCode = TypeManager.getJavaCode(component);
            JavaElement editor = javaFile.getField(component);
            if (editor == null) {
                CompiledObject compiledObject;
                if (log.isDebugEnabled()) {
                    String message = "Could not find editor [" + component + "] for property(ies) [" + propertyNames + "] for file " + javaFile.getName();
                    log.debug((Object)message);
                }
                if ((compiledObject = compiler.getCompiledObject(component)) == null) {
                    String errorMessage = "Could not find editor [" + component + "] for property(ies) [" + propertyNames + "] for file " + javaFile.getName();
                    throw new CompilerException(errorMessage);
                }
                String fqn = JAXXCompiler.getCanonicalName(compiledObject);
                editor = javaFile.addGetterMethod(component, 1, fqn, true, true);
            }
            String annotation = fieldType + "( validatorId = " + validatorId + ",  propertyName = " + keyCode + ",  editorName = " + editorCode + ")";
            editor.addAnnotation(annotation);
        }
    }
}

