/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaConstructor;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.tasks.JAXXEngineTask;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.extension.ImportsManager;

public class GenerateTask
extends JAXXEngineTask {
    private static final Log log = LogFactory.getLog(GenerateTask.class);
    public static final String TASK_NAME = "Generate";

    public GenerateTask() {
        super(TASK_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        JAXXCompilerFile[] files;
        this.checkAllFilesCompiled(engine);
        boolean success = true;
        boolean verbose = engine.isVerbose();
        JavaFileGenerator generator = new JavaFileGenerator(JAXXCompiler.getLineSeparator(), verbose);
        for (JAXXCompilerFile jaxxFile : files = engine.getCompiledFiles()) {
            if (verbose) {
                log.info((Object)("start " + jaxxFile.getClassName()));
            }
            JAXXCompiler compiler = jaxxFile.getCompiler();
            this.addStartProfileTime(engine, compiler);
            try {
                this.consumeCompiler(compiler, generator);
            }
            finally {
                compiler.getJavaFile().clear();
            }
            this.addEndProfileTime(engine, compiler);
            if (!compiler.isFailed()) continue;
            success = false;
        }
        return success;
    }

    public void consumeCompiler(JAXXCompiler compiler, JavaFileGenerator generator) throws IOException {
        JavaFile javaFile = compiler.getJavaFile();
        String packageName = javaFile.getPackageName();
        List<String> imports = this.optimizeImports(javaFile, packageName, compiler.isNeedSwingUtil());
        String packageToExclude = packageName + ".*";
        for (String importFQN : javaFile.getImports()) {
            if (packageToExclude.equals(importFQN) || imports.contains(importFQN)) continue;
            imports.add(importFQN);
        }
        javaFile.setImports(imports);
        compiler.generate(generator);
    }

    public List<String> optimizeImports(JavaFile f, String packageName, boolean needSwingUtil) {
        ImportsManager importsManager = f.getImportManager();
        for (String importFQN : f.getImports()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add import : " + importFQN));
            }
            importsManager.addImport(importFQN);
        }
        if (f.getSuperClass() != null) {
            String superClass = f.getSuperClass();
            try {
                String type = importsManager.getType(superClass);
                f.setSuperClass(type);
            }
            catch (Exception e) {
                log.error((Object)("file [" + f.getName() + "] Could not determine simple name of super class " + superClass));
            }
        }
        List<String> interfaces = f.getInterfaces();
        ArrayList<String> interfaces2 = new ArrayList<String>(interfaces.size());
        for (String anInterface : interfaces) {
            try {
                String newInterface = importsManager.getType(anInterface);
                interfaces2.add(newInterface);
            }
            catch (Exception e) {
                log.error((Object)("file [" + f.getName() + "] Could not get interface " + anInterface + " :: " + e.getMessage()));
                interfaces2.add(anInterface);
            }
        }
        f.setInterfaces(interfaces2);
        this.optimizeConstructorParameters(f, importsManager);
        importsManager.addImport(JAXXUtil.class);
        if (!f.isSuperclassIsJAXXObject() || needSwingUtil) {
            importsManager.addImport(SwingUtil.class);
        }
        List result = importsManager.getImports(packageName);
        result.remove(packageName + ".*");
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + f.getName() + "] Detect " + result.size() + " imports to add."));
            for (String s : result) {
                log.debug((Object)(" " + s));
            }
        }
        return result;
    }

    protected void optimizeConstructorParameters(JavaFile f, ImportsManager importsManager) {
        List<JavaConstructor> constructors = f.getConstructors();
        for (JavaConstructor constructor : constructors) {
            JavaArgument[] arguments;
            for (JavaArgument argument : arguments = constructor.getArguments()) {
                String type = argument.getType();
                String simpleType = null;
                try {
                    simpleType = importsManager.getType(type);
                    argument.setType(simpleType);
                }
                catch (Exception e) {
                    log.error((Object)("file [" + f.getName() + "] Could not get simple type of constructor paramter  " + type + " :: " + e.getMessage()));
                }
            }
        }
    }
}

