/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.decorators;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.decorators.DefaultCompiledObjectDecorator;
import jaxx.compiler.java.JavaElementFactory;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.runtime.swing.help.JAXXHelpUI;

public class HelpRootCompiledObjectDecorator
extends DefaultCompiledObjectDecorator {
    protected static Set<String> helpIds = new HashSet<String>();

    @Override
    public String getName() {
        return "help";
    }

    protected String getBrokerFQN(JAXXCompiler compiler) {
        String helpBrokerFQN = compiler.getConfiguration().getHelpBrokerFQN();
        return helpBrokerFQN;
    }

    protected String getHelpId(CompiledObject o) {
        String helpID = null;
        if (o.hasClientProperties()) {
            helpID = o.getClientProperty("help");
        }
        return helpID;
    }

    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) throws ClassNotFoundException {
        super.finalizeCompiler(compiler, root, object, javaFile, packageName, className, fullClassName);
        CompilerConfiguration options = compiler.getConfiguration();
        if (options.isGenerateHelp()) {
            Class<JAXXHelpUI> validatorInterface = JAXXHelpUI.class;
            String helpBrokerFQN = this.getBrokerFQN(compiler);
            boolean needInterface = this.isNeedInterface(compiler, validatorInterface);
            if (needInterface) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add " + validatorInterface + " on " + javaFile.getName() + " : parent " + JAXXCompiler.getCanonicalName(compiler.getRootObject())));
                }
                javaFile.addInterface(validatorInterface.getName() + "<" + helpBrokerFQN + ">");
            }
            javaFile.addMethod(JavaElementFactory.newMethod(1, "void", "registerHelpId", "broker.installUI(component, helpId);", true, JavaElementFactory.newArgument(helpBrokerFQN, "broker"), JavaElementFactory.newArgument(Component.class.getName(), "component"), JavaElementFactory.newArgument("String", "helpId")));
            javaFile.addMethod(JavaElementFactory.newMethod(1, "void", "showHelp", "getBroker().showHelp(this, helpId);", true, JavaElementFactory.newArgument("String", "helpId")));
            StringBuilder buffer = new StringBuilder();
            String eol = JAXXCompiler.getLineSeparator();
            Iterator<CompiledObject> itr = compiler.getObjectCreationOrder();
            while (itr.hasNext()) {
                CompiledObject o = itr.next();
                String helpID = this.getHelpId(o);
                if (helpID == null) continue;
                buffer.append(eol);
                buffer.append("registerHelpId(_broker, ");
                buffer.append(o.getJavaCode());
                buffer.append(", ");
                buffer.append(helpID);
                buffer.append(");");
                helpIds.add(helpID);
            }
            if (buffer.length() > 0) {
                String type = compiler.getImportManager().getType(helpBrokerFQN);
                StringBuilder extraCode = new StringBuilder(type);
                extraCode.append(" _broker = getBroker();");
                buffer.append(eol).append("_broker.prepareUI(this);");
                buffer.append(eol);
                compiler.appendLateInitializer("// help broker setup" + eol);
                compiler.appendLateInitializer(extraCode.toString());
                compiler.appendLateInitializer(buffer.toString());
            }
        }
    }

    protected boolean isNeedInterface(JAXXCompiler compiler, Class<?> validatorInterface) throws ClassNotFoundException {
        if (compiler.isSuperClassAware(validatorInterface)) {
            return false;
        }
        CompiledObject root = compiler.getRootObject();
        ClassDescriptor rootObjectClass = root.getObjectClass();
        String superClassName = JAXXCompiler.getCanonicalName(rootObjectClass);
        JAXXCompiler parentCompiler = compiler.getEngine().getJAXXCompiler(superClassName);
        if (parentCompiler == null) {
            return true;
        }
        CompiledObjectDecorator decorator = parentCompiler.getRootObject().getDecorator();
        if (decorator != null && decorator instanceof HelpRootCompiledObjectDecorator) {
            return false;
        }
        boolean superClassResult = this.isNeedInterface(parentCompiler, validatorInterface);
        return superClassResult;
    }

    public static Set<String> getHelpIds() {
        return new HashSet<String>(helpIds);
    }
}

