/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: SwingFinalizer.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.4/jaxx-compiler/src/main/java/jaxx/compiler/finalizers/SwingFinalizer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.finalizers;

import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.java.JavaElementFactory;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.runtime.swing.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.SwingUtilities;
import java.lang.reflect.Modifier;

/**
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role-hint="swing" role="jaxx.compiler.finalizers.JAXXCompilerFinalizer"
 */
public class SwingFinalizer extends AbstractFinalizer {

    /** Logger. */
    protected static final Log log = LogFactory.getLog(DefaultFinalizer.class);

    @Override
    public boolean accept(JAXXCompiler compiler) {

        ClassDescriptor descriptor =
                ClassDescriptorHelper.getClassDescriptor(Application.class);
        CompiledObject root = compiler.getRootObject();
        boolean accept = descriptor.isAssignableFrom(root.getObjectClass());
        return accept;
    }

    @Override
    public void finalizeCompiler(CompiledObject root,
                                 JAXXCompiler compiler,
                                 JavaFile javaFile,
                                 String packageName,
                                 String className) {
    }

    @Override
    public void prepareJavaFile(CompiledObject root,
                                JAXXCompiler compiler,
                                JavaFile javaFile,
                                String packageName,
                                String className) throws ClassNotFoundException {

        if (compiler.isMainDeclared()) {

            // main method was already defined, can not generate this method.
            return;
        }

        javaFile.addImport(SwingUtilities.class);
        String code = "SwingUtilities.invokeLater(new Runnable() { " +
                      "public void run() { new " + className +
                      "().setVisible(true); } });";
        javaFile.addMethod(JavaElementFactory.newMethod(
                Modifier.PUBLIC | Modifier.STATIC,
                TYPE_VOID,
                "main",
                code,
                false,
                JavaElementFactory.newArgument("String[]", "arg")));
    }
}
