/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tasks;

import java.io.File;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.tasks.JAXXEngineTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompileFirstPassTask
extends JAXXEngineTask {
    private static final Log log = LogFactory.getLog(CompileFirstPassTask.class);
    public static final String TASK_NAME = "CompileFirstPass";

    public CompileFirstPassTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;
        JAXXCompilerFile[] undone = engine.getFilesToCompile();
        while (undone.length > 0) {
            for (JAXXCompilerFile jaxxFile : undone) {
                boolean successForFile = this.treatFile(engine, jaxxFile);
                if (successForFile) continue;
                success = false;
            }
            undone = engine.getFilesToCompile();
        }
        return success;
    }

    protected boolean treatFile(JAXXEngine engine, JAXXCompilerFile jaxxFile) throws Exception {
        boolean isVerbose = engine.isVerbose();
        if (isVerbose) {
            log.info((Object)("start " + jaxxFile.getClassName()));
        }
        boolean success = true;
        JAXXCompiler compiler = engine.newCompiler(jaxxFile);
        this.addStartProfileTime(engine, compiler);
        compiler.compileFirstPass();
        if (!compiler.isIdentCssFound()) {
            File cssFile = jaxxFile.getCssFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("test ident css file " + cssFile + " : " + isVerbose));
            }
            if (cssFile.exists()) {
                if (isVerbose) {
                    log.info((Object)("Auto import of css " + cssFile));
                }
                compiler.registerStyleSheetFile(cssFile, false);
            }
        }
        this.addEndProfileTime(engine, compiler);
        if (compiler.isFailed()) {
            success = false;
        }
        return success;
    }
}

