/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: CompileFirstPassTask.java 1865 2010-05-02 16:55:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.0.2/jaxx-compiler/src/main/java/jaxx/compiler/tasks/CompileFirstPassTask.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.compiler.tasks;

import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

/**
 * First compile pass task to validate jaxx files and look after dependencies.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public class CompileFirstPassTask extends JAXXEngineTask {

    /** Logger */
    private static final Log log = LogFactory.getLog(CompileFirstPassTask.class);

    private static final long serialVersionUID = -1L;

    public static final String TASK_NAME = "CompileFirstPass";

    public CompileFirstPassTask() {
        super(TASK_NAME);
    }

    protected boolean compiled;

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;
        compiled = true;
        while (compiled) {

            // at each round, says nothing has to be compiled
            // the method treateFile will if required change the state
            compiled = false;

            JAXXCompilerFile[] files = engine.getCompilingFiles();

            for (JAXXCompilerFile jaxxFile : files) {

                boolean successForFile = treateFile(engine, jaxxFile);

                if (!successForFile) {

                    // something is wrong...
                    success = false;
                }
            }
        }
        return success;
    }

    protected boolean treateFile(JAXXEngine engine,
                                 JAXXCompilerFile jaxxFile) throws Exception {

        boolean isVerbose = engine.isVerbose();

        if (isVerbose) {
            log.info(getName() + " for " + jaxxFile.getClassName());
        }

        JAXXCompiler compiler = jaxxFile.getCompiler();

        if (compiler != null) {

            // file already registred
            return true;
        }

        boolean success = true;

        // mark to have another round to treate new files
        compiled = true;

        CompilerConfiguration configuration = engine.getConfiguration();

        compiler = engine.newCompiler(jaxxFile);
        addStartProfileTime(engine, compiler);

        compiler.compileFirstPass();

        if (configuration.isAutoImportCss() && !compiler.isIdentCssFound()) {

            // check if can add ident css file

            File cssFile = jaxxFile.getCssFile();

            if (log.isDebugEnabled()) {
                log.debug("test ident css file " + cssFile + " : " + isVerbose);
            }
            if (cssFile.exists()) {

                compiler.setIdentCssFound(true);

                if (isVerbose) {
                    log.info("Auto import of css " + cssFile);
                }
                // ok add it
                compiler.registerStyleSheetFile(cssFile);
            }
        }
        addEndProfileTime(engine, compiler);

        if (compiler.isFailed()) {
            success = false;
        }
        return success;
    }
}
