/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.reflect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.SymbolTable;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.JavaFileParser;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassDescriptorLoader {
    private static final Log log = LogFactory.getLog(ClassDescriptorLoader.class);
    private static Map<String, ClassDescriptor> descriptors = new HashMap<String, ClassDescriptor>();

    private ClassDescriptorLoader() {
    }

    public static synchronized ClassDescriptor getClassDescriptor(String className) throws ClassNotFoundException {
        return ClassDescriptorLoader.getClassDescriptor(className, Thread.currentThread().getContextClassLoader());
    }

    public static synchronized ClassDescriptor getClassDescriptor(String className, ClassLoader classLoader) throws ClassNotFoundException {
        ClassDescriptor result = descriptors.get(className);
        if (result != null) {
            return result;
        }
        if (JAXXEngine.isRegistred() && JAXXEngine.get().getSymbolTable(className) != null) {
            result = ClassDescriptorLoader.createClassDescriptorFromSymbolTable(className, classLoader);
        } else {
            if (classLoader == null) {
                classLoader = ClassDescriptorLoader.class.getClassLoader();
            }
            String relativePath = className.replaceAll("\\.", "/");
            String relativePathPattern = ".*";
            long javaLastModified = -1L;
            URL javaFile = classLoader.getResource(relativePath + ".java");
            if (javaFile != null && javaFile.toString().startsWith("file:") && javaFile.toString().matches(relativePathPattern)) {
                javaLastModified = JAXXCompiler.URLtoFile(javaFile).lastModified();
            }
            long classLastModified = -1L;
            URL classFile = classLoader.getResource(relativePath + ".class");
            if (classFile != null && classFile.toString().startsWith("file:") && classFile.toString().matches(relativePathPattern)) {
                classLastModified = JAXXCompiler.URLtoFile(classFile).lastModified();
            }
            long jaxxLastModified = -1L;
            URL jaxxFile = classLoader.getResource(relativePath + ".jaxx");
            if (jaxxFile != null && jaxxFile.toString().startsWith("file:") && jaxxFile.toString().matches(relativePathPattern)) {
                File scriptFilePath;
                File jaxxFilePath = JAXXCompiler.URLtoFile(jaxxFile);
                jaxxLastModified = jaxxFilePath.lastModified();
                String simplePath = jaxxFilePath.getPath();
                File cssFilePath = new File((simplePath = simplePath.substring(0, simplePath.length() - ".jaxx".length())) + ".css");
                if (cssFilePath.exists()) {
                    jaxxLastModified = Math.max(jaxxLastModified, cssFilePath.lastModified());
                }
                if ((scriptFilePath = new File(simplePath + ".script")).exists()) {
                    jaxxLastModified = Math.max(jaxxLastModified, scriptFilePath.lastModified());
                }
            }
            if (jaxxLastModified != -1L && JAXXEngine.isRegistred() && JAXXEngine.get().getSymbolTable(className) == null) {
                jaxxLastModified = -1L;
            }
            if (javaLastModified != -1L || classLastModified != -1L || jaxxLastModified != -1L) {
                if (jaxxLastModified > classLastModified && jaxxLastModified > javaLastModified) {
                    result = ClassDescriptorLoader.createClassDescriptorFromSymbolTable(className, classLoader);
                } else if (javaLastModified > classLastModified && javaLastModified > jaxxLastModified) {
                    result = ClassDescriptorLoader.createClassDescriptorFromJavaSource(javaFile, classLoader);
                }
            }
            if (result == null) {
                Class<?> javaClass = ClassDescriptorLoader.getClass(className, classLoader);
                result = ClassDescriptorLoader.createClassDescriptorFromClass(javaClass);
            }
        }
        descriptors.put(className, result);
        return result;
    }

    public static ClassDescriptor getClassDescriptor(Class<?> javaClass) {
        try {
            return ClassDescriptorLoader.getClassDescriptor(javaClass.getName(), javaClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getPrimitiveBoxedClass(String className) throws ClassNotFoundException {
        if (className.equals("boolean")) {
            return Boolean.class;
        }
        if (className.equals("byte")) {
            return Byte.class;
        }
        if (className.equals("short")) {
            return Short.class;
        }
        if (className.equals("int")) {
            return Integer.class;
        }
        if (className.equals("long")) {
            return Long.class;
        }
        if (className.equals("float")) {
            return Float.class;
        }
        if (className.equals("double")) {
            return Double.class;
        }
        if (className.equals("char")) {
            return Character.class;
        }
        if (className.equals("void")) {
            return Void.class;
        }
        return null;
    }

    public static Class<?> getPrimitiveClass(String className) throws ClassNotFoundException {
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("void")) {
            return Void.TYPE;
        }
        int arrayCount = 0;
        while (className.endsWith("[]")) {
            ++arrayCount;
            className = className.substring(0, className.length() - 2);
        }
        if (arrayCount > 0) {
            Class<?> klass = ClassDescriptorLoader.getPrimitiveClass(className);
            if (klass == null) {
                return null;
            }
            klass = ClassDescriptorLoader.getPrimitiveBoxedClass(className);
            className = klass.getName();
            className = "L" + className + ";";
            while (arrayCount > 0) {
                className = "[" + className;
                --arrayCount;
            }
            return Class.forName(className);
        }
        return null;
    }

    public static Class<?> getClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> klass = ClassDescriptorLoader.getPrimitiveClass(className);
        if (klass != null) {
            return klass;
        }
        int arrayCount = 0;
        while (className.endsWith("[]")) {
            ++arrayCount;
            className = className.substring(0, className.length() - 2);
        }
        if (arrayCount > 0) {
            className = "L" + className + ";";
            while (arrayCount > 0) {
                className = "[" + className;
                --arrayCount;
            }
        }
        try {
            return classLoader != null ? Class.forName(className, true, classLoader) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            int dotIndex = className.lastIndexOf(".");
            if (dotIndex > -1) {
                String parentFQN = className.substring(0, dotIndex);
                String simpleName = className.substring(dotIndex + 1);
                try {
                    Class<?> parentClass = classLoader != null ? Class.forName(parentFQN, true, classLoader) : Class.forName(parentFQN);
                    for (Class<?> innerClass : parentClass.getClasses()) {
                        if (!simpleName.equals(innerClass.getSimpleName())) continue;
                        return innerClass;
                    }
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    private static MethodDescriptor createMethodDescriptor(Method javaMethod, ClassLoader classLoader) {
        String methodName = javaMethod.getName();
        int modifiers = javaMethod.getModifiers();
        String returnType = javaMethod.getReturnType().getName();
        Class<?>[] javaParameters = javaMethod.getParameterTypes();
        String[] parameters = new String[javaParameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = javaParameters[i].getName();
        }
        return new MethodDescriptor(methodName, modifiers, returnType, parameters, classLoader);
    }

    private static FieldDescriptor createFieldDescriptor(Field javaField, ClassLoader classLoader) {
        String fieldName = javaField.getName();
        int modifiers = javaField.getModifiers();
        String type = javaField.getType().getName();
        return new FieldDescriptor(fieldName, modifiers, type, classLoader);
    }

    private static JAXXObjectDescriptor getJAXXObjectDescriptor(Class<?> jaxxClass) {
        if (!JAXXObject.class.isAssignableFrom(jaxxClass) || jaxxClass == JAXXObject.class) {
            return null;
        }
        try {
            Method getJAXXObjectDescriptor = jaxxClass.getMethod("$getJAXXObjectDescriptor", new Class[0]);
            return (JAXXObjectDescriptor)getJAXXObjectDescriptor.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException("Expected JAXXObject " + jaxxClass.getName() + " to have a static method named $getJAXXObjectDescriptor");
        }
        catch (IllegalAccessException e) {
            throw new CompilerException("Expected JAXXObject " + jaxxClass.getName() + "'s $getJAXXObjectDescriptor method to be public");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassDescriptor createClassDescriptorFromJavaSource(URL javaSource, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("for source " + javaSource));
            }
            InputStream in = javaSource.openStream();
            InputStreamReader reader = new InputStreamReader(in, "utf-8");
            ClassDescriptor result = JavaFileParser.parseJavaFile(javaSource.toString(), reader, classLoader);
            ((Reader)reader).close();
            return result;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    private static ClassDescriptor createClassDescriptorFromSymbolTable(String className, ClassLoader classLoader) throws ClassNotFoundException {
        ClassDescriptor[] superclassInterfaces;
        final JAXXCompiler compiler = JAXXEngine.get().getJAXXCompiler(className);
        final SymbolTable symbolTable = JAXXEngine.get().getSymbolTable(className);
        if (symbolTable == null) {
            throw new CompilerException("Internal error: no symbol table was generated for class '" + className + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("for compiler " + compiler.getOutputClassName()));
        }
        ClassDescriptor superclass = ClassDescriptorLoader.getClassDescriptor(symbolTable.getSuperclassName(), classLoader);
        List<MethodDescriptor> publicMethods = symbolTable.getScriptMethods();
        List<FieldDescriptor> publicFields = symbolTable.getScriptFields();
        Iterator<MethodDescriptor> methods = publicMethods.iterator();
        while (methods.hasNext()) {
            MethodDescriptor method = methods.next();
            if (Modifier.isPublic(method.getModifiers())) continue;
            methods.remove();
        }
        Iterator<FieldDescriptor> fields = publicFields.iterator();
        while (fields.hasNext()) {
            FieldDescriptor field = fields.next();
            if (Modifier.isPublic(field.getModifiers())) continue;
            fields.remove();
        }
        HashSet<String> interfaces = new HashSet<String>();
        if (symbolTable.getInterfaces() != null) {
            for (String anInterface : symbolTable.getInterfaces()) {
                int genericIndex = anInterface.indexOf("<");
                if (genericIndex > -1) {
                    anInterface = anInterface.substring(0, genericIndex);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getting interface " + anInterface + " descriptor for class " + className));
                }
                interfaces.add(anInterface);
                ClassDescriptor interfaceclass = ClassDescriptorLoader.getClassDescriptor(anInterface, classLoader);
                publicMethods.addAll(Arrays.asList(interfaceclass.getMethodDescriptors()));
                publicFields.addAll(Arrays.asList(interfaceclass.getFieldDescriptors()));
            }
        }
        publicMethods.addAll(Arrays.asList(superclass.getMethodDescriptors()));
        publicFields.addAll(Arrays.asList(superclass.getFieldDescriptors()));
        int dotPos = className.lastIndexOf(".");
        String packageName = dotPos != -1 ? className.substring(0, dotPos) : null;
        for (ClassDescriptor superclassInterface : superclassInterfaces = superclass.getInterfaces()) {
            interfaces.add(superclassInterface.getName());
        }
        interfaces.add(JAXXObject.class.getName());
        return new ClassDescriptor(className, packageName, symbolTable.getSuperclassName(), interfaces.toArray(new String[interfaces.size()]), false, false, null, null, classLoader, publicMethods.toArray(new MethodDescriptor[publicMethods.size()]), publicFields.toArray(new FieldDescriptor[publicFields.size()])){

            @Override
            public FieldDescriptor getDeclaredFieldDescriptor(String name) throws NoSuchFieldException {
                String type = symbolTable.getClassTagIds().get(name);
                if (type != null) {
                    return new FieldDescriptor(name, 4, type, compiler.getClassLoader());
                }
                throw new NoSuchFieldException(name);
            }

            @Override
            public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
                throw new NoSuchMethodException(name);
            }

            @Override
            public JAXXObjectDescriptor getJAXXObjectDescriptor() {
                return compiler.getJAXXObjectDescriptor();
            }
        };
    }

    private static ClassDescriptor createClassDescriptorFromClass(final Class<?> javaClass) {
        String name = javaClass.getName();
        Package p = javaClass.getPackage();
        String packageName = p != null ? p.getName() : null;
        Class<?> superclass = javaClass.getSuperclass();
        String superclassName = superclass != null ? superclass.getName() : null;
        Class<?>[] interfaces = javaClass.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = interfaces[i].getName();
        }
        boolean isInterface = javaClass.isInterface();
        boolean isArray = javaClass.isArray();
        String componentTypeName = isArray ? javaClass.getComponentType().getName() : null;
        JAXXObjectDescriptor jaxxObjectDescriptor = ClassDescriptorLoader.getJAXXObjectDescriptor(javaClass);
        ClassLoader classLoader = javaClass.getClassLoader();
        Method[] javaMethods = javaClass.getMethods();
        MethodDescriptor[] methods = new MethodDescriptor[javaMethods.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = ClassDescriptorLoader.createMethodDescriptor(javaMethods[i], javaClass.getClassLoader());
        }
        Field[] javaFields = javaClass.getFields();
        FieldDescriptor[] fields = new FieldDescriptor[javaFields.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = ClassDescriptorLoader.createFieldDescriptor(javaFields[i], javaClass.getClassLoader());
        }
        return new ClassDescriptor(name, packageName, superclassName, interfaceNames, isInterface, isArray, componentTypeName, jaxxObjectDescriptor, classLoader, methods, fields){

            @Override
            public FieldDescriptor getDeclaredFieldDescriptor(String name) throws NoSuchFieldException {
                return ClassDescriptorLoader.createFieldDescriptor(javaClass.getDeclaredField(name), javaClass.getClassLoader());
            }

            @Override
            public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
                try {
                    Class[] parameterTypeClasses = new Class[parameterTypes.length];
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        parameterTypeClasses[i] = Class.forName(parameterTypes[i].getName());
                    }
                    return ClassDescriptorLoader.createMethodDescriptor(javaClass.getDeclaredMethod(name, parameterTypeClasses), javaClass.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static void checkSupportClass(Class<?> handlerClass, ClassDescriptor beanClass, Class<?> ... tagClasses) {
        for (Class<?> tagClass : tagClasses) {
            if (!ClassDescriptorLoader.getClassDescriptor(tagClass).isAssignableFrom(beanClass)) continue;
            return;
        }
        throw new IllegalArgumentException(handlerClass.getName() + " does not support the class " + beanClass.getName());
    }

    public static void reset() {
        descriptors.clear();
    }
}

