/*
 * *##% 
 * JAXX Compiler
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.compiler;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.File;
import jaxx.runtime.JAXXContext;

/**
 * Options of the {@link JAXXCompiler} and {@link JAXXCompilerLaunchor}.
 * 
 */
public class DefaultCompilerConfiguration implements CompilerConfiguration {

    /**
     * where to generate
     */
    private File targetDirectory;
    /**
     * flag to optimize generated code
     */
    private boolean optimize;
    /**
     * verbose flag
     */
    private boolean verbose;
    /**
     * to do a profile pass after generation
     */
    private boolean profile;
    /** 
     * a flag to enable or disable i18n generation
     */
    private boolean i18nable;
    /** 
     * a flag to add or not logger on generated jaxx files
     */
    private boolean addLogger;
    /** 
     * a flag to not reset compiler after a compile
     */
    private boolean resetAfterCompile;
    /**
     * the name of implementation of {@link jaxx.runtime.JAXXContext}
     * to be used on {@link jaxx.runtime.JAXXObject}.
     */
    protected Class<? extends JAXXContext> jaxxContextClass;
    /** 
     * list of fqn of class to import for all generated jaxx files
     */
    protected String[] extraImports;
    /** 
     * default error ui
     */
    private Class<?> defaultErrorUI;
    /**
     * class loader to use in compiler
     */
    private ClassLoader classLoader;
    /**
     * the compiler class to use
     */
    private Class<? extends JAXXCompiler> compilerClass;
    /**
     * the validator class to use.
     *
     * @since 1.6.0
     */
    private Class<?> validatorClass;
    /**
     * the default compiled object decorator to use if none specifed via
     * decorator attribute
     */
    private Class<? extends CompiledObjectDecorator> defaultDecoratorClass;
    /** 
     * a flag to use {@link javax.swing.UIManager} to retreave icons.
     */
    private boolean useUIManagerForIcon;
    /** 
     * a flag to generate javax help for any
     */
    private boolean generateHelp;
    /**
     * Fully qualified name of help broker, can not use a class here
     * since this class should be in sources (so not yet compiled)
     */
    private String helpBrokerFQN;
    /**
     * Encoding to use to write files
     */
    private String encoding;

    @Override
    public File getTargetDirectory() {
        return targetDirectory;
    }

    @Override
    public boolean getOptimize() {
        return optimize;
    }

    @Override
    public boolean isVerbose() {
        return verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isI18nable() {
        return i18nable;
    }

    @Override
    public boolean isUseUIManagerForIcon() {
        return useUIManagerForIcon;
    }

    @Override
    public boolean isAddLogger() {
        return addLogger;
    }

    @Override
    public Class<? extends JAXXContext> getJaxxContextClass() {
        return jaxxContextClass;
    }

    @Override
    public String[] getExtraImports() {
        return extraImports;
    }

    @Override
    public boolean isResetAfterCompile() {
        return resetAfterCompile;
    }

    @Override
    public boolean isOptimize() {
        return optimize;
    }

    @Override
    public Class<?> getDefaultErrorUI() {
        return defaultErrorUI;
    }

    @Override
    public ClassLoader getClassLoader() {
        return classLoader;
    }

    @Override
    public Class<? extends JAXXCompiler> getCompilerClass() {
        return compilerClass;
    }

    @Override
    public Class<? extends CompiledObjectDecorator> getDefaultDecoratorClass() {
        return defaultDecoratorClass;
    }

    @Override
    public boolean isProfile() {
        return profile;
    }

    @Override
    public boolean isGenerateHelp() {
        return generateHelp;
    }

    @Override
    public String getHelpBrokerFQN() {
        return helpBrokerFQN;
    }

    @Override
    public Class<?> getValidatorClass() {
        return validatorClass;
    }

    @Override
    public String getEncoding() {
        return encoding;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}
